/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.Pointer;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.threading.DaemonThreadFactory;

@JRubyClass(name={"FFI::AutoPointer"}, parent="JRuby::FFI::AbstractMemoryPointer")
public class AutoPointer
extends Pointer {
    public static final String CLASS_NAME = "AutoPointer";
    private final Pointer pointer;
    private final PointerHolder holder;

    public static RubyClass createAutoPointerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder(CLASS_NAME, module.getClass("Pointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(AutoPointer.class);
        result.defineAnnotatedConstants(AutoPointer.class);
        return result;
    }

    private AutoPointer(Ruby runtime2, Pointer pointer2, IRubyObject proc2) {
        super(runtime2, runtime2.fastGetModule("FFI").fastGetClass(CLASS_NAME), pointer2.getMemoryIO(), pointer2.getSize());
        this.pointer = pointer2;
        this.holder = new PointerHolder(pointer2, proc2);
    }

    @JRubyMethod(name={"__alloc"}, meta=true)
    public static IRubyObject newAutoPointer(ThreadContext context, IRubyObject self, IRubyObject pointerArg, IRubyObject proc2) {
        return new AutoPointer(context.getRuntime(), (Pointer)pointerArg, proc2);
    }

    protected AbstractMemory slice(Ruby runtime2, long offset2) {
        return this.pointer.slice(runtime2, offset2);
    }

    protected Pointer getPointer(Ruby runtime2, long offset2) {
        return this.pointer.getPointer(runtime2, offset2);
    }

    private static final class Reaper
    implements Runnable {
        private final Pointer pointer;
        private final IRubyObject proc;

        private Reaper(Pointer pointer2, IRubyObject proc2) {
            this.pointer = pointer2;
            this.proc = proc2;
        }

        public void run() {
            try {
                this.proc.callMethod(this.pointer.getRuntime().getCurrentContext(), "call", this.pointer);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private static final class PointerHolder {
        private static final Executor executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory());
        private final Pointer pointer;
        private final IRubyObject proc;

        private PointerHolder(Pointer pointer2, IRubyObject proc2) {
            this.pointer = pointer2;
            this.proc = proc2;
        }

        protected void finalize() throws Exception {
            executor.execute(new Reaper(this.pointer, this.proc));
        }
    }
}

