/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArgGetValue;
import com.caucho.quercus.env.ArrayCopyValueImpl;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.CopyRoot;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.util.RandomUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayValueImpl
extends ArrayValue
implements Serializable {
    private static final Logger log = Logger.getLogger(ArrayValueImpl.class.getName());
    private static final StringValue KEY = new StringBuilderValue("key");
    private static final StringValue VALUE = new StringBuilderValue("value");
    private static final int DEFAULT_SIZE = 16;
    private static final int SORT_REGULAR = 0;
    private static final int SORT_NUMERIC = 1;
    private static final int SORT_STRING = 2;
    private static final int SORT_LOCALE_STRING = 5;
    private ArrayValue.Entry[] _entries;
    private int _hashMask;
    private int _size;
    private long _nextAvailableIndex;
    private boolean _isDirty;
    private ArrayValue.Entry _head;
    private ArrayValue.Entry _tail;

    public ArrayValueImpl() {
        this._entries = new ArrayValue.Entry[16];
        this._hashMask = this._entries.length - 1;
    }

    public ArrayValueImpl(int size) {
        int capacity;
        for (capacity = 16; capacity < 4 * size; capacity *= 2) {
        }
        this._entries = new ArrayValue.Entry[capacity];
        this._hashMask = this._entries.length - 1;
    }

    public ArrayValueImpl(ArrayValue copy) {
        this(copy.getSize());
        ArrayValue.Entry ptr = copy.getHead();
        while (ptr != null) {
            this.put(ptr._key, ptr._value.copyArrayItem());
            ptr = ptr._next;
        }
    }

    public ArrayValueImpl(ArrayValueImpl copy) {
        copy._isDirty = true;
        this._isDirty = true;
        this._size = copy._size;
        this._entries = copy._entries;
        this._hashMask = copy._hashMask;
        this._head = copy._head;
        this._current = copy._current;
        this._tail = copy._tail;
        this._nextAvailableIndex = copy._nextAvailableIndex;
    }

    public ArrayValueImpl(Env env, IdentityHashMap<Value, Value> map, ArrayValue copy) {
        this();
        map.put(copy, this);
        ArrayValue.Entry ptr = copy.getHead();
        while (ptr != null) {
            this.put(ptr._key, ptr._value.toValue().copy(env, map));
            ptr = ptr._next;
        }
    }

    protected ArrayValueImpl(Env env, ArrayValue copy, CopyRoot root) {
        this();
        ArrayValue.Entry ptr = copy.getHead();
        while (ptr != null) {
            this.put(ptr._key, ptr._value.toValue().copyTree(env, root));
            ptr = ptr._next;
        }
    }

    public ArrayValueImpl(Value[] keys, Value[] values) {
        this();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] != null) {
                this.put(keys[i], values[i]);
                continue;
            }
            this.put(values[i]);
        }
    }

    public ArrayValueImpl(Value[] values) {
        this();
        for (int i = 0; i < values.length; ++i) {
            this.put(values[i]);
        }
    }

    private void copyOnWrite() {
        if (!this._isDirty) {
            return;
        }
        this._isDirty = false;
        ArrayValue.Entry[] entries = new ArrayValue.Entry[this._entries.length];
        ArrayValue.Entry prev = null;
        ArrayValue.Entry ptr = this._head;
        while (ptr != null) {
            ArrayValue.Entry ptrCopy = new ArrayValue.Entry(ptr._key, ptr._value.copyArrayItem());
            ArrayValue.Entry head = entries[ptr._index];
            if (head != null) {
                ptrCopy._nextHash = head;
                head._prevHash = ptrCopy;
            }
            entries[ptr._index] = ptrCopy;
            ptrCopy._index = ptr._index;
            if (prev == null) {
                this._head = this._current = ptrCopy;
            } else {
                prev._next = ptrCopy;
                ptrCopy._prev = prev;
            }
            prev = ptrCopy;
            ptr = ptr._next;
        }
        this._tail = prev;
        this._entries = entries;
    }

    @Override
    public String getType() {
        return "array";
    }

    @Override
    public boolean toBoolean() {
        return this._size != 0;
    }

    @Override
    public StringValue toString(Env env) {
        return env.createString("Array");
    }

    @Override
    public Object toObject() {
        return null;
    }

    @Override
    public Value copy() {
        this._isDirty = true;
        return new ArrayValueImpl(this);
    }

    @Override
    public Value copyReturn() {
        this._isDirty = true;
        return new ArrayValueImpl(this);
    }

    @Override
    public Value copy(Env env, IdentityHashMap<Value, Value> map) {
        Value oldValue = map.get(this);
        if (oldValue != null) {
            return oldValue;
        }
        return new ArrayValueImpl(env, map, this);
    }

    @Override
    public Value copyTree(Env env, CopyRoot root) {
        return new ArrayCopyValueImpl(env, this, root);
    }

    @Override
    public Value toArgValue() {
        return this.copy();
    }

    @Override
    public Value toRefValue() {
        return this;
    }

    public int size() {
        return this._size;
    }

    @Override
    public int getSize() {
        return this.size();
    }

    @Override
    public void clear() {
        if (this._isDirty) {
            this._entries = new ArrayValue.Entry[this._entries.length];
            this._isDirty = false;
        }
        this._size = 0;
        this._current = null;
        this._tail = null;
        this._head = null;
        this._nextAvailableIndex = 0L;
        for (int j = this._entries.length - 1; j >= 0; --j) {
            this._entries[j] = null;
        }
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public ArrayValue append(Value key, Value value) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        if (key instanceof UnsetValue) {
            key = this.createTailKey();
        }
        ArrayValue.Entry entry = this.createEntry(key);
        Value oldValue = entry._value;
        if (value instanceof Var) {
            Var var = (Var)value;
            var.setReference();
            entry._value = var;
        } else if (oldValue instanceof Var) {
            oldValue.set(value);
        } else {
            entry._value = value;
        }
        return this;
    }

    @Override
    public ArrayValue unshift(Value value) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        ++this._size;
        if (this._entries.length <= 2 * this._size) {
            this.expand();
        }
        Value key = this.createTailKey();
        ArrayValue.Entry entry = new ArrayValue.Entry(key, value.toArgValue());
        this.addEntry(entry);
        if (this._head != null) {
            this._head._prev = entry;
            entry._next = this._head;
            this._head = entry;
        } else {
            this._head = this._tail = entry;
        }
        return this;
    }

    @Override
    public ArrayValue splice(int start, int end, ArrayValue replace) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        int index = 0;
        ArrayValueImpl result = new ArrayValueImpl();
        ArrayValue.Entry ptr = this._head;
        ArrayValue.Entry next = null;
        while (ptr != null) {
            next = ptr._next;
            Value key = ptr.getKey();
            if (index >= start) {
                if (index < end) {
                    --this._size;
                    if (ptr._prev != null) {
                        ptr._prev._next = ptr._next;
                    } else {
                        this._head = ptr._next;
                    }
                    if (ptr._next != null) {
                        ptr._next._prev = ptr._prev;
                    } else {
                        this._tail = ptr._prev;
                    }
                    if (ptr.getKey() instanceof StringValue) {
                        result.put(ptr.getKey(), ptr.getValue());
                    } else {
                        result.put(ptr.getValue());
                    }
                } else {
                    if (replace == null) {
                        return result;
                    }
                    ArrayValue.Entry replaceEntry = replace.getHead();
                    while (replaceEntry != null) {
                        ++this._size;
                        if (this._entries.length <= 2 * this._size) {
                            this.expand();
                        }
                        ArrayValue.Entry entry = new ArrayValue.Entry(this.createTailKey(), replaceEntry.getValue());
                        this.addEntry(entry);
                        entry._next = ptr;
                        entry._prev = ptr._prev;
                        if (ptr._prev != null) {
                            ptr._prev._next = entry;
                        } else {
                            this._head = entry;
                        }
                        ptr._prev = entry;
                        replaceEntry = replaceEntry._next;
                    }
                    return result;
                }
            }
            ++index;
            ptr = next;
        }
        if (replace != null) {
            ArrayValue.Entry replaceEntry = replace.getHead();
            while (replaceEntry != null) {
                this.put(replaceEntry.getValue());
                replaceEntry = replaceEntry._next;
            }
        }
        return result;
    }

    @Override
    public Value getArg(Value index) {
        ArrayValue.Entry entry;
        if (this._isDirty) {
            this.copyOnWrite();
        }
        if ((entry = this.getEntry(index)) != null) {
            Value arg = entry.toArg();
            return arg;
        }
        return new ArgGetValue(this, index);
    }

    @Override
    public Value getObject(Env env, Value fieldName) {
        Value value = this.get(fieldName);
        if (!value.isset()) {
            value = env.createObject();
            this.put(fieldName, value);
        }
        return value;
    }

    @Override
    public Value getArray(Value index) {
        Value array;
        Value value;
        if (this._isDirty) {
            this.copyOnWrite();
        }
        if ((value = this.get(index)) != (array = value.toAutoArray())) {
            value = array;
            this.put(index, value);
        }
        return value;
    }

    @Override
    public Value getDirty(Value index) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        return this.get(index);
    }

    @Override
    public Value put(Value value) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        Value key = this.createTailKey();
        this.put(key, value);
        return value;
    }

    @Override
    public Value putRef() {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        Value tailKey = this.createTailKey();
        return this.getRef(tailKey);
    }

    @Override
    public Value createTailKey() {
        return LongValue.create(this._nextAvailableIndex);
    }

    @Override
    public Value get(Value key) {
        key = key.toKey();
        int hashMask = this._hashMask;
        int hash = key.hashCode() & hashMask;
        ArrayValue.Entry entry = this._entries[hash];
        while (entry != null) {
            if (key.equals(entry._key)) {
                return entry._value.toValue();
            }
            entry = entry._nextHash;
        }
        return UnsetValue.UNSET;
    }

    @Override
    public Value getRaw(Value key) {
        key = key.toKey();
        int hashMask = this._hashMask;
        int hash = key.hashCode() & hashMask;
        ArrayValue.Entry entry = this._entries[hash];
        while (entry != null) {
            if (key.equals(entry._key)) {
                return entry._value;
            }
            entry = entry._nextHash;
        }
        return UnsetValue.UNSET;
    }

    @Override
    public Value containsKey(Value key) {
        ArrayValue.Entry entry = this.getEntry(key);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    private ArrayValue.Entry getEntry(Value key) {
        key = key.toKey();
        int hash = key.hashCode() & this._hashMask;
        ArrayValue.Entry entry = this._entries[hash];
        while (entry != null) {
            if (key.equals(entry._key)) {
                return entry;
            }
            entry = entry._nextHash;
        }
        return null;
    }

    @Override
    public boolean isset(Value key) {
        key = key.toKey();
        int hash = key.hashCode() & this._hashMask;
        ArrayValue.Entry entry = this._entries[hash];
        while (entry != null) {
            if (key.equals(entry._key)) {
                return true;
            }
            entry = entry._nextHash;
        }
        return false;
    }

    @Override
    public Value remove(Value key) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        int capacity = this._entries.length;
        key = key.toKey();
        int hash = key.hashCode() & this._hashMask;
        ArrayValue.Entry entry = this._entries[hash];
        while (entry != null) {
            if (key.equals(entry._key)) {
                ArrayValue.Entry nextHash = entry._nextHash;
                ArrayValue.Entry prevHash = entry._prevHash;
                if (nextHash != null) {
                    nextHash._prevHash = prevHash;
                }
                if (prevHash != null) {
                    prevHash._nextHash = nextHash;
                } else {
                    this._entries[hash] = nextHash;
                }
                ArrayValue.Entry next = entry._next;
                ArrayValue.Entry prev = entry._prev;
                if (prev != null) {
                    prev._next = next;
                } else {
                    this._head = next;
                }
                if (next != null) {
                    next._prev = prev;
                } else {
                    this._tail = prev;
                }
                entry._prev = null;
                entry._next = null;
                this._current = this._head;
                --this._size;
                Value value = entry.getValue();
                if (key.nextIndex(-1L) == this._nextAvailableIndex) {
                    this.updateNextAvailableIndex();
                }
                return value;
            }
            entry = entry._nextHash;
        }
        return UnsetValue.UNSET;
    }

    @Override
    public Var getRef(Value index) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        ArrayValue.Entry entry = this.createEntry(index);
        Value value = entry._value;
        if (value instanceof Var) {
            return (Var)value;
        }
        Var var = new Var(value);
        entry.setValue(var);
        return var;
    }

    private ArrayValue.Entry createEntry(Value key) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        key = key.toKey();
        int hashMask = this._hashMask;
        int hash = key.hashCode() & hashMask;
        ArrayValue.Entry entry = this._entries[hash];
        while (entry != null) {
            if (key.equals(entry._key)) {
                return entry;
            }
            entry = entry._nextHash;
        }
        ++this._size;
        ArrayValue.Entry newEntry = new ArrayValue.Entry(key);
        this._nextAvailableIndex = key.nextIndex(this._nextAvailableIndex);
        ArrayValue.Entry head = this._entries[hash];
        if (head != null) {
            head._prevHash = newEntry;
        }
        newEntry._nextHash = head;
        this._entries[hash] = newEntry;
        newEntry._index = hash;
        if (this._head == null) {
            newEntry._prev = null;
            newEntry._next = null;
            this._head = newEntry;
            this._tail = newEntry;
            this._current = newEntry;
        } else {
            newEntry._prev = this._tail;
            newEntry._next = null;
            this._tail._next = newEntry;
            this._tail = newEntry;
        }
        if (this._entries.length <= 2 * this._size) {
            this.expand();
        }
        return newEntry;
    }

    private void expand() {
        ArrayValue.Entry[] entries = this._entries;
        this._entries = new ArrayValue.Entry[2 * entries.length];
        this._hashMask = this._entries.length - 1;
        ArrayValue.Entry entry = this._head;
        while (entry != null) {
            this.addEntry(entry);
            entry = entry._next;
        }
    }

    private void addEntry(ArrayValue.Entry entry) {
        ArrayValue.Entry head;
        int capacity = this._entries.length;
        int hash = entry._key.hashCode() & this._hashMask;
        entry._nextHash = head = this._entries[hash];
        entry._prevHash = null;
        if (head != null) {
            head._prevHash = entry;
        }
        this._entries[hash] = entry;
        this._nextAvailableIndex = entry._key.nextIndex(this._nextAvailableIndex);
        entry._index = hash;
    }

    private void updateNextAvailableIndex() {
        this._nextAvailableIndex = 0L;
        ArrayValue.Entry entry = this._head;
        while (entry != null) {
            this._nextAvailableIndex = entry._key.nextIndex(this._nextAvailableIndex);
            entry = entry._next;
        }
    }

    @Override
    public Value pop() {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        if (this._tail != null) {
            Value value = this.remove(this._tail._key);
            return value;
        }
        return BooleanValue.FALSE;
    }

    @Override
    public ArrayValue.Entry getHead() {
        return this._head;
    }

    @Override
    protected ArrayValue.Entry getTail() {
        return this._tail;
    }

    @Override
    public void shuffle() {
        ArrayValue.Entry[] values;
        int length;
        if (this._isDirty) {
            this.copyOnWrite();
        }
        if ((length = (values = new ArrayValue.Entry[this.size()]).length) == 0) {
            return;
        }
        int i = 0;
        ArrayValue.Entry ptr = this._head;
        while (ptr != null) {
            values[i++] = ptr;
            ptr = ptr._next;
        }
        for (i = 0; i < length; ++i) {
            int rand = RandomUtil.nextInt((int)length);
            ArrayValue.Entry temp = values[rand];
            values[rand] = values[i];
            values[i] = temp;
        }
        this._head = values[0];
        this._head._prev = null;
        this._tail = values[values.length - 1];
        this._tail._next = null;
        for (i = 0; i < length; ++i) {
            if (i > 0) {
                values[i]._prev = values[i - 1];
            }
            if (i >= length - 1) continue;
            values[i]._next = values[i + 1];
        }
        this._current = this._head;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this._size);
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        int capacity;
        int size = in.readInt();
        for (capacity = 16; capacity < 4 * size; capacity *= 2) {
        }
        this._entries = new ArrayValue.Entry[capacity];
        this._hashMask = this._entries.length - 1;
        for (int i = 0; i < size; ++i) {
            this.put((Value)in.readObject(), (Value)in.readObject());
        }
    }
}

