/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.program.InterpretedClassDef;
import com.caucho.util.L10N;

public class ThisFieldExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(ThisFieldExpr.class);
    protected final InterpretedClassDef _quercusClass;
    protected final StringValue _name;

    public ThisFieldExpr(Location location, InterpretedClassDef quercusClass, StringValue name) {
        super(location);
        this._quercusClass = quercusClass;
        this._name = name;
    }

    public ThisFieldExpr(InterpretedClassDef quercusClass, StringValue name) {
        this._quercusClass = quercusClass;
        this._name = name;
    }

    private Value cannotUseThisError(Env env) {
        return env.error(this.getLocation(), "Cannot use '$this' when not in object context.");
    }

    public Value eval(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getThisField(env, this._name);
    }

    public Value evalCopy(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getThisField(env, this._name).copy();
    }

    public Value evalRef(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getThisFieldRef(env, this._name);
    }

    public Value evalArg(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getThisFieldArg(env, this._name);
    }

    public void evalAssign(Env env, Value value) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            this.cannotUseThisError(env);
        }
        obj.putThisField(env, this._name, value);
    }

    public Value evalArray(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getThisFieldArray(env, this._name);
    }

    public Value evalObject(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getThisFieldObject(env, this._name);
    }

    public void evalUnset(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            this.cannotUseThisError(env);
        }
        obj.unsetThisField(this._name);
    }

    public String toString() {
        return "$this->" + this._name;
    }
}

