/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.expr.FunctionExpr;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarFunctionExpr
extends Expr {
    private static final L10N L = new L10N(FunctionExpr.class);
    protected final Expr _name;
    protected final Expr[] _args;

    public VarFunctionExpr(Location location, Expr name, ArrayList<Expr> args) {
        super(location);
        this._name = name;
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public VarFunctionExpr(Location location, Expr name, Expr[] args) {
        super(location);
        this._name = name;
        this._args = args;
    }

    public VarFunctionExpr(Expr name, ArrayList<Expr> args) {
        this(Location.UNKNOWN, name, args);
    }

    public VarFunctionExpr(Expr name, Expr[] args) {
        this(Location.UNKNOWN, name, args);
    }

    @Override
    public Expr createRef(QuercusParser parser) {
        return parser.getFactory().createRef(this);
    }

    @Override
    public Expr createCopy(ExprFactory factory) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value eval(Env env) {
        Value name = this._name.eval(env);
        AbstractFunction fun = env.getFunction(name);
        env.pushCall(this, NullValue.NULL, null);
        try {
            env.checkTimeout();
            Value value = fun.call(env, this._args);
            return value;
        }
        finally {
            env.popCall();
        }
    }

    @Override
    public Value evalRef(Env env) {
        return env.getFunction(this._name.eval(env)).callRef(env, this._args);
    }

    @Override
    public String toString() {
        return this._name + "()";
    }
}

