/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.JavaArrayMarshal;
import com.caucho.quercus.function.Marshal;

public class JavaByteObjectArrayMarshal
extends JavaArrayMarshal {
    public static final Marshal MARSHAL = new JavaByteObjectArrayMarshal();

    public Value unmarshal(Env env, Object value) {
        Byte[] byteValue = (Byte[])value;
        if (byteValue == null) {
            return NullValue.NULL;
        }
        byte[] data = new byte[byteValue.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = byteValue[i];
        }
        return env.createBinaryBuilder(data);
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue.isString()) {
            if (argValue.isUnicode()) {
                return 106;
            }
            if (argValue.isBinary()) {
                return 105;
            }
            return 104;
        }
        if (argValue.isArray()) {
            return 300;
        }
        return 400;
    }

    public Class getExpectedClass() {
        return Byte[].class;
    }
}

