/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.util.L10N;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public class BcmathModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(BcmathModule.class);
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal ONE = BigDecimal.ONE;
    private static final BigDecimal TWO = new BigDecimal(2);
    private static final int SQRT_MAX_ITERATIONS = 50;
    private static final IniDefinitions _iniDefinitions = new IniDefinitions();
    public static final IniDefinition INI_BCMATH_SCALE = _iniDefinitions.add("bcmath.scale", 0L, 7);

    public String[] getLoadedExtensions() {
        return new String[]{"bcmath"};
    }

    public IniDefinitions getIniDefinitions() {
        return _iniDefinitions;
    }

    private static BigDecimal toBigDecimal(Value value) {
        try {
            if (value instanceof StringValue) {
                return new BigDecimal(value.toString());
            }
            if (value instanceof DoubleValue) {
                return new BigDecimal(value.toDouble());
            }
            if (value instanceof LongValue) {
                return new BigDecimal(value.toLong());
            }
            return new BigDecimal(value.toString());
        }
        catch (NumberFormatException ex) {
            return ZERO;
        }
        catch (IllegalArgumentException ex) {
            return ZERO;
        }
    }

    private static int calculateScale(Env env, int scale) {
        StringValue iniValue;
        if (scale < 0 && (iniValue = env.getIni("bcmath.scale")) != null) {
            scale = iniValue.toInt();
        }
        if (scale < 0) {
            scale = 0;
        }
        return scale;
    }

    public static String bcadd(Env env, Value value1, Value value2, @Optional(value="-1") int scale) {
        scale = BcmathModule.calculateScale(env, scale);
        BigDecimal bd1 = BcmathModule.toBigDecimal(value1);
        BigDecimal bd2 = BcmathModule.toBigDecimal(value2);
        BigDecimal bd = bd1.add(bd2);
        bd = bd.setScale(scale, RoundingMode.DOWN);
        return bd.toPlainString();
    }

    public static int bccomp(Env env, Value value1, Value value2, @Optional(value="-1") int scale) {
        scale = BcmathModule.calculateScale(env, scale);
        BigDecimal bd1 = BcmathModule.toBigDecimal(value1);
        BigDecimal bd2 = BcmathModule.toBigDecimal(value2);
        bd1 = bd1.setScale(scale, RoundingMode.DOWN);
        bd2 = bd2.setScale(scale, RoundingMode.DOWN);
        return bd1.compareTo(bd2);
    }

    public static String bcdiv(Env env, Value value1, Value value2, @Optional(value="-1") int scale) {
        scale = BcmathModule.calculateScale(env, scale);
        BigDecimal bd1 = BcmathModule.toBigDecimal(value1);
        BigDecimal bd2 = BcmathModule.toBigDecimal(value2);
        if (bd2.compareTo(ZERO) == 0) {
            env.warning(L.l("division by zero"));
            return null;
        }
        BigDecimal result = scale > 0 ? bd1.divide(bd2, scale + 2, RoundingMode.DOWN) : bd1.divide(bd2, 2, RoundingMode.DOWN);
        result = result.setScale(scale, RoundingMode.DOWN);
        return result.toPlainString();
    }

    public static String bcmod(Env env, Value value, Value modulus) {
        BigDecimal bd1 = BcmathModule.toBigDecimal(value).setScale(0, RoundingMode.DOWN);
        BigDecimal bd2 = BcmathModule.toBigDecimal(modulus).setScale(0, RoundingMode.DOWN);
        if (bd2.compareTo(ZERO) == 0) {
            env.warning(L.l("division by zero"));
            return null;
        }
        BigDecimal bd = bd1.remainder(bd2, MathContext.DECIMAL128);
        bd = bd.setScale(0, RoundingMode.DOWN);
        return bd.toPlainString();
    }

    public static String bcmul(Env env, Value value1, Value value2, @Optional(value="-1") int scale) {
        BigDecimal bd2;
        scale = BcmathModule.calculateScale(env, scale);
        BigDecimal bd1 = BcmathModule.toBigDecimal(value1);
        BigDecimal bd = bd1.multiply(bd2 = BcmathModule.toBigDecimal(value2));
        if (bd.compareTo(ZERO) == 0) {
            if (scale > 0) {
                return "0.0";
            }
            return "0";
        }
        bd = bd.setScale(scale, RoundingMode.DOWN);
        bd = bd.stripTrailingZeros();
        return bd.toPlainString();
    }

    public static String bcpow(Env env, Value base, Value exp, @Optional(value="-1") int scale) {
        boolean isNeg;
        int exponent;
        scale = BcmathModule.calculateScale(env, scale);
        BigDecimal bd1 = BcmathModule.toBigDecimal(base);
        BigDecimal bd2 = BcmathModule.toBigDecimal(exp);
        if (bd2.scale() > 0) {
            env.warning("fractional exponent not supported");
        }
        if ((exponent = bd2.toBigInteger().intValue()) == 0) {
            return "1";
        }
        if (exponent < 0) {
            isNeg = true;
            exponent *= -1;
        } else {
            isNeg = false;
        }
        BigDecimal bd = bd1.pow(exponent);
        if (isNeg) {
            bd = ONE.divide(bd, scale + 2, RoundingMode.DOWN);
        }
        if ((bd = bd.setScale(scale, RoundingMode.DOWN)).compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        bd = bd.stripTrailingZeros();
        return bd.toPlainString();
    }

    public static String bcpowmod(Env env, Value base, Value exp, Value modulus, @Optional(value="-1") int scale) {
        String pow = BcmathModule.bcpow(env, base, exp, scale = BcmathModule.calculateScale(env, scale));
        if (pow == null) {
            return null;
        }
        return BcmathModule.bcmod(env, env.createString(pow), modulus);
    }

    public static boolean bcscale(Env env, int scale) {
        env.setIni("bcmath.scale", String.valueOf(scale));
        return true;
    }

    public static String bcsqrt(Env env, Value operand, @Optional(value="-1") int scale) {
        int cscale;
        BigDecimal initialGuess;
        scale = BcmathModule.calculateScale(env, scale);
        BigDecimal value = BcmathModule.toBigDecimal(operand);
        int compareToZero = value.compareTo(ZERO);
        if (compareToZero < 0) {
            env.warning(L.l("square root of negative number"));
            return null;
        }
        if (compareToZero == 0) {
            return "0";
        }
        int compareToOne = value.compareTo(ONE);
        if (compareToOne == 0) {
            return "1";
        }
        if (compareToOne < 1) {
            initialGuess = ONE;
            cscale = value.scale();
        } else {
            BigInteger integerPart = value.toBigInteger();
            int length = integerPart.toString().length();
            if (length % 2 == 0) {
                --length;
            }
            initialGuess = ONE.movePointRight(length /= 2);
            cscale = Math.max(scale, value.scale()) + 2;
        }
        BigDecimal guess = initialGuess;
        for (int iteration = 0; iteration < 50; ++iteration) {
            BigDecimal lastGuess = guess;
            guess = value.divide(guess, cscale, RoundingMode.DOWN);
            guess = guess.add(lastGuess);
            if (lastGuess.equals(guess = guess.divide(TWO, cscale, RoundingMode.DOWN))) break;
        }
        value = guess;
        value = value.setScale(scale, RoundingMode.DOWN);
        return value.toPlainString();
    }

    public static String bcsub(Env env, Value value1, Value value2, @Optional(value="-1") int scale) {
        scale = BcmathModule.calculateScale(env, scale);
        BigDecimal bd1 = BcmathModule.toBigDecimal(value1);
        BigDecimal bd2 = BcmathModule.toBigDecimal(value2);
        BigDecimal bd = bd1.subtract(bd2);
        bd = bd.setScale(scale, RoundingMode.DOWN);
        return bd.toPlainString();
    }
}

