/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.ConstArrayValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.regexp.RegexpModule;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;

public class HtmlModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(HtmlModule.class);
    public static final int HTML_SPECIALCHARS = 0;
    public static final int HTML_ENTITIES = 1;
    public static final int ENT_HTML_QUOTE_NONE = 0;
    public static final int ENT_HTML_QUOTE_SINGLE = 1;
    public static final int ENT_HTML_QUOTE_DOUBLE = 2;
    public static final int ENT_COMPAT = 2;
    public static final int ENT_QUOTES = 3;
    public static final int ENT_NOQUOTES = 0;
    private static final ArrayValue HTML_SPECIALCHARS_ARRAY = new ConstArrayValue();
    private static final ArrayValue HTML_ENTITIES_ARRAY = new ConstArrayValue();
    private static ArrayValueImpl HTML_ENTITIES_ARRAY_UNICODE;
    private static ArrayValueImpl HTML_SPECIALCHARS_ARRAY_UNICODE;

    private static ConstArrayValue toUnicodeArray(Env env, ArrayValue array) {
        ConstArrayValue copy = new ConstArrayValue();
        Iterator<Map.Entry<Value, Value>> iter = array.getIterator(env);
        while (iter.hasNext()) {
            Map.Entry<Value, Value> entry = iter.next();
            Value key = entry.getKey();
            Value value = entry.getValue();
            if (key.isString()) {
                key = key.toUnicodeValue(env);
            }
            if (value.isString()) {
                value = value.toUnicodeValue(env);
            }
            copy.put(key, value);
        }
        return copy;
    }

    public Value get_html_translation_table(Env env, @Optional(value="HTML_SPECIALCHARS") int table, @Optional(value="ENT_COMPAT") int quoteStyle) {
        Value result;
        if (!env.isUnicodeSemantics()) {
            result = table == 1 ? HTML_ENTITIES_ARRAY.copy() : HTML_SPECIALCHARS_ARRAY.copy();
        } else if (table == 1) {
            if (HTML_ENTITIES_ARRAY_UNICODE == null) {
                HTML_ENTITIES_ARRAY_UNICODE = HtmlModule.toUnicodeArray(env, HTML_ENTITIES_ARRAY);
            }
            result = HTML_ENTITIES_ARRAY_UNICODE.copy();
        } else {
            if (HTML_SPECIALCHARS_ARRAY_UNICODE == null) {
                HTML_SPECIALCHARS_ARRAY_UNICODE = HtmlModule.toUnicodeArray(env, HTML_SPECIALCHARS_ARRAY);
            }
            result = HTML_SPECIALCHARS_ARRAY_UNICODE.copy();
        }
        if ((quoteStyle & 1) != 0) {
            result.put(env.createString('\''), env.createString("&apos;"));
        }
        if ((quoteStyle & 2) != 0) {
            result.put(env.createString('\"'), env.createString("&quot;"));
        }
        return result;
    }

    public static StringValue htmlspecialchars_decode(Env env, StringValue str, @Optional(value="ENT_COMPAT") int quoteStyle) {
        int len = str.length();
        StringValue sb = str.createStringBuilder(len * 4 / 5);
        block7: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch != '&') {
                sb.append(ch);
                continue;
            }
            switch (str.charAt(i + 1)) {
                case 'a': {
                    sb.append('&');
                    if (i + 4 >= len || str.charAt(i + 2) != 'm' || str.charAt(i + 3) != 'p' || str.charAt(i + 4) != ';') continue block7;
                    i += 4;
                    continue block7;
                }
                case 'q': {
                    if ((quoteStyle & 2) != 0 && i + 5 < len && str.charAt(i + 2) == 'u' && str.charAt(i + 3) == 'o' && str.charAt(i + 4) == 't' && str.charAt(i + 5) == ';') {
                        i += 5;
                        sb.append('\"');
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                case '#': {
                    if ((quoteStyle & 1) != 0 && i + 5 < len && str.charAt(i + 2) == '0' && str.charAt(i + 3) == '3' && str.charAt(i + 4) == '9' && str.charAt(i + 5) == ';') {
                        i += 5;
                        sb.append('\'');
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                case 'l': {
                    if (i + 3 < len && str.charAt(i + 2) == 't' && str.charAt(i + 3) == ';') {
                        i += 3;
                        sb.append('<');
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                case 'g': {
                    if (i + 3 < len && str.charAt(i + 2) == 't' && str.charAt(i + 3) == ';') {
                        i += 3;
                        sb.append('>');
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                default: {
                    sb.append('&');
                }
            }
        }
        return sb;
    }

    public static Value htmlspecialchars(Env env, StringValue string, @Optional(value="ENT_COMPAT") int quoteStyle, @Optional String charset) {
        int len = string.length();
        StringValue sb = string.createStringBuilder(len * 5 / 4);
        block7: for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    if ((quoteStyle & 2) != 0) {
                        sb.append("&quot;");
                        continue block7;
                    }
                    sb.append(ch);
                    continue block7;
                }
                case '\'': {
                    if ((quoteStyle & 1) != 0) {
                        sb.append("&#039;");
                        continue block7;
                    }
                    sb.append(ch);
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb;
    }

    public static Value htmlentities(Env env, StringValue string, @Optional(value="ENT_COMPAT") int quoteStyle, @Optional String charset) {
        ArrayValue entitiesArray;
        Reader reader;
        if (charset == null || charset.length() == 0) {
            charset = "ISO-8859-1";
        }
        try {
            reader = string.toReader(charset);
        }
        catch (UnsupportedEncodingException e) {
            env.warning(e);
            reader = new StringReader(string.toString());
        }
        StringValue sb = string.createStringBuilder(string.length() * 5 / 4);
        if (env.isUnicodeSemantics()) {
            if (HTML_ENTITIES_ARRAY_UNICODE == null) {
                HTML_ENTITIES_ARRAY_UNICODE = HtmlModule.toUnicodeArray(env, HTML_ENTITIES_ARRAY);
            }
            entitiesArray = HTML_ENTITIES_ARRAY_UNICODE;
        } else {
            entitiesArray = HTML_ENTITIES_ARRAY;
        }
        try {
            int ch;
            while ((ch = reader.read()) >= 0) {
                StringValue chV = env.createString((char)ch);
                Value entity = entitiesArray.get(chV);
                if (entity.isNull()) {
                    entity = chV;
                }
                if (ch == 34) {
                    entity = (quoteStyle & 2) != 0 ? env.createString("&quot;") : chV;
                } else if (ch == 39) {
                    entity = (quoteStyle & 1) != 0 ? env.createString("&#039;") : chV;
                }
                sb.append(entity);
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        return sb;
    }

    public static StringValue html_entity_decode(Env env, StringValue string, @Optional int quoteStyle, @Optional String charset) {
        if (string.length() == 0) {
            return env.getEmptyString();
        }
        Iterator<Map.Entry<Value, Value>> iter = env.isUnicodeSemantics() ? HTML_ENTITIES_ARRAY_UNICODE.getIterator(env) : HTML_ENTITIES_ARRAY.getIterator(env);
        while (iter.hasNext()) {
            Map.Entry<Value, Value> entry = iter.next();
            StringValue key = entry.getKey().toStringValue();
            StringValue value = entry.getValue().toStringValue();
            string = RegexpModule.ereg_replace(env, value, key, string).toStringValue();
        }
        return string;
    }

    public static Value nl2br(Env env, StringValue string) {
        int strLen = string.length();
        StringValue sb = string.createStringBuilder(strLen * 5 / 4);
        for (int i = 0; i < strLen; ++i) {
            char ch = string.charAt(i);
            if (ch == '\n') {
                sb.append("<br />\n");
                continue;
            }
            if (ch == '\r') {
                if (i + 1 < strLen && string.charAt(i + 1) == '\n') {
                    sb.append("<br />\r\n");
                    ++i;
                    continue;
                }
                sb.append("<br />\r");
                continue;
            }
            sb.append(ch);
        }
        return sb;
    }

    private static void entity(int ch, String entity) {
        HTML_ENTITIES_ARRAY.put("" + (char)ch, entity);
    }

    static {
        HTML_SPECIALCHARS_ARRAY.put("<", "&lt;");
        HTML_SPECIALCHARS_ARRAY.put(">", "&gt;");
        HTML_SPECIALCHARS_ARRAY.put("&", "&amp;");
        HtmlModule.entity(60, "&lt;");
        HtmlModule.entity(62, "&gt;");
        HtmlModule.entity(38, "&amp;");
        HtmlModule.entity(160, "&nbsp;");
        HtmlModule.entity(161, "&iexcl;");
        HtmlModule.entity(162, "&cent;");
        HtmlModule.entity(163, "&pound;");
        HtmlModule.entity(164, "&curren;");
        HtmlModule.entity(165, "&yen;");
        HtmlModule.entity(166, "&brvbar;");
        HtmlModule.entity(167, "&sect;");
        HtmlModule.entity(168, "&uml;");
        HtmlModule.entity(169, "&copy;");
        HtmlModule.entity(170, "&ordf;");
        HtmlModule.entity(171, "&laquo;");
        HtmlModule.entity(172, "&not;");
        HtmlModule.entity(173, "&shy;");
        HtmlModule.entity(174, "&reg;");
        HtmlModule.entity(175, "&macr;");
        HtmlModule.entity(176, "&deg;");
        HtmlModule.entity(177, "&plusmn;");
        HtmlModule.entity(178, "&sup2;");
        HtmlModule.entity(179, "&sup3;");
        HtmlModule.entity(180, "&acute;");
        HtmlModule.entity(181, "&micro;");
        HtmlModule.entity(182, "&para;");
        HtmlModule.entity(183, "&middot;");
        HtmlModule.entity(184, "&cedil;");
        HtmlModule.entity(185, "&sup1;");
        HtmlModule.entity(186, "&ordm;");
        HtmlModule.entity(187, "&raquo;");
        HtmlModule.entity(188, "&frac14;");
        HtmlModule.entity(189, "&frac12;");
        HtmlModule.entity(190, "&frac34;");
        HtmlModule.entity(191, "&iquest;");
        HtmlModule.entity(192, "&Agrave;");
        HtmlModule.entity(193, "&Aacute;");
        HtmlModule.entity(194, "&Acirc;");
        HtmlModule.entity(195, "&Atilde;");
        HtmlModule.entity(196, "&Auml;");
        HtmlModule.entity(197, "&Aring;");
        HtmlModule.entity(198, "&AElig;");
        HtmlModule.entity(199, "&Ccedil;");
        HtmlModule.entity(200, "&Egrave;");
        HtmlModule.entity(201, "&Eacute;");
        HtmlModule.entity(202, "&Ecirc;");
        HtmlModule.entity(203, "&Euml;");
        HtmlModule.entity(204, "&Igrave;");
        HtmlModule.entity(205, "&Iacute;");
        HtmlModule.entity(206, "&Icirc;");
        HtmlModule.entity(207, "&Iuml;");
        HtmlModule.entity(208, "&ETH;");
        HtmlModule.entity(209, "&Ntilde;");
        HtmlModule.entity(210, "&Ograve;");
        HtmlModule.entity(211, "&Oacute;");
        HtmlModule.entity(212, "&Ocirc;");
        HtmlModule.entity(213, "&Otilde;");
        HtmlModule.entity(214, "&Ouml;");
        HtmlModule.entity(215, "&times;");
        HtmlModule.entity(216, "&Oslash;");
        HtmlModule.entity(217, "&Ugrave;");
        HtmlModule.entity(218, "&Uacute;");
        HtmlModule.entity(219, "&Ucirc;");
        HtmlModule.entity(220, "&Uuml;");
        HtmlModule.entity(221, "&Yacute;");
        HtmlModule.entity(222, "&THORN;");
        HtmlModule.entity(223, "&szlig;");
        HtmlModule.entity(224, "&agrave;");
        HtmlModule.entity(225, "&aacute;");
        HtmlModule.entity(226, "&acirc;");
        HtmlModule.entity(227, "&atilde;");
        HtmlModule.entity(228, "&auml;");
        HtmlModule.entity(229, "&aring;");
        HtmlModule.entity(230, "&aelig;");
        HtmlModule.entity(231, "&ccedil;");
        HtmlModule.entity(232, "&egrave;");
        HtmlModule.entity(233, "&eacute;");
        HtmlModule.entity(234, "&ecirc;");
        HtmlModule.entity(235, "&euml;");
        HtmlModule.entity(236, "&igrave;");
        HtmlModule.entity(237, "&iacute;");
        HtmlModule.entity(238, "&icirc;");
        HtmlModule.entity(239, "&iuml;");
        HtmlModule.entity(240, "&eth;");
        HtmlModule.entity(241, "&ntilde;");
        HtmlModule.entity(242, "&ograve;");
        HtmlModule.entity(243, "&oacute;");
        HtmlModule.entity(244, "&ocirc;");
        HtmlModule.entity(245, "&otilde;");
        HtmlModule.entity(246, "&ouml;");
        HtmlModule.entity(247, "&divide;");
        HtmlModule.entity(248, "&oslash;");
        HtmlModule.entity(249, "&ugrave;");
        HtmlModule.entity(250, "&uacute;");
        HtmlModule.entity(251, "&ucirc;");
        HtmlModule.entity(252, "&uuml;");
        HtmlModule.entity(253, "&yacute;");
        HtmlModule.entity(254, "&thorn;");
        HtmlModule.entity(255, "&yuml;");
    }
}

