/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.Mysqli;
import com.caucho.quercus.lib.db.PDOError;
import com.caucho.quercus.lib.db.PDOStatement;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDO
implements EnvCleanup {
    private static final Logger log = Logger.getLogger(PDO.class.getName());
    private static final L10N L = new L10N(PDO.class);
    public static final int ATTR_AUTOCOMMIT = 0;
    public static final int ATTR_PREFETCH = 1;
    public static final int ATTR_TIMEOUT = 2;
    public static final int ATTR_ERRMODE = 3;
    public static final int ATTR_SERVER_VERSION = 4;
    public static final int ATTR_CLIENT_VERSION = 5;
    public static final int ATTR_SERVER_INFO = 6;
    public static final int ATTR_CONNECTION_STATUS = 7;
    public static final int ATTR_CASE = 8;
    public static final int ATTR_CURSOR_NAME = 9;
    public static final int ATTR_CURSOR = 10;
    public static final int ATTR_ORACLE_NULLS = 11;
    public static final int ATTR_PERSISTENT = 12;
    public static final int ATTR_STATEMENT_CLASS = 13;
    public static final int ATTR_FETCH_TABLE_NAMES = 14;
    public static final int ATTR_FETCH_CATALOG_NAMES = 15;
    public static final int ATTR_DRIVER_NAME = 16;
    public static final int ATTR_STRINGIFY_FETCHES = 17;
    public static final int ATTR_MAX_COLUMN_LEN = 18;
    public static final int CASE_NATURAL = 0;
    public static final int CASE_UPPER = 1;
    public static final int CASE_LOWER = 2;
    public static final int CURSOR_FWDONLY = 0;
    public static final int CURSOR_SCROLL = 1;
    public static final String ERR_NONE = "00000";
    public static final int ERRMODE_SILENT = 0;
    public static final int ERRMODE_WARNING = 1;
    public static final int ERRMODE_EXCEPTION = 2;
    public static final int FETCH_LAZY = 1;
    public static final int FETCH_ASSOC = 2;
    public static final int FETCH_NUM = 3;
    public static final int FETCH_BOTH = 4;
    public static final int FETCH_OBJ = 5;
    public static final int FETCH_BOUND = 6;
    public static final int FETCH_COLUMN = 7;
    public static final int FETCH_CLASS = 8;
    public static final int FETCH_INTO = 9;
    public static final int FETCH_FUNC = 10;
    public static final int FETCH_NAMED = 11;
    public static final int FETCH_GROUP = 65536;
    public static final int FETCH_UNIQUE = 196608;
    public static final int FETCH_CLASSTYPE = 262144;
    public static final int FETCH_SERIALIZE = 524288;
    public static final int FETCH_ORI_NEXT = 0;
    public static final int FETCH_ORI_PRIOR = 1;
    public static final int FETCH_ORI_FIRST = 2;
    public static final int FETCH_ORI_LAST = 3;
    public static final int FETCH_ORI_ABS = 4;
    public static final int FETCH_ORI_REL = 5;
    public static final int NULL_NATURAL = 0;
    public static final int NULL_EMPTY_STRING = 1;
    public static final int NULL_TO_STRING = 2;
    public static final int PARAM_NULL = 0;
    public static final int PARAM_INT = 1;
    public static final int PARAM_STR = 2;
    public static final int PARAM_LOB = 3;
    public static final int PARAM_STMT = 4;
    public static final int PARAM_BOOL = 5;
    public static final int PARAM_INPUT_OUTPUT = Integer.MIN_VALUE;
    private final Env _env;
    private final String _dsn;
    private String _user;
    private String _password;
    private final PDOError _error;
    private Connection _conn;
    private Statement _lastStatement;
    private PDOStatement _lastPDOStatement;
    private String _lastInsertId;
    private boolean _inTransaction;
    private static String ENCODING = "ISO8859_1";

    public PDO(Env env, String dsn, @Optional(value="null") String user, @Optional(value="null") String password, @Optional ArrayValue options) {
        this._env = env;
        this._dsn = dsn;
        this._user = user;
        this._password = password;
        this._error = new PDOError(this._env);
        this._env.addCleanup(this);
        try {
            DataSource ds = this.getDataSource(env, dsn);
            if (ds == null) {
                env.warning(L.l("'{0}' is an unknown PDO data source.", (Object)dsn));
            } else {
                this._conn = this._user != null && !"".equals(this._user) ? ds.getConnection(this._user, this._password) : ds.getConnection();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            env.warning(e.getMessage(), (Throwable)e);
            this._error.error(e);
        }
    }

    public boolean beginTransaction() {
        if (this._conn == null) {
            return false;
        }
        if (this._inTransaction) {
            return false;
        }
        this._inTransaction = true;
        try {
            this._conn.setAutoCommit(false);
            return true;
        }
        catch (SQLException e) {
            this._error.error(e);
            return false;
        }
    }

    private void closeStatements() {
        Statement lastStatement = this._lastStatement;
        this._lastInsertId = null;
        this._lastStatement = null;
        this._lastPDOStatement = null;
        try {
            if (lastStatement != null) {
                lastStatement.close();
            }
        }
        catch (Throwable t) {
            log.log(Level.WARNING, t.toString(), t);
        }
    }

    public boolean commit() {
        if (this._conn == null) {
            return false;
        }
        if (!this._inTransaction) {
            return false;
        }
        this._inTransaction = false;
        boolean result = false;
        try {
            this._conn.commit();
            this._conn.setAutoCommit(true);
            return true;
        }
        catch (SQLException e) {
            this._error.error(e);
            return result;
        }
    }

    public void close() {
        this.cleanup();
    }

    @Override
    public void cleanup() {
        Connection conn = this._conn;
        this._conn = null;
        this.closeStatements();
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public String errorCode() {
        return this._error.errorCode();
    }

    public ArrayValue errorInfo() {
        return this._error.errorInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exec(String query) throws SQLException {
        int rowCount;
        block22: {
            if (this._conn == null) {
                return -1;
            }
            this.closeStatements();
            Statement stmt = null;
            try {
                stmt = this._conn.createStatement();
                stmt.setEscapeProcessing(false);
                if (stmt.execute(query)) {
                    ResultSet resultSet = null;
                    try {
                        resultSet = stmt.getResultSet();
                        resultSet.last();
                        rowCount = resultSet.getRow();
                        this._lastStatement = stmt;
                        stmt = null;
                        break block22;
                    }
                    finally {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException e) {
                            log.log(Level.FINER, e.toString(), e);
                        }
                    }
                }
                rowCount = stmt.getUpdateCount();
                this._lastStatement = stmt;
                stmt = null;
            }
            catch (SQLException e) {
                this._error.error(e);
                int n = -1;
                return n;
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
        }
        return rowCount;
    }

    public Value getAttribute(int attribute) {
        switch (attribute) {
            case 0: {
                return BooleanValue.create(this.getAutocommit());
            }
            case 8: {
                return LongValue.create(this.getCase());
            }
            case 5: {
                throw new UnimplementedException();
            }
            case 7: {
                throw new UnimplementedException();
            }
            case 16: {
                throw new UnimplementedException();
            }
            case 3: {
                return LongValue.create(this._error.getErrmode());
            }
            case 11: {
                return LongValue.create(this.getOracleNulls());
            }
            case 12: {
                return BooleanValue.create(this.getPersistent());
            }
            case 1: {
                return LongValue.create(this.getPrefetch());
            }
            case 6: {
                return StringValue.create(this.getServerInfo());
            }
            case 4: {
                return StringValue.create(this.getServerVersion());
            }
            case 2: {
                return LongValue.create(this.getTimeout());
            }
        }
        this._error.unsupportedAttribute(attribute);
        return BooleanValue.FALSE;
    }

    public static ArrayValue getAvailableDrivers() {
        ArrayValueImpl array = new ArrayValueImpl();
        array.put("mysql");
        array.put("pgsql");
        array.put("java");
        array.put("jdbc");
        return array;
    }

    private boolean getAutocommit() {
        if (this._conn == null) {
            return true;
        }
        try {
            return this._conn.getAutoCommit();
        }
        catch (SQLException e) {
            this._error.error(e);
            return true;
        }
    }

    public int getCase() {
        throw new UnimplementedException();
    }

    public int getOracleNulls() {
        throw new UnimplementedException();
    }

    private boolean getPersistent() {
        return true;
    }

    private int getPrefetch() {
        throw new UnimplementedException();
    }

    private String getServerInfo() {
        throw new UnimplementedException();
    }

    private String getServerVersion() {
        throw new UnimplementedException();
    }

    private int getTimeout() {
        throw new UnimplementedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastInsertId(@Optional String name) {
        if (name != null && name.length() != 0) {
            throw new UnimplementedException("lastInsertId with name");
        }
        if (this._lastInsertId != null) {
            return this._lastInsertId;
        }
        String lastInsertId = null;
        if (this._lastPDOStatement != null) {
            lastInsertId = this._lastPDOStatement.lastInsertId(name);
        } else if (this._lastStatement != null) {
            ResultSet resultSet = null;
            try {
                resultSet = this._lastStatement.getGeneratedKeys();
                if (resultSet.next()) {
                    lastInsertId = resultSet.getString(1);
                }
            }
            catch (SQLException ex) {
                this._error.error(ex);
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException ex) {
                    log.log(Level.WARNING, ex.toString(), ex);
                }
            }
        }
        this._lastInsertId = lastInsertId == null ? "0" : lastInsertId;
        return this._lastInsertId;
    }

    @ReturnNullAsFalse
    public PDOStatement prepare(String statement, @Optional ArrayValue driverOptions) {
        if (this._conn == null) {
            return null;
        }
        try {
            PDOStatement pdoStatement;
            this.closeStatements();
            this._lastPDOStatement = pdoStatement = new PDOStatement(this._env, this._conn, statement, true, driverOptions);
            return pdoStatement;
        }
        catch (SQLException e) {
            this._error.error(e);
            return null;
        }
    }

    public Value query(String query) {
        if (this._conn == null) {
            return BooleanValue.FALSE;
        }
        try {
            PDOStatement pdoStatement;
            this.closeStatements();
            this._lastPDOStatement = pdoStatement = new PDOStatement(this._env, this._conn, query, false, null);
            return this._env.wrapJava(pdoStatement);
        }
        catch (SQLException e) {
            this._error.error(e);
            return BooleanValue.FALSE;
        }
    }

    public String quote(String query, @Optional int parameterType) {
        return "'" + this.real_escape_string(query) + "'";
    }

    public String real_escape_string(String str) {
        StringBuilder buf = new StringBuilder();
        int strLength = str.length();
        block9: for (int i = 0; i < strLength; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\u0000': {
                    buf.append('\\');
                    buf.append('\u0000');
                    continue block9;
                }
                case '\n': {
                    buf.append('\\');
                    buf.append('n');
                    continue block9;
                }
                case '\r': {
                    buf.append('\\');
                    buf.append('r');
                    continue block9;
                }
                case '\\': {
                    buf.append('\\');
                    buf.append('\\');
                    continue block9;
                }
                case '\'': {
                    buf.append('\\');
                    buf.append('\'');
                    continue block9;
                }
                case '\"': {
                    buf.append('\\');
                    buf.append('\"');
                    continue block9;
                }
                case '\u001a': {
                    buf.append('\\');
                    buf.append('Z');
                    continue block9;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public boolean rollBack() {
        if (this._conn == null) {
            return false;
        }
        if (!this._inTransaction) {
            return false;
        }
        this._inTransaction = false;
        try {
            this._conn.rollback();
            this._conn.setAutoCommit(true);
            return true;
        }
        catch (SQLException e) {
            this._error.error(e);
            return false;
        }
    }

    public boolean setAttribute(int attribute, Value value) {
        return this.setAttribute(attribute, value, false);
    }

    private boolean setAttribute(int attribute, Value value, boolean isInit) {
        switch (attribute) {
            case 0: {
                return this.setAutocommit(value.toBoolean());
            }
            case 3: {
                return this._error.setErrmode(value.toInt());
            }
            case 8: {
                return this.setCase(value.toInt());
            }
            case 11: {
                return this.setOracleNulls(value.toInt());
            }
            case 17: {
                return this.setStringifyFetches(value.toBoolean());
            }
            case 13: {
                return this.setStatementClass(value);
            }
        }
        if (isInit) {
            switch (attribute) {
                case 2: {
                    return this.setTimeout(value.toInt());
                }
                case 12: {
                    return this.setPersistent(value.toBoolean());
                }
            }
        }
        this._error.unsupportedAttribute(attribute);
        return false;
    }

    private boolean setAutocommit(boolean autoCommit) {
        if (this._conn == null) {
            return false;
        }
        try {
            this._conn.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            this._error.error(e);
            return false;
        }
        return true;
    }

    private boolean setCase(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: {
                throw new UnimplementedException();
            }
        }
        this._error.unsupportedAttributeValue(value);
        return false;
    }

    private boolean setOracleNulls(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: {
                throw new UnimplementedException();
            }
        }
        this._error.warning(L.l("unknown value `{0}'", (long)value));
        this._error.unsupportedAttributeValue(value);
        return false;
    }

    private boolean setPersistent(boolean isPersistent) {
        return true;
    }

    private boolean setPrefetch(int prefetch) {
        throw new UnimplementedException();
    }

    private boolean setStatementClass(Value value) {
        throw new UnimplementedException("ATTR_STATEMENT_CLASS");
    }

    private boolean setStringifyFetches(boolean stringifyFetches) {
        throw new UnimplementedException();
    }

    private boolean setTimeout(int timeoutSeconds) {
        throw new UnimplementedException();
    }

    private DataSource getDataSource(Env env, String dsn) throws Exception {
        if (dsn.startsWith("mysql:")) {
            return this.getMysqlDataSource(env, dsn);
        }
        if (dsn.startsWith("pgsql:")) {
            return this.getPgsqlDataSource(env, dsn);
        }
        if (dsn.startsWith("java")) {
            return this.getJndiDataSource(env, dsn);
        }
        if (dsn.startsWith("resin:")) {
            return this.getResinDataSource(env, dsn);
        }
        env.error(L.l("'{0}' is an unknown PDO data source.", (Object)dsn));
        return null;
    }

    private DataSource getMysqlDataSource(Env env, String dsn) throws Exception {
        String password;
        String user;
        HashMap<String, String> attr = this.parseAttr(dsn, dsn.indexOf(58));
        String host = attr.get("host");
        String portStr = attr.get("port");
        String dbname = attr.get("dbname");
        String unixSocket = attr.get("unix_socket");
        if (unixSocket != null) {
            env.error(L.l("PDO mysql: does not support unix_socket"));
            return null;
        }
        if (host == null) {
            host = "localhost";
        }
        int port = 3306;
        if (portStr != null) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        if (dbname == null) {
            dbname = "test";
        }
        if ((user = attr.get("user")) != null) {
            this._user = user;
        }
        if ((password = attr.get("password")) != null) {
            this._password = password;
        }
        String driver = "com.mysql.jdbc.Driver";
        String url = Mysqli.getUrl(host, port, dbname, ENCODING, false, false, false);
        return env.getDataSource(driver, url);
    }

    private DataSource getPgsqlDataSource(Env env, String dsn) throws Exception {
        HashMap<String, String> attr = this.parseAttr(dsn, dsn.indexOf(58));
        String host = "localhost";
        String port = null;
        String dbname = "test";
        String user = null;
        String password = null;
        for (Map.Entry<String, String> entry : attr.entrySet()) {
            String key = entry.getKey();
            if ("host".equals(key)) {
                host = entry.getValue();
                continue;
            }
            if ("port".equals(key)) {
                port = entry.getValue();
                continue;
            }
            if ("dbname".equals(key)) {
                dbname = entry.getValue();
                continue;
            }
            if ("user".equals(key)) {
                user = entry.getValue();
                continue;
            }
            if ("password".equals(key)) {
                password = entry.getValue();
                continue;
            }
            env.warning(L.l("unknown pgsql attribute '{0}'", (Object)key));
        }
        if (user != null) {
            this._user = user;
        }
        if (password != null) {
            this._password = password;
        }
        String driver = "org.postgresql.Driver";
        StringBuilder url = new StringBuilder();
        url.append("jdbc:postgresql://");
        url.append(host);
        if (port != null) {
            url.append(port);
        }
        url.append('/');
        url.append(dbname);
        return env.getDataSource(driver, url.toString());
    }

    private DataSource getResinDataSource(Env env, String dsn) throws Exception {
        String driver = "com.caucho.db.jdbc.ConnectionPoolDataSourceImpl";
        String url = "jdbc:" + dsn;
        return env.getDataSource(driver, url);
    }

    private DataSource getJndiDataSource(Env env, String dsn) {
        DataSource ds = null;
        try {
            InitialContext ic = new InitialContext();
            ds = (DataSource)ic.lookup(dsn);
        }
        catch (NamingException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (ds == null) {
            env.error(L.l("'{0}' is an unknown PDO JNDI data source.", (Object)dsn));
        }
        return ds;
    }

    private HashMap<String, String> parseAttr(String dsn, int i) {
        LinkedHashMap<String, String> attr = new LinkedHashMap<String, String>();
        int length = dsn.length();
        while (i < length) {
            char ch = dsn.charAt(i);
            if (Character.isJavaIdentifierStart(ch)) {
                StringBuilder name = new StringBuilder();
                while (i < length && Character.isJavaIdentifierPart(ch = dsn.charAt(i))) {
                    name.append(ch);
                    ++i;
                }
                while (i < length && ((ch = dsn.charAt(i)) == ' ' || ch == '=')) {
                    ++i;
                }
                StringBuilder value = new StringBuilder();
                while (i < length && (ch = dsn.charAt(i)) != ' ' && ch != ';') {
                    value.append(ch);
                    ++i;
                }
                attr.put(name.toString(), value.toString());
            }
            ++i;
        }
        return attr;
    }

    public String toString() {
        if (this._dsn == null) {
            return "PDO[]";
        }
        if (this._dsn.indexOf("pass") < 0) {
            return "PDO[" + this._dsn + "]";
        }
        int i = this._dsn.lastIndexOf(58);
        if (i < 0) {
            return "PDO[]";
        }
        if (this._dsn.startsWith("java")) {
            return "PDO[" + this._dsn + "]";
        }
        StringBuilder str = new StringBuilder();
        str.append("PDO[");
        str.append(this._dsn, 0, i + 1);
        HashMap<String, String> attr = this.parseAttr(this._dsn, i);
        if (this._user != null && !"".equals(this._user)) {
            attr.put("user", this._user);
        }
        boolean first = true;
        for (Map.Entry<String, String> entry : attr.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("password".equalsIgnoreCase(key)) {
                value = "XXXXX";
            } else if ("passwd".equalsIgnoreCase(key)) {
                value = "XXXXX";
            } else if ("pass".equalsIgnoreCase(key)) {
                value = "XXXXX";
            }
            if (!first) {
                str.append(' ');
            }
            first = false;
            str.append(key);
            str.append("=");
            str.append(value);
        }
        str.append("]");
        return str.toString();
    }
}

