/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.gettext;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.gettext.GettextParser;
import com.caucho.quercus.lib.gettext.MOFileParser;
import com.caucho.quercus.lib.gettext.POFileParser;
import com.caucho.quercus.lib.gettext.expr.PluralExpr;
import com.caucho.vfs.BasicDependencyContainer;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

class GettextResource {
    private Env _env;
    protected Path _pathPO;
    private Path _pathMO;
    private Path _currentPath;
    private BasicDependencyContainer _depend;
    private PluralExpr _pluralExpr;
    private HashMap<StringValue, ArrayList<StringValue>> _translations;
    private String _charset;

    protected GettextResource(Env env, Path root, Locale locale, CharSequence category, CharSequence domain) {
        this._env = env;
        StringBuilder sb = new StringBuilder(locale.toString());
        sb.append('/');
        sb.append(category);
        sb.append('/');
        sb.append(domain);
        sb.append(".po");
        this._pathPO = this.lookupPath(env, root, sb.toString());
        sb.setCharAt(sb.length() - 2, 'm');
        this._pathMO = this.lookupPath(env, root, sb.toString());
        this.init();
    }

    private Path lookupPath(Env env, Path root, String relPath) {
        return root.lookup(relPath);
    }

    private void init() {
        if (this._pathPO != null && this._pathPO.exists()) {
            this._currentPath = this._pathPO;
        } else if (this._pathMO != null && this._pathMO.exists()) {
            this._currentPath = this._pathMO;
        } else {
            return;
        }
        try {
            if (this._depend == null) {
                this._depend = new BasicDependencyContainer();
            }
            this._depend.add((Dependency)new Depend(this._currentPath));
            GettextParser parser = this._currentPath == this._pathPO ? new POFileParser(this._env, this._currentPath) : new MOFileParser(this._env, this._currentPath);
            this._pluralExpr = parser.getPluralExpr();
            this._translations = parser.readTranslations();
            this._charset = parser.getCharset();
            parser.close();
        }
        catch (IOException e) {
            throw new QuercusModuleException(e.getMessage());
        }
    }

    protected StringValue getTranslation(StringValue key) {
        if (this.isModified()) {
            this.init();
        }
        return this.getTranslationImpl(key, 0);
    }

    private boolean isModified() {
        if (this._depend == null) {
            return true;
        }
        return this._depend.isModified();
    }

    protected StringValue getTranslation(StringValue key, int quantity) {
        if (this.isModified()) {
            this.init();
        }
        if (this._pluralExpr != null) {
            return this.getTranslationImpl(key, this._pluralExpr.eval(quantity));
        }
        return null;
    }

    protected StringValue getTranslationImpl(StringValue key, int index) {
        if (this._translations == null) {
            return null;
        }
        ArrayList<StringValue> pluralForms = this._translations.get(key);
        if (pluralForms == null || pluralForms.size() == 0) {
            return null;
        }
        if (index < pluralForms.size()) {
            return pluralForms.get(index);
        }
        return pluralForms.get(0);
    }

    protected String getCharset() {
        return this._charset;
    }
}

