/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.script;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.page.InterpretedPage;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.quercus.script.QuercusScriptEngine;
import com.caucho.vfs.NullWriteStream;
import com.caucho.vfs.ReaderWriterStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.Writer;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class QuercusCompiledScript
extends CompiledScript {
    private final QuercusScriptEngine _engine;
    private final QuercusProgram _program;

    QuercusCompiledScript(QuercusScriptEngine engine, QuercusProgram program) {
        this._engine = engine;
        this._program = program;
    }

    public Object eval(ScriptContext cxt) throws ScriptException {
        Env env = null;
        try {
            NullWriteStream out;
            Writer writer = cxt.getWriter();
            if (writer != null) {
                ReaderWriterStream s = new ReaderWriterStream(null, writer);
                WriteStream os = new WriteStream((StreamImpl)s);
                os.setNewlineString("\n");
                try {
                    os.setEncoding("utf-8");
                }
                catch (Exception e) {
                    // empty catch block
                }
                out = os;
            } else {
                out = new NullWriteStream();
            }
            InterpretedPage page = new InterpretedPage(this._program);
            env = new Env(this._engine.getQuercus(), page, (WriteStream)out, null, null);
            env.setScriptContext(cxt);
            env.start();
            Value resultV = this._program.execute(env);
            Object result = null;
            if (resultV != null) {
                result = resultV.toJavaObject();
            }
            out.flushBuffer();
            out.free();
            Object object = result;
            return object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            if (env != null) {
                env.close();
            }
        }
    }

    public ScriptEngine getEngine() {
        return this._engine;
    }

    public String toString() {
        return "QuercusCompiledScript[]";
    }
}

