/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.managerAPI;

import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.pbx.AsteriskSettings;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.NewChannelListener;
import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.asterisk.wrap.actions.GetVarAction;
import org.asteriskjava.pbx.asterisk.wrap.actions.OriginateAction;
import org.asteriskjava.pbx.asterisk.wrap.events.BridgeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.HangupEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.LinkEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.NewChannelEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.OriginateResponseEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.UnlinkEvent;
import org.asteriskjava.pbx.asterisk.wrap.response.ManagerResponse;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.pbx.internal.managerAPI.EventListenerBaseClass;
import org.asteriskjava.pbx.internal.managerAPI.OriginateResult;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public abstract class OriginateBaseClass
extends EventListenerBaseClass {
    public static final String NJR_ORIGINATE_ID = "njrOriginateID";
    protected static final Log logger = LogFactory.getLog(OriginateBaseClass.class);
    private volatile String originateID;
    private volatile boolean originateSuccess;
    private final Channel monitorChannel1;
    private boolean hungup = false;
    private Channel newChannel;
    private final Channel monitorChannel2;
    private final OriginateResult result;
    private boolean originateSeen = false;
    private boolean channelSeen = false;
    private final NewChannelListener listener;
    private final CountDownLatch originateLatch = new CountDownLatch(1);

    protected OriginateBaseClass(NewChannelListener listener, Channel monitor, Channel monitor2) {
        super("NewOrginateClass");
        this.listener = listener;
        this.monitorChannel1 = monitor;
        this.monitorChannel2 = monitor2;
        this.result = new OriginateResult();
        this.startListener(PBXFactory.getActivePBX());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OriginateResult originate(EndPoint local, EndPoint target, HashMap<String, String> myVars, CallerID callerID, Integer timeout, boolean hideCallerId, String context) {
        logger.debug("originate called");
        this.originateSeen = false;
        this.channelSeen = false;
        if (this.hungup) {
            this.close();
            return null;
        }
        logger.debug("originate connection endPoint \n" + local + " to endPoint " + target + " vars " + myVars);
        ManagerResponse response = null;
        AsteriskSettings settings = PBXFactory.getActiveProfile();
        OriginateAction originate = new OriginateAction();
        this.originateID = originate.getActionId();
        myVars.put("__njrOriginateID", this.originateID);
        Integer localTimeout = timeout;
        if (timeout == null) {
            localTimeout = 30000;
            try {
                localTimeout = settings.getDialTimeout() * 1000;
            }
            catch (Exception e) {
                logger.error("Invalid dial timeout value");
            }
        }
        if (local.isLocal()) {
            originate.setEndPoint(local);
            originate.setOption("/n");
        } else {
            originate.setEndPoint(local);
        }
        originate.setContext(context);
        originate.setExten(target);
        originate.setPriority(1);
        if (hideCallerId) {
            originate.setCallingPres(32);
        } else {
            originate.setCallerId(callerID);
        }
        originate.setVariables(myVars);
        originate.setAsync(true);
        originate.setTimeout(localTimeout.intValue());
        AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
        try {
            response = pbx.sendAction(originate, localTimeout);
            logger.debug("Originate.sendAction completed");
            if (response.getResponse().compareToIgnoreCase("Success") != 0) {
                logger.error("Error Originating call" + originate.toString() + " : " + response.getMessage());
                throw new ManagerCommunicationException(response.getMessage(), null);
            }
            this.originateLatch.await(localTimeout + 1000, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.debug(e, e);
        }
        catch (Exception e) {
            logger.error(e, e);
        }
        finally {
            this.close();
        }
        if (this.originateSuccess) {
            this.result.setSuccess(true);
            this.result.setChannelData(this.newChannel);
            logger.debug("new channel ok: " + this.newChannel);
        } else {
            logger.error("originate failed connecting endPoint: " + local + " to ext " + target);
            if (this.newChannel != null) {
                try {
                    logger.warn("Hanging up");
                    pbx.hangup(this.newChannel);
                }
                catch (IllegalArgumentException | IllegalStateException | PBXException e) {
                    logger.error(e, e);
                }
            }
        }
        return this.result;
    }

    void abort(String reason) {
        logger.debug("Aborting originate ");
        this.close();
        this.originateSuccess = false;
        this.result.setAbortReason(reason);
        this.hungup = true;
        if (this.newChannel != null) {
            logger.warn("Aborted, Hangup up on the way out");
            this.result.setChannelHungup(true);
            PBX pbx = PBXFactory.getActivePBX();
            try {
                pbx.hangup(this.newChannel);
            }
            catch (IllegalArgumentException | IllegalStateException | PBXException e) {
                logger.error(e, e);
            }
        }
        this.originateLatch.countDown();
    }

    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        required.add(OriginateResponseEvent.class);
        required.add(BridgeEvent.class);
        required.add(LinkEvent.class);
        required.add(UnlinkEvent.class);
        required.add(HangupEvent.class);
        required.add(NewChannelEvent.class);
        return required;
    }

    @Override
    public synchronized void onManagerEvent(ManagerEvent event) {
        ManagerResponse response;
        AsteriskPBX pbx;
        String __originateID;
        GetVarAction var;
        Channel channel;
        if (event instanceof HangupEvent) {
            PBX pbx2;
            HangupEvent hangupEvt = (HangupEvent)event;
            Channel hangupChannel = hangupEvt.getChannel();
            if (this.newChannel != null && hangupChannel.isSame(this.newChannel)) {
                this.originateSuccess = false;
                logger.error("Dest channel " + this.newChannel + " hungup after answer");
                this.originateLatch.countDown();
            }
            if (this.monitorChannel1 != null && hangupChannel.isSame(this.monitorChannel1)) {
                this.originateSuccess = false;
                this.hungup = true;
                if (this.newChannel != null) {
                    logger.debug("hanging up " + this.newChannel);
                    this.result.setChannelHungup(true);
                    pbx2 = PBXFactory.getActivePBX();
                    try {
                        logger.warn("Hanging up");
                        pbx2.hangup(this.newChannel);
                    }
                    catch (IllegalArgumentException | IllegalStateException | PBXException e) {
                        logger.error(e, e);
                    }
                }
                logger.debug("notify channel 1 hungup");
                this.originateLatch.countDown();
            }
            if (this.monitorChannel2 != null && hangupChannel.isSame(this.monitorChannel2)) {
                this.originateSuccess = false;
                this.hungup = true;
                if (this.newChannel != null) {
                    logger.debug("Hanging up channel " + this.newChannel);
                    this.result.setChannelHungup(true);
                    pbx2 = PBXFactory.getActivePBX();
                    try {
                        pbx2.hangup(this.newChannel);
                    }
                    catch (IllegalArgumentException | IllegalStateException | PBXException e) {
                        logger.error(e, e);
                    }
                }
                logger.debug("Notify channel 2 (" + this.monitorChannel2 + ") hungup");
                this.originateLatch.countDown();
            }
        }
        if (event instanceof OriginateResponseEvent) {
            logger.debug("response : " + this.newChannel);
            OriginateResponseEvent response2 = (OriginateResponseEvent)event;
            logger.debug("OriginateResponseEvent: channel=" + (response2.isChannel() ? response2.getChannel() : response2.getEndPoint()) + " originateID:" + this.originateID);
            logger.debug("{" + response2.getReason() + ":" + response2.getResponse() + "}");
            if (this.originateID != null) {
                if (this.originateID.compareToIgnoreCase(response2.getActionId()) == 0) {
                    this.originateSuccess = response2.isSuccess();
                    logger.debug("OriginateResponse: matched actionId, success=" + this.originateSuccess + " channelSeen=" + this.channelSeen);
                    this.originateSeen = true;
                    if (this.channelSeen) {
                        logger.debug("notify originate response event 305 " + this.originateSuccess);
                        this.originateLatch.countDown();
                    }
                }
            } else {
                logger.warn("actionid is null");
            }
        }
        if (event instanceof NewChannelEvent) {
            NewChannelEvent newState = (NewChannelEvent)event;
            channel = newState.getChannel();
            var = new GetVarAction(channel, NJR_ORIGINATE_ID);
            logger.debug("new channel event :" + channel + " context = " + newState.getContext() + " state =" + newState.getChannelStateDesc() + " state =" + (Object)((Object)newState.getChannelState()));
            int ctr = 0;
            __originateID = null;
            while (ctr < 5 && __originateID == null) {
                try {
                    ++ctr;
                    Thread.sleep(100L);
                    pbx = (AsteriskPBX)PBXFactory.getActivePBX();
                    response = pbx.sendAction(var, 500);
                    __originateID = response.getAttribute("value");
                    if (__originateID == null) continue;
                    if (__originateID.compareToIgnoreCase(this.originateID) == 0) {
                        if (this.newChannel != null || channel.isLocal()) continue;
                        this.newChannel = channel;
                        this.channelSeen = true;
                        logger.debug("new channel name " + channel);
                        if (this.listener != null) {
                            this.listener.channelUpdate(channel);
                        }
                        if (!this.originateSeen) continue;
                        logger.debug("notifying success 362");
                        this.originateLatch.countDown();
                        continue;
                    }
                    logger.debug("originateID " + __originateID);
                }
                catch (Exception e) {
                    if (this.originateSuccess || ctr != 4) continue;
                    logger.error(e, e);
                }
            }
        }
        if (event instanceof BridgeEvent) {
            BridgeEvent bridgeEvent = (BridgeEvent)event;
            channel = bridgeEvent.getChannel1();
            if (bridgeEvent.getChannel1().isLocal()) {
                channel = bridgeEvent.getChannel2();
            }
            var = new GetVarAction(channel, NJR_ORIGINATE_ID);
            logger.debug("new channel event :" + channel + " channel1 = " + bridgeEvent.getChannel1() + " channel2 =" + bridgeEvent.getChannel2());
            int ctr = 0;
            __originateID = null;
            while (ctr < 5 && __originateID == null) {
                try {
                    ++ctr;
                    Thread.sleep(100L);
                    pbx = (AsteriskPBX)PBXFactory.getActivePBX();
                    response = pbx.sendAction(var, 500);
                    __originateID = response.getAttribute("value");
                    if (__originateID != null) {
                        if (this.originateID == null || __originateID.compareToIgnoreCase(this.originateID) != 0 || this.newChannel != null || channel.isLocal()) continue;
                        this.newChannel = channel;
                        this.channelSeen = true;
                        logger.debug("new channel name " + channel);
                        if (this.listener != null) {
                            this.listener.channelUpdate(channel);
                        }
                        if (!this.originateSeen) continue;
                        logger.debug("notifying success 362");
                        this.originateLatch.countDown();
                        continue;
                    }
                    logger.debug("originateID " + __originateID);
                }
                catch (Exception e) {
                    if (this.originateSuccess || ctr != 4) continue;
                    logger.error(e, e);
                }
            }
        }
    }
}

