/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.manager.AuthenticationFailedException;
import org.asteriskjava.manager.EventTimeoutException;
import org.asteriskjava.manager.ManagerConnectionState;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.event.AbstractChannelEvent;
import org.asteriskjava.pbx.Activity;
import org.asteriskjava.pbx.ActivityCallback;
import org.asteriskjava.pbx.ActivityStatusEnum;
import org.asteriskjava.pbx.AgiChannelActivityAction;
import org.asteriskjava.pbx.AsteriskSettings;
import org.asteriskjava.pbx.Call;
import org.asteriskjava.pbx.CallDirection;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.ChannelHangupListener;
import org.asteriskjava.pbx.CompletionAdaptor;
import org.asteriskjava.pbx.DTMFTone;
import org.asteriskjava.pbx.DialPlanExtension;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.InvalidChannelName;
import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.TechType;
import org.asteriskjava.pbx.Trunk;
import org.asteriskjava.pbx.activities.BlindTransferActivity;
import org.asteriskjava.pbx.activities.BridgeActivity;
import org.asteriskjava.pbx.activities.DialActivity;
import org.asteriskjava.pbx.activities.DialToAgiActivity;
import org.asteriskjava.pbx.activities.HoldActivity;
import org.asteriskjava.pbx.activities.JoinActivity;
import org.asteriskjava.pbx.activities.ParkActivity;
import org.asteriskjava.pbx.activities.RedirectToActivity;
import org.asteriskjava.pbx.activities.SplitActivity;
import org.asteriskjava.pbx.agi.AgiChannelActivityHangup;
import org.asteriskjava.pbx.agi.AgiChannelActivityHold;
import org.asteriskjava.pbx.asterisk.wrap.actions.CommandAction;
import org.asteriskjava.pbx.asterisk.wrap.actions.EventGeneratingAction;
import org.asteriskjava.pbx.asterisk.wrap.actions.HangupAction;
import org.asteriskjava.pbx.asterisk.wrap.actions.ManagerAction;
import org.asteriskjava.pbx.asterisk.wrap.actions.PlayDtmfAction;
import org.asteriskjava.pbx.asterisk.wrap.actions.RedirectAction;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ResponseEvents;
import org.asteriskjava.pbx.asterisk.wrap.response.CommandResponse;
import org.asteriskjava.pbx.asterisk.wrap.response.ManagerResponse;
import org.asteriskjava.pbx.internal.activity.BlindTransferActivityImpl;
import org.asteriskjava.pbx.internal.activity.BridgeActivityImpl;
import org.asteriskjava.pbx.internal.activity.DialActivityImpl;
import org.asteriskjava.pbx.internal.activity.DialToAgiActivityImpl;
import org.asteriskjava.pbx.internal.activity.HoldActivityImpl;
import org.asteriskjava.pbx.internal.activity.JoinActivityImpl;
import org.asteriskjava.pbx.internal.activity.ParkActivityImpl;
import org.asteriskjava.pbx.internal.activity.RedirectToActivityImpl;
import org.asteriskjava.pbx.internal.activity.SplitActivityImpl;
import org.asteriskjava.pbx.internal.asterisk.CallerIDImpl;
import org.asteriskjava.pbx.internal.asterisk.MeetmeRoom;
import org.asteriskjava.pbx.internal.asterisk.MeetmeRoomControl;
import org.asteriskjava.pbx.internal.asterisk.RoomOwner;
import org.asteriskjava.pbx.internal.core.ChannelImpl;
import org.asteriskjava.pbx.internal.core.ChannelProxy;
import org.asteriskjava.pbx.internal.core.CoherentManagerConnection;
import org.asteriskjava.pbx.internal.core.DialLocalToAgiActivity;
import org.asteriskjava.pbx.internal.core.EndPointImpl;
import org.asteriskjava.pbx.internal.core.FilteredManagerListener;
import org.asteriskjava.pbx.internal.core.LiveChannelManager;
import org.asteriskjava.pbx.internal.managerAPI.RedirectCall;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public enum AsteriskPBX implements PBX,
ChannelHangupListener
{
    SELF;

    public static final String ACTIVITY_AGI = "activityAgi";
    private final Log logger = LogFactory.getLog(this.getClass());
    private boolean muteSupported;
    private boolean bridgeSupport;
    private static final int MAX_MEETME_ROOMS = 500;
    private LiveChannelManager liveChannels;

    private AsteriskPBX() {
        try {
            CoherentManagerConnection.init();
            this.muteSupported = CoherentManagerConnection.getInstance().isMuteAudioSupported();
            this.bridgeSupport = CoherentManagerConnection.getInstance().isBridgeSupported();
            this.liveChannels = new LiveChannelManager();
            try {
                MeetmeRoomControl.init(this, 500);
            }
            catch (Throwable e) {
                this.logger.error(e, e);
            }
        }
        catch (IOException | IllegalStateException | InterruptedException | AuthenticationFailedException | TimeoutException e1) {
            this.logger.error(e1, e1);
        }
    }

    @Override
    public void performPostCreationTasks() {
        this.liveChannels.performPostCreationTasks();
    }

    @Override
    public void shutdown() {
        MeetmeRoomControl.getInstance().stop();
        CoherentManagerConnection.getInstance().shutDown();
    }

    @Override
    public boolean isBridgeSupported() {
        return this.bridgeSupport;
    }

    @Override
    public BlindTransferActivity blindTransfer(Call call, Call.OperandChannel channelToTransfer, EndPoint transferTarget, CallerID toCallerID, boolean autoAnswer, long timeout) {
        CompletionAdaptor<BlindTransferActivity> completion = new CompletionAdaptor<BlindTransferActivity>();
        BlindTransferActivityImpl transfer = new BlindTransferActivityImpl(call, channelToTransfer, transferTarget, toCallerID, autoAnswer, timeout, completion);
        completion.waitForCompletion(timeout + 2L, TimeUnit.SECONDS);
        return transfer;
    }

    @Override
    public void blindTransfer(Call call, Call.OperandChannel channelToTransfer, EndPoint transferTarget, CallerID toCallerID, boolean autoAnswer, long timeout, ActivityCallback<BlindTransferActivity> listener) {
        new BlindTransferActivityImpl(call, channelToTransfer, transferTarget, toCallerID, autoAnswer, timeout, listener);
    }

    public BlindTransferActivity blindTransfer(Channel agentChannel, EndPoint transferTarget, CallerID toCallerID, boolean autoAnswer, int timeout, ActivityCallback<BlindTransferActivity> iCallback) throws PBXException {
        return new BlindTransferActivityImpl(agentChannel, transferTarget, toCallerID, autoAnswer, timeout, iCallback);
    }

    public BridgeActivity bridge(Channel lhsChannel, Channel rhsChannel) throws PBXException {
        CompletionAdaptor<BridgeActivity> completion = new CompletionAdaptor<BridgeActivity>();
        BridgeActivityImpl bridge = new BridgeActivityImpl(lhsChannel, rhsChannel, completion);
        completion.waitForCompletion(10L, TimeUnit.SECONDS);
        return bridge;
    }

    @Override
    public void split(Call callToSplit) throws PBXException {
        CompletionAdaptor<SplitActivity> completion = new CompletionAdaptor<SplitActivity>();
        new SplitActivityImpl(callToSplit, completion);
        completion.waitForCompletion(10L, TimeUnit.SECONDS);
    }

    @Override
    public SplitActivity split(Call callToSplit, ActivityCallback<SplitActivity> listener) {
        return new SplitActivityImpl(callToSplit, listener);
    }

    @Override
    public RedirectToActivity redirectToActivity(Channel channel, ActivityCallback<RedirectToActivity> listener) {
        return new RedirectToActivityImpl(channel, listener);
    }

    @Override
    public JoinActivity join(Call lhs, Call.OperandChannel originatingOperand, Call rhs, Call.OperandChannel acceptingOperand, CallDirection direction) {
        CompletionAdaptor<JoinActivity> completion = new CompletionAdaptor<JoinActivity>();
        JoinActivityImpl join = new JoinActivityImpl(lhs, originatingOperand, rhs, acceptingOperand, direction, completion);
        completion.waitForCompletion(10L, TimeUnit.SECONDS);
        return join;
    }

    @Override
    public void join(Call lhs, Call.OperandChannel originatingOperand, Call rhs, Call.OperandChannel acceptingOperand, CallDirection direction, ActivityCallback<JoinActivity> listener) {
        new JoinActivityImpl(lhs, originatingOperand, rhs, acceptingOperand, direction, listener);
    }

    @Override
    public void conference(Channel channelOne, Channel channelTwo, Channel channelThree) {
    }

    @Override
    public void conference(Channel channelOne, Channel channelTwo, Channel channelThree, ActivityCallback<Activity> callback) {
    }

    @Override
    public DialActivity dial(EndPoint from, CallerID fromCallerID, EndPoint to, CallerID toCallerID) {
        CompletionAdaptor<DialActivity> completion = new CompletionAdaptor<DialActivity>();
        DialActivityImpl dialer = new DialActivityImpl(from, to, toCallerID, false, completion, null);
        completion.waitForCompletion(3L, TimeUnit.MINUTES);
        return dialer;
    }

    public DialLocalToAgiActivity dialLocalToAgi(EndPoint from, CallerID fromCallerID, ActivityCallback<DialLocalToAgiActivity> callback, Map<String, String> channelVarsToSet) {
        return new DialLocalToAgiActivity(from, fromCallerID, callback, channelVarsToSet);
    }

    public DialActivity dial(EndPoint from, CallerID fromCallerID, EndPoint to, CallerID toCallerID, ActivityCallback<DialActivity> callback, Map<String, String> channelVarsToSet) {
        DialActivityImpl dialer = new DialActivityImpl(from, to, toCallerID, false, callback, channelVarsToSet);
        return dialer;
    }

    @Override
    public void dial(EndPoint from, CallerID fromCallerID, EndPoint to, CallerID toCallerID, ActivityCallback<DialActivity> callback) {
        new DialActivityImpl(from, to, toCallerID, false, callback, null);
    }

    @Override
    public void hangup(Call call) throws PBXException {
        this.hangup(call.getOriginatingParty());
    }

    @Override
    public void hangup(Channel channel) throws PBXException {
        if (channel.isLive()) {
            this.logger.warn("Sending hangup action for channel: " + channel);
            PBX pbx = PBXFactory.getActivePBX();
            if (!pbx.waitForChannelToQuiescent(channel, 3000)) {
                throw new PBXException("Channel: " + channel + " cannot be retrieved as it is still in transition.");
            }
            HangupAction hangup = new HangupAction(channel);
            try {
                channel.setCurrentActivityAction(new AgiChannelActivityHangup());
                CoherentManagerConnection.sendAction(hangup, 1000);
            }
            catch (IOException | IllegalArgumentException | IllegalStateException | TimeoutException e) {
                this.logger.error(e, e);
                throw new PBXException(e);
            }
        } else {
            this.logger.debug("Suppressed hangup for " + channel + " as it was already hungup");
        }
    }

    @Override
    public void hangup(Channel channel, ActivityCallback<Activity> callback) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public HoldActivity hold(Channel channel) {
        CompletionAdaptor<HoldActivity> completion = new CompletionAdaptor<HoldActivity>();
        HoldActivityImpl activity = null;
        try {
            activity = new HoldActivityImpl(channel, completion);
            completion.waitForCompletion(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.logger.error(e, e);
        }
        return activity;
    }

    @Override
    public boolean isMuteSupported() {
        return this.muteSupported;
    }

    @Override
    public ParkActivity park(Call call, Channel parkChannel) {
        CompletionAdaptor<ParkActivity> completion = new CompletionAdaptor<ParkActivity>();
        ParkActivityImpl activity = new ParkActivityImpl(call, parkChannel, completion);
        parkChannel.setParked(true);
        completion.waitForCompletion(10L, TimeUnit.SECONDS);
        return activity;
    }

    @Override
    public void park(Call call, Channel parkChannel, ActivityCallback<ParkActivity> callback) {
        new ParkActivityImpl(call, parkChannel, callback);
    }

    @Override
    public void sendDTMF(Channel channel, DTMFTone tone) throws PBXException {
        try {
            if (!this.waitForChannelToQuiescent(channel, 3000)) {
                throw new PBXException("Channel: " + channel + " cannot play dtmf as it is still in transition.");
            }
            CoherentManagerConnection.sendAction(new PlayDtmfAction(channel, tone), 1000);
        }
        catch (Exception e) {
            this.logger.error(e, e);
            throw new PBXException(e);
        }
    }

    @Override
    public void sendDTMF(Channel channel, DTMFTone tone, ActivityCallback<Activity> callback) {
    }

    @Override
    public void transferToMusicOnHold(Channel channel) throws PBXException {
        RedirectCall transfer = new RedirectCall();
        transfer.redirect(channel, new AgiChannelActivityHold());
    }

    public String getManagementContext() {
        AsteriskSettings settings = PBXFactory.getActiveProfile();
        return settings.getManagementContext();
    }

    @Override
    public Channel getChannelByEndPoint(EndPoint endPoint) {
        return this.liveChannels.getChannelByEndPoint(endPoint);
    }

    @Override
    public void channelHangup(Channel channel, Integer cause, String causeText) {
        this.liveChannels.remove((ChannelProxy)channel);
    }

    public DialPlanExtension getExtensionPark() {
        AsteriskSettings settings = PBXFactory.getActiveProfile();
        return this.buildDialPlanExtension(settings.getExtensionPark());
    }

    @Override
    public EndPoint getExtensionAgi() {
        AsteriskSettings settings = PBXFactory.getActiveProfile();
        return this.buildDialPlanExtension(settings.getAgiExtension());
    }

    @Override
    public EndPoint buildEndPoint(String fullyQualifiedEndPoint) {
        EndPointImpl endPoint = null;
        try {
            endPoint = new EndPointImpl(fullyQualifiedEndPoint);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn(e, e);
        }
        return endPoint;
    }

    @Override
    public EndPoint buildEndPoint(TechType defaultTech, String endPointName) {
        EndPointImpl endPoint = null;
        try {
            endPoint = endPointName == null || endPointName.trim().length() == 0 ? new EndPointImpl() : new EndPointImpl(defaultTech, endPointName);
        }
        catch (IllegalArgumentException e) {
            this.logger.error(e, e);
        }
        return endPoint;
    }

    @Override
    public EndPoint buildEndPoint(TechType defaultTech, Trunk trunk, String endPointName) {
        return new EndPointImpl(defaultTech, trunk, endPointName);
    }

    public DialPlanExtension buildDialPlanExtension(String extension) {
        DialPlanExtension dialPlan = null;
        try {
            dialPlan = new DialPlanExtension(extension);
        }
        catch (IllegalArgumentException e) {
            this.logger.error(e, e);
        }
        return dialPlan;
    }

    @Override
    public CallerID buildCallerID(String number, String name) {
        return new CallerIDImpl(number, name);
    }

    public CallerID buildCallerID(AbstractChannelEvent event) {
        String number = event.getCallerIdNum();
        String name = event.getCallerIdName();
        return this.buildCallerID(number, name);
    }

    public Channel registerChannel(String channelName, String uniqueIdParam) throws InvalidChannelName {
        String uniqueID = uniqueIdParam;
        if (uniqueIdParam == null || uniqueIdParam.length() == 0) {
            uniqueID = "-1";
        }
        if (channelName == null || channelName.trim().length() == 0) {
            throw new IllegalArgumentException("Channel name must not be empty");
        }
        Channel proxy = this.findChannel(this.cleanChannelName(channelName), null);
        if (proxy == null) {
            this.logger.info("Couldn't find the channel " + channelName + ", creating it");
            proxy = this.internalRegisterChannel(channelName, uniqueID);
        } else if (uniqueID != null && !uniqueID.equals(proxy.getUniqueId())) {
            this.logger.info("Found the channel(" + proxy.getUniqueId() + "), but with a different uniqueId (" + uniqueID + ")");
        }
        this.liveChannels.sanityCheck();
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel internalRegisterChannel(String channelName, String uniqueID) throws InvalidChannelName {
        ChannelProxy proxy = null;
        LiveChannelManager liveChannelManager = this.liveChannels;
        synchronized (liveChannelManager) {
            String localUniqueID = uniqueID == null ? "-1" : uniqueID;
            proxy = this.findChannel(this.cleanChannelName(channelName), localUniqueID);
            if (proxy == null) {
                proxy = new ChannelProxy(new ChannelImpl(channelName, localUniqueID));
                this.logger.debug("Creating new Channel Proxy " + proxy);
                this.liveChannels.add(proxy);
                proxy.addHangupListener(this);
            }
        }
        return proxy;
    }

    private String cleanChannelName(String name) {
        String cleanedName = name.trim().toUpperCase();
        return cleanedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel registerHangupChannel(String channel, String uniqueId) throws InvalidChannelName {
        ChannelProxy newChannel = null;
        LiveChannelManager liveChannelManager = this.liveChannels;
        synchronized (liveChannelManager) {
            newChannel = this.findChannel(channel, uniqueId);
            if (newChannel == null) {
                newChannel = new ChannelProxy(new ChannelImpl(channel, uniqueId));
            }
        }
        return newChannel;
    }

    public ChannelProxy findChannel(String channelName, String uniqueID) {
        return this.liveChannels.findChannel(channelName, uniqueID);
    }

    public MeetmeRoom acquireMeetmeRoom(RoomOwner owner) {
        return MeetmeRoomControl.getInstance().findAvailableRoom(owner);
    }

    public void addListener(FilteredManagerListener<ManagerEvent> listener) {
        CoherentManagerConnection connection = CoherentManagerConnection.getInstance();
        connection.addListener(listener);
    }

    public void removeListener(FilteredManagerListener<ManagerEvent> listener) {
        CoherentManagerConnection connection = CoherentManagerConnection.getInstance();
        connection.removeListener(listener);
    }

    public ManagerResponse sendAction(ManagerAction theAction) throws IllegalArgumentException, IllegalStateException, IOException, TimeoutException {
        return CoherentManagerConnection.sendAction(theAction, 30000);
    }

    public ManagerResponse sendAction(ManagerAction theAction, int timeout) throws IllegalArgumentException, IllegalStateException, IOException, TimeoutException {
        return CoherentManagerConnection.sendAction(theAction, timeout);
    }

    public ResponseEvents sendEventGeneratingAction(EventGeneratingAction action) throws EventTimeoutException, IllegalArgumentException, IllegalStateException, IOException {
        ResponseEvents events = CoherentManagerConnection.sendEventGeneratingAction(action);
        return events;
    }

    public ResponseEvents sendEventGeneratingAction(EventGeneratingAction action, int timeout) throws EventTimeoutException, IllegalArgumentException, IllegalStateException, IOException {
        return CoherentManagerConnection.sendEventGeneratingAction(action, timeout);
    }

    public void setVariable(Channel channel, String name, String value) throws PBXException {
        CoherentManagerConnection.getInstance().setVariable(channel, name, value);
    }

    public void sendActionNoWait(ManagerAction action) {
        CoherentManagerConnection.sendActionNoWait(action);
    }

    public String getVariable(Channel channel, String name) {
        return CoherentManagerConnection.getInstance().getVariable(channel, name);
    }

    public AsteriskVersion getVersion() {
        return CoherentManagerConnection.getInstance().getVersion();
    }

    public boolean isConnected() {
        return CoherentManagerConnection.managerConnection != null && CoherentManagerConnection.managerConnection.getState() == ManagerConnectionState.CONNECTED;
    }

    public boolean isMeetmeInstalled() {
        return MeetmeRoomControl.getInstance().isMeetmeInstalled();
    }

    @Override
    public boolean isChannel(String channelName) {
        boolean isChannel = false;
        try {
            this.internalRegisterChannel(channelName, "-1");
            isChannel = true;
        }
        catch (InvalidChannelName invalidChannelName) {
            // empty catch block
        }
        return isChannel;
    }

    public static String getSIPADDHeader(boolean inherit, boolean targetIsSIP) {
        String sipHeader = "SIPADDHEADER";
        if (!targetIsSIP || inherit) {
            sipHeader = "__" + sipHeader;
        }
        return sipHeader;
    }

    @Override
    public boolean waitForChannelsToQuiescent(List<Channel> channels, long timeout) {
        long elapsed;
        for (elapsed = 0L; elapsed < timeout && !this.channelsAreQuiesent(channels); elapsed += 200L) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                this.logger.error(e, e);
            }
            this.logger.info("Waiting for channesl to Quiescent");
        }
        if (elapsed > timeout / 2L) {
            this.logger.warn("Took " + elapsed + "ms for channels to Quiescent");
        }
        if (elapsed >= timeout) {
            this.logger.error("Channels didn't Quiescent");
            for (Channel channel : channels) {
                this.logger.error(channel);
            }
        }
        return timeout > elapsed;
    }

    private boolean channelsAreQuiesent(List<Channel> channels) {
        boolean ret = true;
        for (Channel channel : channels) {
            ret &= channel.isQuiescent();
        }
        return ret;
    }

    public boolean moveChannelToAgi(Channel channel) throws PBXException {
        if (!this.waitForChannelToQuiescent(channel, 3000)) {
            throw new PBXException("Channel: " + channel + " cannot be transfered as it is still in transition.");
        }
        boolean isInAgi = channel.isInAgi();
        if (!isInAgi) {
            AsteriskSettings profile = PBXFactory.getActiveProfile();
            channel.setCurrentActivityAction(new AgiChannelActivityHold());
            RedirectAction redirect = new RedirectAction(channel, profile.getManagementContext(), this.getExtensionAgi(), 1);
            this.logger.error("Issuing redirect on channel " + channel + " to move it to the agi");
            try {
                ManagerResponse response = this.sendAction(redirect, 1000);
                if (response != null && response.getResponse().compareToIgnoreCase("success") == 0) {
                    int limit = 50;
                    while (!channel.isInAgi() && limit-- > 0) {
                        Thread.sleep(100L);
                    }
                    isInAgi = channel.isInAgi();
                    if (!isInAgi) {
                        this.logger.error("Failed to move channel");
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(e, e);
            }
        }
        return isInAgi;
    }

    public void moveChannelTo(Channel channel, String context, String exten, int prio) {
        DialPlanExtension ext = this.buildDialPlanExtension(exten);
        channel.setCurrentActivityAction(new AgiChannelActivityHold());
        RedirectAction redirect = new RedirectAction(channel, context, ext, prio);
        try {
            this.sendAction(redirect, 1000);
        }
        catch (Exception e) {
            this.logger.error(e, e);
        }
    }

    @Override
    public boolean waitForChannelToQuiescent(Channel channel, int timeout) {
        LinkedList<Channel> channels = new LinkedList<Channel>();
        channels.add(channel);
        return this.waitForChannelsToQuiescent(channels, timeout);
    }

    public ChannelProxy getProxyById(String id) {
        return this.liveChannels.findProxyById(id);
    }

    public DialToAgiActivityImpl dialToAgi(EndPoint endPoint, CallerID callerID, AgiChannelActivityAction action, ActivityCallback<DialToAgiActivity> iCallback) {
        CompletionAdaptor<DialToAgiActivity> completion = new CompletionAdaptor<DialToAgiActivity>();
        DialToAgiActivityImpl dialer = new DialToAgiActivityImpl(endPoint, callerID, false, completion, null, action);
        completion.waitForCompletion(3L, TimeUnit.MINUTES);
        ActivityStatusEnum status = dialer.isSuccess() ? ActivityStatusEnum.SUCCESS : ActivityStatusEnum.FAILURE;
        iCallback.progress(dialer, status, status.getDefaultMessage());
        return dialer;
    }

    public boolean createAgiEntryPoint() throws IOException, AuthenticationFailedException, TimeoutException {
        try {
            AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
            AsteriskSettings profile = PBXFactory.getActiveProfile();
            if (!this.checkDialplanExists(profile)) {
                String host = profile.getAgiHost();
                String agi = profile.getAgiExtension();
                pbx.addAsteriskExtension(agi, 1, "AGI(agi://" + host + "/" + ACTIVITY_AGI + "), into " + profile.getManagementContext());
                pbx.addAsteriskExtension(agi, 2, "wait(0.5), into " + profile.getManagementContext());
                pbx.addAsteriskExtension(agi, 3, "goto(" + agi + ",1), into " + profile.getManagementContext());
                return this.checkDialplanExists(profile);
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error(e);
            return false;
        }
    }

    public boolean checkDialplanExists(AsteriskSettings profile) throws IllegalArgumentException, IllegalStateException, IOException, TimeoutException {
        String ext = "show dialplan " + profile.getManagementContext();
        CommandAction action = new CommandAction(ext);
        CommandResponse response = (CommandResponse)this.sendAction(action, 30000);
        boolean exists = false;
        for (String line : response.getResult()) {
            if (!line.contains(ACTIVITY_AGI)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public String addAsteriskExtension(String extNumber, int priority, String command) throws Exception {
        String tmp;
        String ext = "dialplan add extension " + extNumber + "," + priority + "," + command;
        CommandAction action = new CommandAction(ext);
        CommandResponse response = (CommandResponse)this.sendAction(action, 30000);
        List<String> line = response.getResult();
        String answer = line.get(0);
        if (answer.substring(0, (tmp = "Extension '" + extNumber + "," + priority + ",").length()).compareToIgnoreCase(tmp) == 0) {
            return "OK";
        }
        throw new Exception("InitiateAction.AddExtentionFailed" + ext);
    }

    @Override
    public Trunk buildTrunk(final String trunk) {
        return new Trunk(){

            @Override
            public String getTrunkAsString() {
                return trunk;
            }
        };
    }

    public List<ChannelProxy> getChannelList() {
        return this.liveChannels.getChannelList();
    }
}

