/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.util.ArrayList;
import java.util.LinkedList;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.ChannelHangupListener;
import org.asteriskjava.pbx.asterisk.wrap.events.ChannelState;
import org.asteriskjava.pbx.internal.core.CallEndedListener;
import org.asteriskjava.pbx.internal.core.ChannelProxy;
import org.asteriskjava.pbx.internal.core.Peer;
import org.asteriskjava.pbx.internal.core.PeerState;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class CallTracker
implements ChannelHangupListener {
    private static final Log logger = LogFactory.getLog(CallTracker.class);
    ArrayList<Channel> _associatedChannels = new ArrayList();
    PeerState _state;
    private CallEndedListener listener;

    CallTracker(Peer peer, Channel initialChannel) {
        this._associatedChannels.add(initialChannel);
        initialChannel.addHangupListener(this);
        this.listener = peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeCalls(CallTracker rhs) {
        ArrayList<Channel> arrayList = this._associatedChannels;
        synchronized (arrayList) {
            for (Channel channel : rhs._associatedChannels) {
                this._associatedChannels.add(channel);
            }
            rhs._associatedChannels.clear();
        }
    }

    public PeerState getState() {
        return this._state;
    }

    public void setState(ChannelState channelState) {
        this._state = PeerState.valueByChannelState(channelState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findChannel(Channel newChannel) {
        int index = -1;
        ArrayList<Channel> arrayList = this._associatedChannels;
        synchronized (arrayList) {
            for (int i = 0; i < this._associatedChannels.size(); ++i) {
                Channel channel = this._associatedChannels.get(i);
                if (!channel.isSame(newChannel)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Channel channel) {
        ArrayList<Channel> arrayList = this._associatedChannels;
        synchronized (arrayList) {
            int index = this.findChannel(channel);
            if (index != -1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("CallTracker removing channel: " + this.toString() + " " + channel.getExtendedChannelName());
                }
                this._associatedChannels.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSweep() {
        ArrayList<Channel> arrayList = this._associatedChannels;
        synchronized (arrayList) {
            for (Channel channel : this._associatedChannels) {
                ((ChannelProxy)channel).getRealChannel().startSweep();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSweep() {
        LinkedList<Channel> toremove = new LinkedList<Channel>();
        ArrayList<Channel> arrayList = this._associatedChannels;
        synchronized (arrayList) {
            for (Channel channel : this._associatedChannels) {
                if (((ChannelProxy)channel).getRealChannel().wasMarkedDuringSweep()) continue;
                toremove.add(channel);
                logger.warn("removing channel " + this.hashCode() + " " + channel.getChannelName());
            }
            this._associatedChannels.removeAll(toremove);
        }
        for (Channel channel : toremove) {
            ((ChannelProxy)channel).getRealChannel().notifyHangupListeners(-1, "Lingering channel probably due to missed hangup event");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpChannelList() {
        if (logger.isDebugEnabled()) {
            logger.debug("CallTracker: dump channellist:" + this);
            ArrayList<Channel> arrayList = this._associatedChannels;
            synchronized (arrayList) {
                for (Channel channel : this._associatedChannels) {
                    logger.debug("--> " + channel.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEnded() {
        ArrayList<Channel> arrayList = this._associatedChannels;
        synchronized (arrayList) {
            return this._associatedChannels.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelHangup(Channel channel, Integer cause, String causeText) {
        this.remove(channel);
        ArrayList<Channel> arrayList = this._associatedChannels;
        synchronized (arrayList) {
            if (this._associatedChannels.size() == 0) {
                this._state = PeerState.NOTSET;
                this.notifyCallEndedListener();
            }
        }
    }

    private void notifyCallEndedListener() {
        this.listener.callEnded(this);
    }

    public String toString() {
        return this.listener + " : " + (Object)((Object)this._state);
    }
}

