/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.examples.activities;

import org.asteriskjava.pbx.ActivityCallback;
import org.asteriskjava.pbx.ActivityStatusEnum;
import org.asteriskjava.pbx.Call;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.TechType;
import org.asteriskjava.pbx.activities.DialActivity;
import org.asteriskjava.pbx.activities.HoldActivity;

public class Hold {
    public static void main(String[] args) {
        Hold.hold();
    }

    private static void hold() {
        PBX pbx = PBXFactory.getActivePBX();
        EndPoint from = pbx.buildEndPoint(TechType.SIP, "100");
        CallerID fromCallerID = pbx.buildCallerID("100", "My Phone");
        CallerID toCallerID = pbx.buildCallerID("83208100", "Asterisk Java is calling");
        EndPoint to = pbx.buildEndPoint("SIP/default/5551234");
        pbx.dial(from, fromCallerID, to, toCallerID, new ActivityCallback<DialActivity>(){

            @Override
            public void progress(DialActivity activity, ActivityStatusEnum status, String message) {
                if (status == ActivityStatusEnum.SUCCESS) {
                    System.out.println("Dial all good so lets place them on hold");
                    PBX pbx = PBXFactory.getActivePBX();
                    Call call = activity.getNewCall();
                    HoldActivity hold = pbx.hold(call.getRemoteParty());
                    Channel heldChannel = hold.getChannel();
                    System.out.println("Held channel is " + heldChannel);
                }
                if (status == ActivityStatusEnum.FAILURE) {
                    System.out.println("Oops something bad happened when we dialed.");
                }
            }
        });
    }
}

