/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.asteriskjava.manager.event.AgentCallbackLoginEvent;
import org.asteriskjava.manager.event.AgentCallbackLogoffEvent;
import org.asteriskjava.manager.event.AgentCalledEvent;
import org.asteriskjava.manager.event.AgentCompleteEvent;
import org.asteriskjava.manager.event.AgentConnectEvent;
import org.asteriskjava.manager.event.AgentDumpEvent;
import org.asteriskjava.manager.event.AgentLoginEvent;
import org.asteriskjava.manager.event.AgentLogoffEvent;
import org.asteriskjava.manager.event.AgentRingNoAnswerEvent;
import org.asteriskjava.manager.event.AgentsCompleteEvent;
import org.asteriskjava.manager.event.AgentsEvent;
import org.asteriskjava.manager.event.AgiExecEndEvent;
import org.asteriskjava.manager.event.AgiExecEvent;
import org.asteriskjava.manager.event.AgiExecStartEvent;
import org.asteriskjava.manager.event.AlarmClearEvent;
import org.asteriskjava.manager.event.AlarmEvent;
import org.asteriskjava.manager.event.AntennaLevelEvent;
import org.asteriskjava.manager.event.AsyncAgiEndEvent;
import org.asteriskjava.manager.event.AsyncAgiEvent;
import org.asteriskjava.manager.event.AsyncAgiExecEvent;
import org.asteriskjava.manager.event.AsyncAgiStartEvent;
import org.asteriskjava.manager.event.AttendedTransferEvent;
import org.asteriskjava.manager.event.BlindTransferEvent;
import org.asteriskjava.manager.event.BridgeCreateEvent;
import org.asteriskjava.manager.event.BridgeDestroyEvent;
import org.asteriskjava.manager.event.BridgeEnterEvent;
import org.asteriskjava.manager.event.BridgeEvent;
import org.asteriskjava.manager.event.BridgeExecEvent;
import org.asteriskjava.manager.event.BridgeLeaveEvent;
import org.asteriskjava.manager.event.BridgeMergeEvent;
import org.asteriskjava.manager.event.CdrEvent;
import org.asteriskjava.manager.event.CelEvent;
import org.asteriskjava.manager.event.ChallengeSentEvent;
import org.asteriskjava.manager.event.ChanSpyStartEvent;
import org.asteriskjava.manager.event.ChanSpyStopEvent;
import org.asteriskjava.manager.event.ChannelReloadEvent;
import org.asteriskjava.manager.event.ChannelUpdateEvent;
import org.asteriskjava.manager.event.ConfbridgeEndEvent;
import org.asteriskjava.manager.event.ConfbridgeJoinEvent;
import org.asteriskjava.manager.event.ConfbridgeLeaveEvent;
import org.asteriskjava.manager.event.ConfbridgeListCompleteEvent;
import org.asteriskjava.manager.event.ConfbridgeListEvent;
import org.asteriskjava.manager.event.ConfbridgeListRoomsCompleteEvent;
import org.asteriskjava.manager.event.ConfbridgeListRoomsEvent;
import org.asteriskjava.manager.event.ConfbridgeStartEvent;
import org.asteriskjava.manager.event.ConfbridgeTalkingEvent;
import org.asteriskjava.manager.event.ContactStatusEvent;
import org.asteriskjava.manager.event.CoreShowChannelEvent;
import org.asteriskjava.manager.event.CoreShowChannelsCompleteEvent;
import org.asteriskjava.manager.event.DAHDIChannelEvent;
import org.asteriskjava.manager.event.DahdiShowChannelsCompleteEvent;
import org.asteriskjava.manager.event.DahdiShowChannelsEvent;
import org.asteriskjava.manager.event.DbGetResponseEvent;
import org.asteriskjava.manager.event.DeviceStateChangeEvent;
import org.asteriskjava.manager.event.DialBeginEvent;
import org.asteriskjava.manager.event.DialEndEvent;
import org.asteriskjava.manager.event.DialEvent;
import org.asteriskjava.manager.event.DndStateEvent;
import org.asteriskjava.manager.event.DongleCENDEvent;
import org.asteriskjava.manager.event.DongleCallStateChangeEvent;
import org.asteriskjava.manager.event.DongleDeviceEntryEvent;
import org.asteriskjava.manager.event.DongleNewCMGREvent;
import org.asteriskjava.manager.event.DongleNewSMSBase64Event;
import org.asteriskjava.manager.event.DongleNewSMSEvent;
import org.asteriskjava.manager.event.DongleShowDevicesCompleteEvent;
import org.asteriskjava.manager.event.DongleStatusEvent;
import org.asteriskjava.manager.event.DtmfBeginEvent;
import org.asteriskjava.manager.event.DtmfEndEvent;
import org.asteriskjava.manager.event.DtmfEvent;
import org.asteriskjava.manager.event.ExtensionStatusEvent;
import org.asteriskjava.manager.event.FaxDocumentStatusEvent;
import org.asteriskjava.manager.event.FaxReceivedEvent;
import org.asteriskjava.manager.event.FaxStatusEvent;
import org.asteriskjava.manager.event.FullyBootedEvent;
import org.asteriskjava.manager.event.HangupEvent;
import org.asteriskjava.manager.event.HangupRequestEvent;
import org.asteriskjava.manager.event.HoldEvent;
import org.asteriskjava.manager.event.HoldedCallEvent;
import org.asteriskjava.manager.event.InvalidPasswordEvent;
import org.asteriskjava.manager.event.JabberEventEvent;
import org.asteriskjava.manager.event.JitterBufStatsEvent;
import org.asteriskjava.manager.event.JoinEvent;
import org.asteriskjava.manager.event.LeaveEvent;
import org.asteriskjava.manager.event.LinkEvent;
import org.asteriskjava.manager.event.ListDialplanEvent;
import org.asteriskjava.manager.event.LocalBridgeEvent;
import org.asteriskjava.manager.event.LocalOptimizationBeginEvent;
import org.asteriskjava.manager.event.LocalOptimizationEndEvent;
import org.asteriskjava.manager.event.LogChannelEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.MasqueradeEvent;
import org.asteriskjava.manager.event.MeetMeEndEvent;
import org.asteriskjava.manager.event.MeetMeJoinEvent;
import org.asteriskjava.manager.event.MeetMeLeaveEvent;
import org.asteriskjava.manager.event.MeetMeMuteEvent;
import org.asteriskjava.manager.event.MeetMeStopTalkingEvent;
import org.asteriskjava.manager.event.MeetMeTalkingEvent;
import org.asteriskjava.manager.event.MeetMeTalkingRequestEvent;
import org.asteriskjava.manager.event.MessageWaitingEvent;
import org.asteriskjava.manager.event.ModuleLoadReportEvent;
import org.asteriskjava.manager.event.MonitorStartEvent;
import org.asteriskjava.manager.event.MonitorStopEvent;
import org.asteriskjava.manager.event.MusicOnHoldEvent;
import org.asteriskjava.manager.event.MusicOnHoldStartEvent;
import org.asteriskjava.manager.event.MusicOnHoldStopEvent;
import org.asteriskjava.manager.event.NewAccountCodeEvent;
import org.asteriskjava.manager.event.NewCallerIdEvent;
import org.asteriskjava.manager.event.NewChannelEvent;
import org.asteriskjava.manager.event.NewConnectedLineEvent;
import org.asteriskjava.manager.event.NewExtenEvent;
import org.asteriskjava.manager.event.NewStateEvent;
import org.asteriskjava.manager.event.OriginateFailureEvent;
import org.asteriskjava.manager.event.OriginateResponseEvent;
import org.asteriskjava.manager.event.OriginateSuccessEvent;
import org.asteriskjava.manager.event.ParkedCallEvent;
import org.asteriskjava.manager.event.ParkedCallGiveUpEvent;
import org.asteriskjava.manager.event.ParkedCallTimeOutEvent;
import org.asteriskjava.manager.event.ParkedCallsCompleteEvent;
import org.asteriskjava.manager.event.PausedEvent;
import org.asteriskjava.manager.event.PeerEntryEvent;
import org.asteriskjava.manager.event.PeerStatusEvent;
import org.asteriskjava.manager.event.PeerlistCompleteEvent;
import org.asteriskjava.manager.event.PeersEvent;
import org.asteriskjava.manager.event.PickupEvent;
import org.asteriskjava.manager.event.PriEventEvent;
import org.asteriskjava.manager.event.QueueCallerAbandonEvent;
import org.asteriskjava.manager.event.QueueCallerJoinEvent;
import org.asteriskjava.manager.event.QueueCallerLeaveEvent;
import org.asteriskjava.manager.event.QueueEntryEvent;
import org.asteriskjava.manager.event.QueueMemberAddedEvent;
import org.asteriskjava.manager.event.QueueMemberEvent;
import org.asteriskjava.manager.event.QueueMemberPauseEvent;
import org.asteriskjava.manager.event.QueueMemberPausedEvent;
import org.asteriskjava.manager.event.QueueMemberPenaltyEvent;
import org.asteriskjava.manager.event.QueueMemberRemovedEvent;
import org.asteriskjava.manager.event.QueueMemberStatusEvent;
import org.asteriskjava.manager.event.QueueParamsEvent;
import org.asteriskjava.manager.event.QueueStatusCompleteEvent;
import org.asteriskjava.manager.event.QueueSummaryCompleteEvent;
import org.asteriskjava.manager.event.QueueSummaryEvent;
import org.asteriskjava.manager.event.ReceiveFaxEvent;
import org.asteriskjava.manager.event.RegistrationsCompleteEvent;
import org.asteriskjava.manager.event.RegistryEntryEvent;
import org.asteriskjava.manager.event.RegistryEvent;
import org.asteriskjava.manager.event.ReloadEvent;
import org.asteriskjava.manager.event.RenameEvent;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.manager.event.RtcpReceivedEvent;
import org.asteriskjava.manager.event.RtcpSentEvent;
import org.asteriskjava.manager.event.RtpReceiverStatEvent;
import org.asteriskjava.manager.event.RtpSenderStatEvent;
import org.asteriskjava.manager.event.SendFaxEvent;
import org.asteriskjava.manager.event.SendFaxStatusEvent;
import org.asteriskjava.manager.event.ShowDialplanCompleteEvent;
import org.asteriskjava.manager.event.ShutdownEvent;
import org.asteriskjava.manager.event.SkypeAccountStatusEvent;
import org.asteriskjava.manager.event.SkypeBuddyEntryEvent;
import org.asteriskjava.manager.event.SkypeBuddyListCompleteEvent;
import org.asteriskjava.manager.event.SkypeBuddyStatusEvent;
import org.asteriskjava.manager.event.SkypeChatMessageEvent;
import org.asteriskjava.manager.event.SkypeLicenseEvent;
import org.asteriskjava.manager.event.SkypeLicenseListCompleteEvent;
import org.asteriskjava.manager.event.SoftHangupRequestEvent;
import org.asteriskjava.manager.event.StatusCompleteEvent;
import org.asteriskjava.manager.event.StatusEvent;
import org.asteriskjava.manager.event.SuccessfulAuthEvent;
import org.asteriskjava.manager.event.T38FaxStatusEvent;
import org.asteriskjava.manager.event.TransferEvent;
import org.asteriskjava.manager.event.UnholdEvent;
import org.asteriskjava.manager.event.UnlinkEvent;
import org.asteriskjava.manager.event.UnparkedCallEvent;
import org.asteriskjava.manager.event.UnpausedEvent;
import org.asteriskjava.manager.event.UserEvent;
import org.asteriskjava.manager.event.VarSetEvent;
import org.asteriskjava.manager.event.VoicemailUserEntryCompleteEvent;
import org.asteriskjava.manager.event.VoicemailUserEntryEvent;
import org.asteriskjava.manager.event.ZapShowChannelsCompleteEvent;
import org.asteriskjava.manager.event.ZapShowChannelsEvent;
import org.asteriskjava.manager.internal.AbstractBuilder;
import org.asteriskjava.manager.internal.EventBuilder;
import org.asteriskjava.manager.internal.ManagerUtil;

class EventBuilderImpl
extends AbstractBuilder
implements EventBuilder {
    private static final Set<String> ignoredAttributes = new HashSet<String>(Arrays.asList("event"));
    private Map<String, Class<?>> registeredEventClasses = new HashMap();

    EventBuilderImpl() {
        this.registerBuiltinEventClasses();
    }

    private void registerBuiltinEventClasses() {
        this.registerEventClass(AgentCallbackLoginEvent.class);
        this.registerEventClass(AgentCallbackLogoffEvent.class);
        this.registerEventClass(AgentCalledEvent.class);
        this.registerEventClass(AgentConnectEvent.class);
        this.registerEventClass(AgentCompleteEvent.class);
        this.registerEventClass(AgentDumpEvent.class);
        this.registerEventClass(AgentLoginEvent.class);
        this.registerEventClass(AgentLogoffEvent.class);
        this.registerEventClass(AgentRingNoAnswerEvent.class);
        this.registerEventClass(AgentsEvent.class);
        this.registerEventClass(AgentsCompleteEvent.class);
        this.registerEventClass(AgiExecEndEvent.class);
        this.registerEventClass(AgiExecEvent.class);
        this.registerEventClass(AgiExecStartEvent.class);
        this.registerEventClass(AntennaLevelEvent.class);
        this.registerEventClass(AsyncAgiEvent.class);
        this.registerEventClass(AsyncAgiEndEvent.class);
        this.registerEventClass(AsyncAgiExecEvent.class);
        this.registerEventClass(AsyncAgiStartEvent.class);
        this.registerEventClass(AlarmEvent.class);
        this.registerEventClass(AlarmClearEvent.class);
        this.registerEventClass(BridgeCreateEvent.class);
        this.registerEventClass(BridgeDestroyEvent.class);
        this.registerEventClass(BridgeEnterEvent.class);
        this.registerEventClass(BridgeEvent.class);
        this.registerEventClass(BridgeExecEvent.class);
        this.registerEventClass(BridgeLeaveEvent.class);
        this.registerEventClass(BridgeMergeEvent.class);
        this.registerEventClass(BlindTransferEvent.class);
        this.registerEventClass(AttendedTransferEvent.class);
        this.registerEventClass(CdrEvent.class);
        this.registerEventClass(CelEvent.class);
        this.registerEventClass(ChallengeSentEvent.class);
        this.registerEventClass(ChannelReloadEvent.class);
        this.registerEventClass(ChannelUpdateEvent.class);
        this.registerEventClass(ChanSpyStartEvent.class);
        this.registerEventClass(ChanSpyStopEvent.class);
        this.registerEventClass(ConfbridgeEndEvent.class);
        this.registerEventClass(ConfbridgeJoinEvent.class);
        this.registerEventClass(ConfbridgeLeaveEvent.class);
        this.registerEventClass(ConfbridgeListEvent.class);
        this.registerEventClass(ConfbridgeListCompleteEvent.class);
        this.registerEventClass(ConfbridgeListRoomsEvent.class);
        this.registerEventClass(ConfbridgeListRoomsCompleteEvent.class);
        this.registerEventClass(ConfbridgeStartEvent.class);
        this.registerEventClass(ConfbridgeTalkingEvent.class);
        this.registerEventClass(ContactStatusEvent.class);
        this.registerEventClass(CoreShowChannelEvent.class);
        this.registerEventClass(CoreShowChannelsCompleteEvent.class);
        this.registerEventClass(DAHDIChannelEvent.class);
        this.registerEventClass(DahdiShowChannelsEvent.class);
        this.registerEventClass(DahdiShowChannelsCompleteEvent.class);
        this.registerEventClass(DbGetResponseEvent.class);
        this.registerEventClass(DeviceStateChangeEvent.class);
        this.registerEventClass(DialBeginEvent.class);
        this.registerEventClass(DialEndEvent.class);
        this.registerEventClass(DialEvent.class);
        this.registerEventClass(DndStateEvent.class);
        this.registerEventClass(DongleNewSMSBase64Event.class);
        this.registerEventClass(DongleCENDEvent.class);
        this.registerEventClass(DongleCallStateChangeEvent.class);
        this.registerEventClass(DongleNewSMSEvent.class);
        this.registerEventClass(DongleNewCMGREvent.class);
        this.registerEventClass(DongleStatusEvent.class);
        this.registerEventClass(DongleDeviceEntryEvent.class);
        this.registerEventClass(DongleShowDevicesCompleteEvent.class);
        this.registerEventClass(DtmfBeginEvent.class);
        this.registerEventClass(DtmfEndEvent.class);
        this.registerEventClass(DtmfEvent.class);
        this.registerEventClass(ExtensionStatusEvent.class);
        this.registerEventClass(FaxDocumentStatusEvent.class);
        this.registerEventClass(FaxReceivedEvent.class);
        this.registerEventClass(FaxStatusEvent.class);
        this.registerEventClass(FullyBootedEvent.class);
        this.registerEventClass(HangupEvent.class);
        this.registerEventClass(HangupRequestEvent.class);
        this.registerEventClass(HoldedCallEvent.class);
        this.registerEventClass(HoldEvent.class);
        this.registerEventClass(InvalidPasswordEvent.class);
        this.registerEventClass(JabberEventEvent.class);
        this.registerEventClass(JitterBufStatsEvent.class);
        this.registerEventClass(JoinEvent.class);
        this.registerEventClass(LeaveEvent.class);
        this.registerEventClass(LinkEvent.class);
        this.registerEventClass(ListDialplanEvent.class);
        this.registerEventClass(LocalBridgeEvent.class);
        this.registerEventClass(LocalOptimizationBeginEvent.class);
        this.registerEventClass(LocalOptimizationEndEvent.class);
        this.registerEventClass(LogChannelEvent.class);
        this.registerEventClass(NewConnectedLineEvent.class);
        this.registerEventClass(MasqueradeEvent.class);
        this.registerEventClass(MeetMeEndEvent.class);
        this.registerEventClass(MeetMeJoinEvent.class);
        this.registerEventClass(MeetMeLeaveEvent.class);
        this.registerEventClass(MeetMeMuteEvent.class);
        this.registerEventClass(MeetMeTalkingEvent.class);
        this.registerEventClass(MeetMeTalkingRequestEvent.class);
        this.registerEventClass(MeetMeStopTalkingEvent.class);
        this.registerEventClass(MessageWaitingEvent.class);
        this.registerEventClass(ModuleLoadReportEvent.class);
        this.registerEventClass(MonitorStartEvent.class);
        this.registerEventClass(MonitorStopEvent.class);
        this.registerEventClass(MusicOnHoldEvent.class);
        this.registerEventClass(MusicOnHoldStartEvent.class);
        this.registerEventClass(MusicOnHoldStopEvent.class);
        this.registerEventClass(NewAccountCodeEvent.class);
        this.registerEventClass(NewCallerIdEvent.class);
        this.registerEventClass(NewChannelEvent.class);
        this.registerEventClass(NewExtenEvent.class);
        this.registerEventClass(NewStateEvent.class);
        this.registerEventClass(OriginateFailureEvent.class);
        this.registerEventClass(OriginateSuccessEvent.class);
        this.registerEventClass(OriginateResponseEvent.class);
        this.registerEventClass(ParkedCallGiveUpEvent.class);
        this.registerEventClass(ParkedCallEvent.class);
        this.registerEventClass(ParkedCallTimeOutEvent.class);
        this.registerEventClass(ParkedCallsCompleteEvent.class);
        this.registerEventClass(PausedEvent.class);
        this.registerEventClass(PeerEntryEvent.class);
        this.registerEventClass(PeerlistCompleteEvent.class);
        this.registerEventClass(PeersEvent.class);
        this.registerEventClass(PeerStatusEvent.class);
        this.registerEventClass(PickupEvent.class);
        this.registerEventClass(PriEventEvent.class);
        this.registerEventClass(QueueCallerAbandonEvent.class);
        this.registerEventClass(QueueCallerJoinEvent.class);
        this.registerEventClass(QueueCallerLeaveEvent.class);
        this.registerEventClass(QueueEntryEvent.class);
        this.registerEventClass(QueueMemberAddedEvent.class);
        this.registerEventClass(QueueMemberEvent.class);
        this.registerEventClass(QueueMemberPausedEvent.class);
        this.registerEventClass(QueueMemberPauseEvent.class);
        this.registerEventClass(QueueMemberPenaltyEvent.class);
        this.registerEventClass(QueueMemberRemovedEvent.class);
        this.registerEventClass(QueueMemberStatusEvent.class);
        this.registerEventClass(QueueParamsEvent.class);
        this.registerEventClass(QueueStatusCompleteEvent.class);
        this.registerEventClass(QueueSummaryCompleteEvent.class);
        this.registerEventClass(QueueSummaryEvent.class);
        this.registerEventClass(ReceiveFaxEvent.class);
        this.registerEventClass(RegistrationsCompleteEvent.class);
        this.registerEventClass(RegistryEntryEvent.class);
        this.registerEventClass(RegistryEvent.class);
        this.registerEventClass(ReloadEvent.class);
        this.registerEventClass(RenameEvent.class);
        this.registerEventClass(RtcpReceivedEvent.class);
        this.registerEventClass(RtcpSentEvent.class);
        this.registerEventClass(RtpReceiverStatEvent.class);
        this.registerEventClass(RtpSenderStatEvent.class);
        this.registerEventClass(SendFaxStatusEvent.class);
        this.registerEventClass(SendFaxEvent.class);
        this.registerEventClass(SkypeAccountStatusEvent.class);
        this.registerEventClass(SkypeBuddyEntryEvent.class);
        this.registerEventClass(SkypeBuddyListCompleteEvent.class);
        this.registerEventClass(SkypeBuddyStatusEvent.class);
        this.registerEventClass(SkypeChatMessageEvent.class);
        this.registerEventClass(SkypeLicenseEvent.class);
        this.registerEventClass(SkypeLicenseListCompleteEvent.class);
        this.registerEventClass(ShowDialplanCompleteEvent.class);
        this.registerEventClass(ShutdownEvent.class);
        this.registerEventClass(SoftHangupRequestEvent.class);
        this.registerEventClass(StatusEvent.class);
        this.registerEventClass(StatusCompleteEvent.class);
        this.registerEventClass(SuccessfulAuthEvent.class);
        this.registerEventClass(T38FaxStatusEvent.class);
        this.registerEventClass(TransferEvent.class);
        this.registerEventClass(UnholdEvent.class);
        this.registerEventClass(UnpausedEvent.class);
        this.registerEventClass(UnlinkEvent.class);
        this.registerEventClass(UnparkedCallEvent.class);
        this.registerEventClass(VarSetEvent.class);
        this.registerEventClass(VoicemailUserEntryCompleteEvent.class);
        this.registerEventClass(VoicemailUserEntryEvent.class);
        this.registerEventClass(ZapShowChannelsEvent.class);
        this.registerEventClass(ZapShowChannelsCompleteEvent.class);
    }

    @Override
    public final void registerEventClass(Class<? extends ManagerEvent> clazz) throws IllegalArgumentException {
        String className = clazz.getName();
        String eventType = className.substring(className.lastIndexOf(46) + 1).toLowerCase(Locale.ENGLISH);
        if (eventType.endsWith("event")) {
            eventType = eventType.substring(0, eventType.length() - "event".length());
        }
        if (UserEvent.class.isAssignableFrom(clazz) && !eventType.startsWith("userevent")) {
            eventType = "userevent" + eventType;
        }
        this.registerEventClass(eventType, clazz);
    }

    public final void registerEventClass(String eventType, Class<? extends ManagerEvent> clazz) throws IllegalArgumentException {
        Constructor<? extends ManagerEvent> defaultConstructor;
        if (!ManagerEvent.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not a ManagerEvent");
        }
        if ((clazz.getModifiers() & 0x400) != 0) {
            throw new IllegalArgumentException(clazz + " is abstract");
        }
        try {
            defaultConstructor = clazz.getConstructor(Object.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(clazz + " has no usable constructor");
        }
        if ((defaultConstructor.getModifiers() & 1) == 0) {
            throw new IllegalArgumentException(clazz + " has no public default constructor");
        }
        this.registeredEventClasses.put(eventType.toLowerCase(Locale.US), clazz);
        this.logger.debug("Registered event type '" + eventType + "' (" + clazz + ")");
    }

    @Override
    public ManagerEvent buildEvent(Object source, Map<String, Object> attributes) {
        ResponseEvent responseEvent;
        String actionId;
        ManagerEvent event;
        Constructor<?> constructor;
        String eventType = null;
        if (attributes.get("event") == null) {
            this.logger.error("No event type in properties");
            return null;
        }
        if (attributes.get("event") instanceof List) {
            List eventNames = (List)attributes.get("event");
            if (!eventNames.isEmpty() && "PeerEntry".equals(eventNames.get(0))) {
                int peersAmount = attributes.get("listitems") != null ? Integer.parseInt((String)attributes.get("listitems")) : eventNames.size() - 1;
                ArrayList<Map<String, Object>> peersAttributes = new ArrayList<Map<String, Object>>();
                for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
                    String key = attribute.getKey();
                    Object value = attribute.getValue();
                    for (int i = 0; i < peersAmount; ++i) {
                        Map<String, Object> peerAttrs;
                        if (peersAttributes.size() > i) {
                            peerAttrs = (Map)peersAttributes.get(i);
                        } else {
                            peerAttrs = new HashMap();
                            peersAttributes.add(i, peerAttrs);
                        }
                        if (value instanceof List) {
                            peerAttrs.put(key, ((List)value).get(i));
                            continue;
                        }
                        if (!(value instanceof String) || "listitems".equals(key)) continue;
                        peerAttrs.put(key, value);
                    }
                }
                attributes.put("peersAttributes", peersAttributes);
                eventType = "peers";
            }
        } else {
            if (!(attributes.get("event") instanceof String)) {
                this.logger.error("Event type is not a String or List");
                return null;
            }
            eventType = ((String)attributes.get("event")).toLowerCase(Locale.US);
            if ("userevent".equals(eventType)) {
                if (attributes.get("userevent") == null) {
                    this.logger.error("No user event type in properties");
                    return null;
                }
                if (!(attributes.get("userevent") instanceof String)) {
                    this.logger.error("User event type is not a String");
                    return null;
                }
                String userEventType = ((String)attributes.get("userevent")).toLowerCase(Locale.US);
                eventType = eventType + userEventType;
            }
        }
        Class<?> eventClass = this.registeredEventClasses.get(eventType);
        if (eventClass == null) {
            this.logger.info("No event class registered for event type '" + eventType + "', attributes: " + attributes + ". Please report at https://github.com/asterisk-java/asterisk-java/issues");
            return null;
        }
        try {
            constructor = eventClass.getConstructor(Object.class);
        }
        catch (NoSuchMethodException ex) {
            this.logger.error("Unable to get constructor of " + eventClass.getName(), ex);
            return null;
        }
        try {
            event = (ManagerEvent)constructor.newInstance(source);
        }
        catch (Exception ex) {
            this.logger.error("Unable to create new instance of " + eventClass.getName(), ex);
            return null;
        }
        if (attributes.get("peersAttributes") != null && attributes.get("peersAttributes") instanceof List) {
            PeersEvent peersEvent = (PeersEvent)event;
            for (Map peerAttrs : (List)attributes.get("peersAttributes")) {
                PeerEntryEvent peerEntryEvent = new PeerEntryEvent(source);
                this.setAttributes(peerEntryEvent, peerAttrs, ignoredAttributes);
                List<PeerEntryEvent> peerEntryEvents = peersEvent.getChildEvents();
                if (peerEntryEvents == null) {
                    peerEntryEvents = new ArrayList<PeerEntryEvent>();
                    peersEvent.setChildEvents(peerEntryEvents);
                }
                peerEntryEvents.add(peerEntryEvent);
            }
            peersEvent.setActionId(peersEvent.getChildEvents().get(0).getActionId());
        } else {
            this.setAttributes(event, attributes, ignoredAttributes);
        }
        if (event instanceof ResponseEvent && (actionId = (responseEvent = (ResponseEvent)event).getActionId()) != null) {
            responseEvent.setActionId(ManagerUtil.stripInternalActionId(actionId));
            responseEvent.setInternalActionId(ManagerUtil.getInternalActionId(actionId));
        }
        return event;
    }

    @Override
    public void deregisterEventClass(Class<? extends ManagerEvent> eventClass) {
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry<String, Class<?>> registered : this.registeredEventClasses.entrySet()) {
            if (!registered.getValue().equals(eventClass)) continue;
            toRemove.add(registered.getKey());
        }
        if (toRemove.isEmpty()) {
            this.logger.warn("Couldn't remove event type " + eventClass);
        } else {
            for (String key : toRemove) {
                this.registeredEventClasses.remove(key);
                this.logger.warn("Removed event type " + key);
            }
        }
    }
}

