/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.aaproperties;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AminoAcidProperties {
    private static final Set<String> negChargedAAs = Stream.of("D", "E").collect(Collectors.toSet());
    private static final Set<String> posChargedAAs = Stream.of("K", "R", "H").collect(Collectors.toSet());
    private static final Set<String> polarAAs = Stream.of("D", "E", "K", "R", "H", "N", "Q", "S", "T", "Y").collect(Collectors.toSet());

    public static final boolean isCharged(char aa) {
        if (negChargedAAs.contains(String.valueOf(aa))) {
            return true;
        }
        return posChargedAAs.contains(String.valueOf(aa));
    }

    public static final int getChargeOfAminoAcid(char aa) {
        if (negChargedAAs.contains(String.valueOf(aa))) {
            return -1;
        }
        if (posChargedAAs.contains(String.valueOf(aa))) {
            return 1;
        }
        return 0;
    }

    public static final boolean isPolar(char aa) {
        return polarAAs.contains(String.valueOf(aa));
    }

    public static final int getPolarityOfAminoAcid(char aa) {
        if (polarAAs.contains(String.valueOf(aa))) {
            return 1;
        }
        return 0;
    }
}

