/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.aaproperties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import org.biojava.nbio.aaproperties.Constraints;
import org.biojava.nbio.aaproperties.IPeptideProperties;
import org.biojava.nbio.aaproperties.PeptideProperties;
import org.biojava.nbio.aaproperties.Utils;
import org.biojava.nbio.aaproperties.xml.AminoAcidCompositionTable;
import org.biojava.nbio.aaproperties.xml.ElementTable;
import org.biojava.nbio.aaproperties.xml.MyValidationEventHandler;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeptidePropertiesImpl
implements IPeptideProperties {
    private static final Logger logger = LoggerFactory.getLogger(PeptidePropertiesImpl.class);
    private final double[][] cPk = new double[][]{{3.55, 7.59, 0.0}, {3.55, 7.5, 0.0}, {3.55, 7.5, 9.0}, {3.55, 7.5, 4.05}, {3.55, 7.7, 4.45}, {3.55, 7.5, 0.0}, {3.55, 7.5, 0.0}, {3.55, 7.5, 5.98}, {3.55, 7.5, 0.0}, {0.0, 0.0, 0.0}, {3.55, 7.5, 10.0}, {3.55, 7.5, 0.0}, {3.55, 7.0, 0.0}, {3.55, 7.5, 0.0}, {0.0, 0.0, 0.0}, {3.55, 8.36, 0.0}, {3.55, 7.5, 0.0}, {3.55, 7.5, 12.0}, {3.55, 6.93, 0.0}, {3.55, 6.82, 0.0}, {0.0, 0.0, 0.0}, {3.55, 7.44, 0.0}, {3.55, 7.5, 0.0}, {3.55, 7.5, 0.0}, {3.55, 7.5, 10.0}, {3.55, 7.5, 0.0}};
    private final double PH_MIN = 0.0;
    private final double PH_MAX = 14.0;
    private final double MAXLOOP = 2000.0;
    private final double EPSI = 1.0E-4;

    private double getWaterMoleculeWeight() {
        double hydrogenMW = 1.0079;
        double hydroxideMW = 17.0073;
        return 18.0152;
    }

    private char[] getSequence(String sequence, boolean ignoreCase) {
        if (ignoreCase) {
            return sequence.toUpperCase().toCharArray();
        }
        return sequence.toCharArray();
    }

    @Override
    public double getMolecularWeight(ProteinSequence sequence) {
        char[] seq;
        double value = 0.0;
        AminoAcidCompoundSet aaSet = new AminoAcidCompoundSet();
        for (char aa : seq = this.getSequence(sequence.toString(), true)) {
            AminoAcidCompound c = aaSet.getCompoundForString(String.valueOf(aa));
            if (!Constraints.aa2MolecularWeight.containsKey(c)) continue;
            value += Constraints.aa2MolecularWeight.get(c).doubleValue();
        }
        if (value == 0.0) {
            return value;
        }
        return value + this.getWaterMoleculeWeight();
    }

    @Override
    public double getMolecularWeight(ProteinSequence sequence, File aminoAcidCompositionFile) throws JAXBException, FileNotFoundException {
        File elementMassFile = new File("./src/main/resources/ElementMass.xml");
        if (!elementMassFile.exists()) {
            throw new FileNotFoundException("Cannot locate ElementMass.xml. Please use getMolecularWeight(ProteinSequence, File, File) to specify ElementMass.xml location.");
        }
        return this.getMolecularWeightBasedOnXML(sequence, this.obtainAminoAcidCompositionTable(elementMassFile, aminoAcidCompositionFile));
    }

    @Override
    public double getMolecularWeight(ProteinSequence sequence, File elementMassFile, File aminoAcidCompositionFile) throws JAXBException, FileNotFoundException {
        return this.getMolecularWeightBasedOnXML(sequence, this.obtainAminoAcidCompositionTable(elementMassFile, aminoAcidCompositionFile));
    }

    @Override
    public double getMolecularWeightBasedOnXML(ProteinSequence sequence, AminoAcidCompositionTable aminoAcidCompositionTable) {
        char[] seq;
        double value = 0.0;
        for (char aa : seq = sequence.toString().toCharArray()) {
            Double weight = aminoAcidCompositionTable.getMolecularWeight(Character.valueOf(aa));
            if (weight == null) continue;
            value += weight.doubleValue();
        }
        if (value == 0.0) {
            return value;
        }
        return value + this.getWaterMoleculeWeight();
    }

    @Override
    public AminoAcidCompositionTable obtainAminoAcidCompositionTable(File aminoAcidCompositionFile) throws JAXBException, FileNotFoundException {
        File elementMassFile = new File("./src/main/resources/ElementMass.xml");
        if (!elementMassFile.exists()) {
            throw new FileNotFoundException("Cannot locate ElementMass.xml. Please use getMolecularWeight(ProteinSequence, File, File) to specify ElementMass.xml location.");
        }
        return this.obtainAminoAcidCompositionTable(elementMassFile, aminoAcidCompositionFile);
    }

    @Override
    public AminoAcidCompositionTable obtainAminoAcidCompositionTable(File elementMassFile, File aminoAcidCompositionFile) throws JAXBException, FileNotFoundException {
        ElementTable iTable = new ElementTable();
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{iTable.getClass()});
        Unmarshaller u = jc.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new MyValidationEventHandler());
        iTable = (ElementTable)u.unmarshal((InputStream)new FileInputStream(elementMassFile));
        iTable.populateMaps();
        AminoAcidCompositionTable aTable = new AminoAcidCompositionTable();
        JAXBContext jc2 = JAXBContext.newInstance((Class[])new Class[]{aTable.getClass()});
        Unmarshaller u2 = jc2.createUnmarshaller();
        u2.setEventHandler((ValidationEventHandler)new MyValidationEventHandler());
        aTable = (AminoAcidCompositionTable)u2.unmarshal((InputStream)new FileInputStream(aminoAcidCompositionFile));
        aTable.computeMolecularWeight(iTable);
        return aTable;
    }

    @Override
    public double getExtinctionCoefficient(ProteinSequence sequence, boolean assumeCysReduced) {
        AminoAcidCompoundSet aaSet = new AminoAcidCompoundSet();
        Map<AminoAcidCompound, Integer> extinctAA2Count = this.getExtinctAACount(sequence);
        double eProt = !assumeCysReduced ? (double)extinctAA2Count.get(aaSet.getCompoundForString("Y")).intValue() * Constraints.aa2ExtinctionCoefficient.get(aaSet.getCompoundForString("Y")) + (double)extinctAA2Count.get(aaSet.getCompoundForString("W")).intValue() * Constraints.aa2ExtinctionCoefficient.get(aaSet.getCompoundForString("W")) + (double)extinctAA2Count.get(aaSet.getCompoundForString("C")).intValue() * Constraints.aa2ExtinctionCoefficient.get(aaSet.getCompoundForString("C")) : (double)extinctAA2Count.get(aaSet.getCompoundForString("Y")).intValue() * Constraints.aa2ExtinctionCoefficient.get(aaSet.getCompoundForString("Y")) + (double)extinctAA2Count.get(aaSet.getCompoundForString("W")).intValue() * Constraints.aa2ExtinctionCoefficient.get(aaSet.getCompoundForString("W"));
        return eProt;
    }

    @Override
    public double getAbsorbance(ProteinSequence sequence, boolean assumeCysReduced) {
        double mw = this.getMolecularWeight(sequence);
        double eProt = this.getExtinctionCoefficient(sequence, assumeCysReduced);
        if (mw == 0.0) {
            logger.warn("Molecular weight is 0.0, can't divide by 0: setting absorbance to 0.0");
            return 0.0;
        }
        return eProt / mw;
    }

    private Map<AminoAcidCompound, Integer> getExtinctAACount(ProteinSequence sequence) {
        int numW = 0;
        int smallW = 0;
        double numC = 0.0;
        double smallC = 0.0;
        int numY = 0;
        int smallY = 0;
        block8: for (char aa : sequence.getSequenceAsString().toCharArray()) {
            switch (aa) {
                case 'W': {
                    ++numW;
                    continue block8;
                }
                case 'w': {
                    ++smallW;
                    continue block8;
                }
                case 'C': {
                    numC += 0.5;
                    continue block8;
                }
                case 'c': {
                    smallC += 0.5;
                    continue block8;
                }
                case 'Y': {
                    ++numY;
                    continue block8;
                }
                case 'y': {
                    ++smallY;
                }
            }
        }
        AminoAcidCompoundSet aaSet = new AminoAcidCompoundSet();
        HashMap<AminoAcidCompound, Integer> extinctAA2Count = new HashMap<AminoAcidCompound, Integer>();
        extinctAA2Count.put(aaSet.getCompoundForString("W"), numW + smallW);
        extinctAA2Count.put(aaSet.getCompoundForString("C"), (int)(numC + smallC));
        extinctAA2Count.put(aaSet.getCompoundForString("Y"), numY + smallY);
        return extinctAA2Count;
    }

    @Override
    public double getInstabilityIndex(ProteinSequence sequence) {
        double sum = 0.0;
        String s = sequence.getSequenceAsString().toUpperCase();
        for (int i = 0; i < sequence.getLength() - 1; ++i) {
            String dipeptide = s.substring(i, i + 2);
            if (!Constraints.diAA2Instability.containsKey(dipeptide)) continue;
            sum += Constraints.diAA2Instability.get(dipeptide).doubleValue();
        }
        int denominator = s.length() - Utils.getNumberOfInvalidChar(s, null, true);
        if (denominator == 0) {
            logger.warn("Valid length of sequence is 0, can't divide by 0 to calculate instability index: setting instability index value to 0.0");
            return 0.0;
        }
        return sum * 10.0 / (double)denominator;
    }

    @Override
    public double getApliphaticIndex(ProteinSequence sequence) {
        AminoAcidCompoundSet aaSet = new AminoAcidCompoundSet();
        Map<AminoAcidCompound, Double> aa2Composition = this.getAAComposition(sequence);
        double a = 2.9;
        double b = 3.9;
        double xAla = aa2Composition.get(aaSet.getCompoundForString("A"));
        double xVal = aa2Composition.get(aaSet.getCompoundForString("V"));
        double xIle = aa2Composition.get(aaSet.getCompoundForString("I"));
        double xLeu = aa2Composition.get(aaSet.getCompoundForString("L"));
        return (xAla + 2.9 * xVal + 3.9 * (xIle + xLeu)) * 100.0;
    }

    @Override
    public double getAvgHydropathy(ProteinSequence sequence) {
        char[] seq;
        int validLength = 0;
        double total = 0.0;
        AminoAcidCompoundSet aaSet = new AminoAcidCompoundSet();
        for (char aa : seq = this.getSequence(sequence.toString(), true)) {
            AminoAcidCompound c = aaSet.getCompoundForString(String.valueOf(aa));
            if (!Constraints.aa2Hydrophathicity.containsKey(c)) continue;
            total += Constraints.aa2Hydrophathicity.get(c).doubleValue();
            ++validLength;
        }
        if (validLength == 0) {
            logger.warn("Valid length of sequence is 0, can't divide by 0 to calculate average hydropathy: setting average hydropathy to 0");
            return 0.0;
        }
        return total / (double)validLength;
    }

    @Override
    public double getIsoelectricPoint(ProteinSequence sequence, boolean useExpasyValues) {
        if (useExpasyValues) {
            return this.getIsoelectricPointExpasy(sequence.toString().toUpperCase());
        }
        return this.getIsoelectricPointInnovagen(sequence);
    }

    private double getIsoelectricPointInnovagen(ProteinSequence sequence) {
        double margin;
        double currentPH = 7.0;
        double changeSize = 7.0;
        String sequenceString = sequence.toString();
        char nTerminalChar = sequenceString.charAt(0);
        char cTerminalChar = sequenceString.charAt(sequenceString.length() - 1);
        Map<AminoAcidCompound, Integer> chargedAA2Count = this.getChargedAACount(sequence);
        double difference = 1.0E-4;
        while (!((margin = this.getNetChargeInnovagen(chargedAA2Count, currentPH, nTerminalChar, cTerminalChar)) <= 1.0E-4) || !(margin >= -1.0E-4)) {
            changeSize /= 2.0;
            if (margin > 0.0) {
                currentPH += changeSize;
                continue;
            }
            currentPH -= changeSize;
        }
        return currentPH;
    }

    private double exp10(double pka) {
        return Math.pow(10.0, pka);
    }

    private double getIsoelectricPointExpasy(String sequence) {
        int index;
        int[] comp = new int[26];
        for (int i = 0; i < sequence.length(); ++i) {
            index = sequence.charAt(i) - 65;
            if (index < 0 || index >= 26) continue;
            int n = index;
            comp[n] = comp[n] + 1;
        }
        int nTermResidue = -1;
        index = 0;
        while ((nTermResidue < 0 || nTermResidue >= 26) && index < 25) {
            nTermResidue = sequence.charAt(index++) - 65;
        }
        int cTermResidue = -1;
        index = 1;
        while ((cTermResidue < 0 || cTermResidue >= 26) && index < 25) {
            cTermResidue = sequence.charAt(sequence.length() - index++) - 65;
        }
        double phMin = 0.0;
        double phMax = 14.0;
        double phMid = 0.0;
        double charge = 1.0;
        int i = 0;
        while ((double)i < 2000.0 && phMax - phMin > 1.0E-4) {
            phMid = phMin + (phMax - phMin) / 2.0;
            charge = this.getNetChargeExpasy(comp, nTermResidue, cTermResidue, phMid);
            if (charge > 0.0) {
                phMin = phMid;
            } else {
                phMax = phMid;
            }
            ++i;
        }
        return phMid;
    }

    @Override
    public double getIsoelectricPoint(ProteinSequence sequence) {
        return this.getIsoelectricPoint(sequence, true);
    }

    @Override
    public double getNetCharge(ProteinSequence sequence) {
        return this.getNetCharge(sequence, true);
    }

    @Override
    public double getNetCharge(ProteinSequence sequence, boolean useExpasyValues) {
        return this.getNetCharge(sequence, true, 7.0);
    }

    @Override
    public double getNetCharge(ProteinSequence sequence, boolean useExpasyValues, double pHPoint) {
        if (useExpasyValues) {
            return this.getNetChargeExpasy(sequence.toString().toUpperCase(), pHPoint);
        }
        return this.getNetChargeInnovagen(sequence, pHPoint);
    }

    private double getNetChargeExpasy(String sequence, double pHPoint) {
        int[] comp = new int[26];
        for (int i = 0; i < sequence.length(); ++i) {
            int index = sequence.charAt(i) - 65;
            if (index < 0 || index >= 26) continue;
            int n = index;
            comp[n] = comp[n] + 1;
        }
        int nTermResidue = sequence.charAt(0) - 65;
        int cTermResidue = sequence.charAt(sequence.length() - 1) - 65;
        return this.getNetChargeExpasy(comp, nTermResidue, cTermResidue, pHPoint);
    }

    private double getNetChargeExpasy(int[] comp, int nTermResidue, int cTermResidue, double ph) {
        double cter = 0.0;
        if (cTermResidue >= 0 && cTermResidue < 26) {
            cter = this.exp10(-this.cPk[cTermResidue][0]) / (this.exp10(-this.cPk[cTermResidue][0]) + this.exp10(-ph));
        }
        double nter = 0.0;
        if (nTermResidue >= 0 && nTermResidue < 26) {
            nter = this.exp10(-ph) / (this.exp10(-this.cPk[nTermResidue][1]) + this.exp10(-ph));
        }
        double carg = (double)comp[17] * this.exp10(-ph) / (this.exp10(-this.cPk[17][2]) + this.exp10(-ph));
        double chis = (double)comp[7] * this.exp10(-ph) / (this.exp10(-this.cPk[7][2]) + this.exp10(-ph));
        double clys = (double)comp[10] * this.exp10(-ph) / (this.exp10(-this.cPk[10][2]) + this.exp10(-ph));
        double casp = (double)comp[3] * this.exp10(-this.cPk[3][2]) / (this.exp10(-this.cPk[3][2]) + this.exp10(-ph));
        double cglu = (double)comp[4] * this.exp10(-this.cPk[4][2]) / (this.exp10(-this.cPk[4][2]) + this.exp10(-ph));
        double ccys = (double)comp[2] * this.exp10(-this.cPk[2][2]) / (this.exp10(-this.cPk[2][2]) + this.exp10(-ph));
        double ctyr = (double)comp[24] * this.exp10(-this.cPk[24][2]) / (this.exp10(-this.cPk[24][2]) + this.exp10(-ph));
        return carg + clys + chis + nter - (casp + cglu + ctyr + ccys + cter);
    }

    private double getNetChargeInnovagen(ProteinSequence sequence, double pHPoint) {
        Map<AminoAcidCompound, Integer> chargedAA2Count = this.getChargedAACount(sequence);
        String sequenceString = sequence.getSequenceAsString();
        return this.getNetChargeInnovagen(chargedAA2Count, pHPoint, sequenceString.charAt(0), sequenceString.charAt(sequenceString.length() - 1));
    }

    private double getNetChargeInnovagen(Map<AminoAcidCompound, Integer> chargedAA2Count, double ph, char nTerminalChar, char cTerminalChar) {
        AminoAcidCompoundSet aaSet = new AminoAcidCompoundSet();
        double nTerminalCharge = 0.0;
        AminoAcidCompound nTermCompound = aaSet.getCompoundForString(String.valueOf(nTerminalChar));
        if (Constraints.aa2NTerminalPka.containsKey(nTermCompound)) {
            nTerminalCharge = this.getPosCharge(Constraints.aa2NTerminalPka.get(nTermCompound), ph);
        }
        double cTerminalCharge = 0.0;
        AminoAcidCompound cTermCompound = aaSet.getCompoundForString(String.valueOf(cTerminalChar));
        if (Constraints.aa2CTerminalPka.containsKey(cTermCompound)) {
            cTerminalCharge = this.getNegCharge(Constraints.aa2CTerminalPka.get(cTermCompound), ph);
        }
        double kCharge = (double)chargedAA2Count.get(aaSet.getCompoundForString("K")).intValue() * this.getPosCharge(Constraints.aa2PKa.get(aaSet.getCompoundForString("K")), ph);
        double rCharge = (double)chargedAA2Count.get(aaSet.getCompoundForString("R")).intValue() * this.getPosCharge(Constraints.aa2PKa.get(aaSet.getCompoundForString("R")), ph);
        double hCharge = (double)chargedAA2Count.get(aaSet.getCompoundForString("H")).intValue() * this.getPosCharge(Constraints.aa2PKa.get(aaSet.getCompoundForString("H")), ph);
        double dCharge = (double)chargedAA2Count.get(aaSet.getCompoundForString("D")).intValue() * this.getNegCharge(Constraints.aa2PKa.get(aaSet.getCompoundForString("D")), ph);
        double eCharge = (double)chargedAA2Count.get(aaSet.getCompoundForString("E")).intValue() * this.getNegCharge(Constraints.aa2PKa.get(aaSet.getCompoundForString("E")), ph);
        double cCharge = (double)chargedAA2Count.get(aaSet.getCompoundForString("C")).intValue() * this.getNegCharge(Constraints.aa2PKa.get(aaSet.getCompoundForString("C")), ph);
        double yCharge = (double)chargedAA2Count.get(aaSet.getCompoundForString("Y")).intValue() * this.getNegCharge(Constraints.aa2PKa.get(aaSet.getCompoundForString("Y")), ph);
        return nTerminalCharge + kCharge + rCharge + hCharge - (dCharge + eCharge + cCharge + yCharge + cTerminalCharge);
    }

    private double getPosCharge(double pka, double ph) {
        return Math.pow(10.0, pka) / (Math.pow(10.0, pka) + Math.pow(10.0, ph));
    }

    private double getNegCharge(double pka, double ph) {
        return Math.pow(10.0, ph) / (Math.pow(10.0, pka) + Math.pow(10.0, ph));
    }

    private Map<AminoAcidCompound, Integer> getChargedAACount(ProteinSequence sequence) {
        char[] seq;
        int numK = 0;
        int numR = 0;
        int numH = 0;
        int numD = 0;
        int numE = 0;
        int numC = 0;
        int numY = 0;
        block9: for (char aa : seq = this.getSequence(sequence.getSequenceAsString(), true)) {
            switch (aa) {
                case 'K': {
                    ++numK;
                    continue block9;
                }
                case 'R': {
                    ++numR;
                    continue block9;
                }
                case 'H': {
                    ++numH;
                    continue block9;
                }
                case 'D': {
                    ++numD;
                    continue block9;
                }
                case 'E': {
                    ++numE;
                    continue block9;
                }
                case 'C': {
                    ++numC;
                    continue block9;
                }
                case 'Y': {
                    ++numY;
                }
            }
        }
        AminoAcidCompoundSet aaSet = new AminoAcidCompoundSet();
        HashMap<AminoAcidCompound, Integer> chargedAA2Count = new HashMap<AminoAcidCompound, Integer>();
        chargedAA2Count.put(aaSet.getCompoundForString("K"), numK);
        chargedAA2Count.put(aaSet.getCompoundForString("R"), numR);
        chargedAA2Count.put(aaSet.getCompoundForString("H"), numH);
        chargedAA2Count.put(aaSet.getCompoundForString("D"), numD);
        chargedAA2Count.put(aaSet.getCompoundForString("E"), numE);
        chargedAA2Count.put(aaSet.getCompoundForString("C"), numC);
        chargedAA2Count.put(aaSet.getCompoundForString("Y"), numY);
        return chargedAA2Count;
    }

    @Override
    public double getEnrichment(ProteinSequence sequence, AminoAcidCompound aminoAcidCode) {
        char[] seq;
        double counter = 0.0;
        for (char aa : seq = this.getSequence(sequence.getSequenceAsString(), true)) {
            if (!aminoAcidCode.getShortName().equals(String.valueOf(aa))) continue;
            counter += 1.0;
        }
        return counter / (double)sequence.getLength();
    }

    @Override
    public Map<AminoAcidCompound, Double> getAAComposition(ProteinSequence sequence) {
        Object object;
        int validLength = 0;
        HashMap<AminoAcidCompound, Double> aa2Composition = new HashMap<AminoAcidCompound, Double>();
        AminoAcidCompoundSet aaSet = new AminoAcidCompoundSet();
        for (AminoAcidCompound aa : aaSet.getAllCompounds()) {
            aa2Composition.put(aa, 0.0);
        }
        char[] seq = this.getSequence(sequence.toString(), true);
        for (char aa : seq) {
            if (!PeptideProperties.standardAASet.contains(Character.valueOf(aa))) continue;
            AminoAcidCompound compound = aaSet.getCompoundForString(String.valueOf(aa));
            aa2Composition.put(compound, (Double)aa2Composition.get(compound) + 1.0);
            ++validLength;
        }
        if (validLength > 0) {
            object = aaSet.getAllCompounds().iterator();
            while (object.hasNext()) {
                AminoAcidCompound aa = (AminoAcidCompound)object.next();
                aa2Composition.put(aa, (Double)aa2Composition.get(aa) / (double)validLength);
            }
        } else {
            object = aaSet.getAllCompounds().iterator();
            while (object.hasNext()) {
                AminoAcidCompound aa = (AminoAcidCompound)object.next();
                aa2Composition.put(aa, 0.0);
            }
        }
        return aa2Composition;
    }

    @Override
    public double getAromaticity(ProteinSequence sequence) {
        char[] seq;
        int validLength = sequence.getSequenceAsString().length();
        if (validLength == 0) {
            logger.warn("Valid length of sequence is 0, can't divide by 0 to calculate aromaticity: setting aromaticity to 0");
            return 0.0;
        }
        int totalF = 0;
        int totalY = 0;
        int totalW = 0;
        block5: for (char aa : seq = this.getSequence(sequence.toString(), true)) {
            char amino = Character.toUpperCase(aa);
            switch (amino) {
                case 'F': {
                    ++totalF;
                    continue block5;
                }
                case 'Y': {
                    ++totalY;
                    continue block5;
                }
                case 'W': {
                    ++totalW;
                }
            }
        }
        return (double)(totalF + totalY + totalW) / (double)validLength;
    }
}

