/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.alignment.aaindex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.alignment.aaindex.ScaledSubstitutionMatrix;
import org.biojava.nbio.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;

public class AAIndexFileParser {
    int scale = -1;
    Map<String, SubstitutionMatrix<AminoAcidCompound>> matrices = new HashMap<String, SubstitutionMatrix<AminoAcidCompound>>();
    ScaledSubstitutionMatrix currentMatrix;
    String currentRows;
    String currentCols;
    int currentRowPos;
    private short[][] matrix;
    short max;
    short min;
    private List<AminoAcidCompound> rows;
    private List<AminoAcidCompound> cols;
    boolean inMatrix;
    boolean symmetricMatrix;

    public void parse(InputStream inputStream) throws IOException {
        this.currentMatrix = null;
        this.currentRows = "";
        this.currentCols = "";
        this.max = Short.MIN_VALUE;
        this.min = Short.MAX_VALUE;
        this.inMatrix = false;
        BufferedReader buf = new BufferedReader(new InputStreamReader(inputStream));
        String line = null;
        line = buf.readLine();
        while (line != null) {
            if (line.startsWith("//")) {
                this.finalizeMatrix();
                this.inMatrix = false;
            } else if (line.startsWith("H ")) {
                this.newMatrix(line);
            } else if (line.startsWith("D ")) {
                this.currentMatrix.setDescription(line.substring(2));
            } else if (line.startsWith("M ")) {
                this.initMatrix(line);
                this.inMatrix = true;
            } else if (line.startsWith("  ") && this.inMatrix) {
                this.processScores(line);
            }
            line = buf.readLine();
        }
    }

    private void processScores(String line) {
        String[] values = line.trim().split(" +");
        ++this.currentRowPos;
        for (int i = 0; i < values.length; ++i) {
            if (values[i].endsWith(".")) {
                values[i] = values[i] + "0";
            }
            if (values[i].equals("-")) {
                values[i] = "0";
            }
            if (this.scale == -1) {
                this.scale = this.determineScale(values[0]);
            }
            Float score = Float.valueOf(Float.parseFloat(values[i]));
            score = Float.valueOf((float)this.scale * score.floatValue());
            Short s = (short)Math.round(score.floatValue());
            this.matrix[this.currentRowPos][i] = s;
            if (values.length < this.cols.size() || this.symmetricMatrix) {
                this.matrix[i][this.currentRowPos] = s;
                this.symmetricMatrix = true;
            }
            if (score.floatValue() > (float)this.max) {
                this.max = s;
            }
            if (!(score.floatValue() < (float)this.min)) continue;
            this.min = s;
        }
    }

    private int determineScale(String value) {
        String[] spl = value.split("\\.");
        if (spl.length <= 1) {
            return 1;
        }
        String digits = spl[1];
        return (int)Math.round(Math.pow(10.0, digits.length()));
    }

    private void initMatrix(String line) {
        AminoAcidCompound aa;
        char c;
        int i;
        String[] spl = line.split(" ");
        this.currentRows = spl[3].substring(0, spl[3].length() - 1);
        this.currentCols = spl[6];
        this.currentRowPos = -1;
        int nrRows = this.currentRows.length();
        int nrCols = this.currentCols.length();
        this.matrix = new short[nrRows][nrCols];
        this.rows = new ArrayList<AminoAcidCompound>();
        this.cols = new ArrayList<AminoAcidCompound>();
        AminoAcidCompoundSet compoundSet = AminoAcidCompoundSet.getAminoAcidCompoundSet();
        for (i = 0; i < this.currentRows.length(); ++i) {
            c = this.currentRows.charAt(i);
            aa = compoundSet.getCompoundForString(c + "");
            this.rows.add(aa);
        }
        for (i = 0; i < this.currentCols.length(); ++i) {
            c = this.currentRows.charAt(i);
            aa = compoundSet.getCompoundForString(c + "");
            this.cols.add(aa);
        }
        this.currentMatrix.setScale(this.scale);
    }

    private void newMatrix(String line) {
        this.symmetricMatrix = false;
        this.scale = -1;
        this.currentMatrix = new ScaledSubstitutionMatrix();
        this.currentMatrix.setName(line.substring(2));
    }

    private SubstitutionMatrix<AminoAcidCompound> finalizeMatrix() {
        this.currentMatrix.setMatrix(this.matrix);
        this.currentMatrix.setMax(this.max);
        this.currentMatrix.setMin(this.min);
        this.currentMatrix.setCols(this.cols);
        this.currentMatrix.setRows(this.rows);
        this.currentMatrix.setScale(this.scale);
        this.matrices.put(this.currentMatrix.getName(), this.currentMatrix);
        return this.currentMatrix;
    }

    public Map<String, SubstitutionMatrix<AminoAcidCompound>> getMatrices() {
        return this.matrices;
    }
}

