/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.search.io;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.biojava.nbio.core.search.io.Result;
import org.biojava.nbio.core.search.io.ResultFactory;

public class SearchIO
implements Iterable<Result> {
    private static HashMap<String, ResultFactory> extensionFactoryAssociation;
    private final ResultFactory factory;
    private final File file;
    private double evalueThreshold = Double.MAX_VALUE;
    private List<Result> results;
    private final String NOT_SUPPORTED_FILE_EXCEPTION = "This extension is not associated with any parser. You can try to specify a ResultFactory object.";

    public SearchIO(File f) throws IOException, ParseException {
        this.factory = this.guessFactory(f);
        this.file = f;
        if (this.file.exists()) {
            this.readResults();
        }
    }

    public SearchIO(File f, ResultFactory factory) throws IOException, ParseException {
        this.file = f;
        this.factory = factory;
        if (this.file.exists()) {
            this.readResults();
        }
    }

    public SearchIO(File f, ResultFactory factory, double maxEvalue) throws IOException, ParseException {
        this.file = f;
        this.factory = factory;
        this.evalueThreshold = maxEvalue;
        if (this.file.exists()) {
            this.readResults();
        }
    }

    private void readResults() throws IOException, ParseException {
        this.factory.setFile(this.file);
        this.results = this.factory.createObjects(this.evalueThreshold);
    }

    public void writeResults() throws IOException, ParseException {
        this.factory.setFile(this.file);
        this.factory.createObjects(this.evalueThreshold);
    }

    private ResultFactory guessFactory(File f) {
        int extensionPos;
        String filename;
        String extension;
        if (extensionFactoryAssociation == null) {
            extensionFactoryAssociation = new HashMap();
            ServiceLoader<ResultFactory> impl = ServiceLoader.load(ResultFactory.class);
            for (ResultFactory loadedImpl : impl) {
                List<String> fileExtensions = loadedImpl.getFileExtensions();
                for (String ext : fileExtensions) {
                    extensionFactoryAssociation.put(ext, loadedImpl);
                }
            }
        }
        if (extensionFactoryAssociation.get(extension = (filename = f.getAbsolutePath()).substring((extensionPos = filename.lastIndexOf(".")) + 1)) == null) {
            throw new UnsupportedOperationException("This extension is not associated with any parser. You can try to specify a ResultFactory object.\nExtension:" + extension);
        }
        return extensionFactoryAssociation.get(extension);
    }

    public double getEvalueThreshold() {
        return this.evalueThreshold;
    }

    @Override
    public Iterator<Result> iterator() {
        return new Iterator<Result>(){
            int currentResult = 0;

            @Override
            public boolean hasNext() {
                return this.currentResult < SearchIO.this.results.size();
            }

            @Override
            public Result next() {
                return (Result)SearchIO.this.results.get(this.currentResult++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The remove operation is not supported by this iterator");
            }
        };
    }
}

