/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.location;

import java.util.Arrays;
import java.util.List;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.location.SimpleLocation;
import org.biojava.nbio.core.sequence.location.SimplePoint;
import org.biojava.nbio.core.sequence.location.template.AbstractLocation;
import org.biojava.nbio.core.sequence.location.template.Location;
import org.biojava.nbio.core.sequence.location.template.Point;

public class InsdcLocations {

    public static class OneOfLocation
    extends AbstractLocation {
        public OneOfLocation(Location ... locations) {
            this(Arrays.asList(locations));
        }

        public OneOfLocation(List<Location> locations) {
            if (locations.isEmpty()) {
                throw new IllegalArgumentException("Need locations to build a OneOfLocation");
            }
            Location l = locations.get(0);
            this.setStart(l.getStart());
            this.setEnd(l.getEnd());
            this.setStrand(l.getStrand());
            this.setBetweenCompounds(l.isBetweenCompounds());
            this.setCircular(l.isCircular());
            this.setSubLocations(locations);
        }
    }

    public static class GroupLocation
    extends SimpleLocation {
        public GroupLocation(List<Location> subLocations) {
            super(Location.Tools.getMin(subLocations).getStart(), Location.Tools.getMax(subLocations).getEnd());
            this.setStrand(Strand.UNDEFINED);
            this.setSubLocations(subLocations);
            this.assertLocation();
        }

        public GroupLocation(Location ... subLocations) {
            this(Arrays.asList(subLocations));
        }

        public GroupLocation(boolean isCircular, Location ... subLocations) {
            this(Arrays.asList(subLocations));
            this.setCircular(isCircular);
        }

        public GroupLocation(Point start, Point end, Strand strand, boolean circular, Location ... subLocations) {
            super(start, end, strand, circular, subLocations);
        }

        public GroupLocation(Point start, Point end, Strand strand, Location ... subLocations) {
            this(start, end, strand, false, subLocations);
        }

        public GroupLocation(int start, int end, Strand strand, Location ... subLocations) {
            this((Point)new SimplePoint(start), (Point)new SimplePoint(end), strand, false, subLocations);
        }

        public GroupLocation(Point start, Point end, Strand strand, boolean circular, List<Location> subLocations) {
            super(start, end, strand, circular, subLocations);
        }

        public GroupLocation(Point start, Point end, Strand strand, List<Location> subLocations) {
            this(start, end, strand, false, subLocations);
        }

        public GroupLocation(int start, int end, Strand strand, List<Location> subLocations) {
            this((Point)new SimplePoint(start), (Point)new SimplePoint(end), strand, false, subLocations);
        }
    }

    public static class OrderLocation
    extends SimpleLocation {
        public OrderLocation(List<Location> subLocations) {
            super(Location.Tools.getMin(subLocations).getStart(), Location.Tools.getMax(subLocations).getEnd());
            this.setStrand(Strand.UNDEFINED);
            this.setSubLocations(subLocations);
            this.assertLocation();
        }

        public OrderLocation(Location ... subLocations) {
            this(Arrays.asList(subLocations));
        }

        public OrderLocation(Point start, Point end, Strand strand, boolean circular, Location ... subLocations) {
            super(start, end, strand, circular, subLocations);
        }

        public OrderLocation(Point start, Point end, Strand strand, Location ... subLocations) {
            this(start, end, strand, false, subLocations);
        }

        public OrderLocation(int start, int end, Strand strand, Location ... subLocations) {
            this((Point)new SimplePoint(start), (Point)new SimplePoint(end), strand, false, subLocations);
        }

        public OrderLocation(Point start, Point end, Strand strand, boolean circular, List<Location> subLocations) {
            super(start, end, strand, circular, subLocations);
        }

        public OrderLocation(Point start, Point end, Strand strand, List<Location> subLocations) {
            this(start, end, strand, false, subLocations);
        }

        public OrderLocation(int start, int end, Strand strand, List<Location> subLocations) {
            this((Point)new SimplePoint(start), (Point)new SimplePoint(end), strand, false, subLocations);
        }
    }

    public static class BondLocation
    extends AbstractLocation {
        public BondLocation(Location ... subLocations) {
            this(Arrays.asList(subLocations));
        }

        public BondLocation(List<Location> subLocations) {
            Location min = Location.Tools.getMin(subLocations);
            Location max = Location.Tools.getMax(subLocations);
            this.setStart(min.getStart());
            this.setEnd(max.getEnd());
            this.setStrand(Strand.UNDEFINED);
            this.setSubLocations(subLocations);
            this.assertLocation();
        }

        @Override
        protected final void assertLocation() {
            for (Location l : this) {
                Point end;
                Point start = l.getStart();
                if (start.equals(end = l.getEnd())) continue;
                throw new IllegalStateException("The start " + start + " is not equal to the end " + end + ". bond locations must be a single compound long");
            }
        }
    }
}

