/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.io.OutputStream;
import java.util.Collection;
import org.biojava.nbio.core.sequence.ExonSequence;
import org.biojava.nbio.core.sequence.GeneSequence;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.io.template.FastaHeaderFormatInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastaGeneWriter {
    private static final Logger logger = LoggerFactory.getLogger(FastaGeneWriter.class);
    boolean showExonUppercase = false;
    OutputStream os;
    Collection<GeneSequence> sequences;
    FastaHeaderFormatInterface<GeneSequence, NucleotideCompound> headerFormat;
    private int lineLength = 60;

    public FastaGeneWriter(OutputStream os, Collection<GeneSequence> sequences, FastaHeaderFormatInterface<GeneSequence, NucleotideCompound> headerFormat, boolean showExonUppercase) {
        this(os, sequences, headerFormat, showExonUppercase, 60);
    }

    public FastaGeneWriter(OutputStream os, Collection<GeneSequence> sequences, FastaHeaderFormatInterface<GeneSequence, NucleotideCompound> headerFormat, boolean showExonUppercase, int lineLength) {
        this.os = os;
        this.sequences = sequences;
        this.headerFormat = headerFormat;
        this.lineLength = lineLength;
        this.showExonUppercase = showExonUppercase;
    }

    public void process() throws Exception {
        byte[] lineSep = System.getProperty("line.separator").getBytes();
        for (GeneSequence sequence : this.sequences) {
            String header = this.headerFormat.getHeader(sequence);
            this.os.write(62);
            this.os.write(header.getBytes());
            this.os.write(lineSep);
            int compoundCount = 0;
            String seq = "";
            seq = sequence.getSequence5PrimeTo3Prime().getSequenceAsString();
            if (this.showExonUppercase) {
                StringBuilder sb = new StringBuilder(seq.toLowerCase());
                int geneBioBegin = sequence.getBioBegin();
                int geneBioEnd = sequence.getBioEnd();
                for (ExonSequence exonSequence : sequence.getExonSequences()) {
                    int featureBioBegin = 0;
                    int featureBioEnd = 0;
                    if (sequence.getStrand() != Strand.NEGATIVE) {
                        featureBioBegin = exonSequence.getBioBegin() - geneBioBegin;
                        featureBioEnd = exonSequence.getBioEnd() - geneBioBegin;
                    } else {
                        featureBioBegin = geneBioEnd - exonSequence.getBioEnd();
                        featureBioEnd = geneBioEnd - exonSequence.getBioBegin();
                    }
                    if (featureBioBegin < 0 || featureBioEnd < 0 || featureBioEnd > sb.length() || featureBioBegin > sb.length()) {
                        logger.warn("Bad Feature, Accession: {}, Sequence Strand: {}, Gene Begin: {}, Gene End: {}, Exon Begin: {}, Exon End: {}", new Object[]{sequence.getAccession().toString(), sequence.getStrand(), geneBioBegin, geneBioEnd, exonSequence.getBioBegin(), exonSequence.getBioEnd()});
                        continue;
                    }
                    for (int i = featureBioBegin; i <= featureBioEnd; ++i) {
                        char ch = sb.charAt(i);
                        String temp = String.valueOf(ch);
                        ch = temp.toUpperCase().charAt(0);
                        sb.setCharAt(i, ch);
                    }
                }
                seq = sb.toString();
            }
            for (int i = 0; i < seq.length(); ++i) {
                this.os.write(seq.charAt(i));
                if (++compoundCount != this.lineLength) continue;
                this.os.write(lineSep);
                compoundCount = 0;
            }
            if (sequence.getLength() % this.getLineLength() == 0) continue;
            this.os.write(lineSep);
        }
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }
}

