/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.storage.SequenceAsStringHelper;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.ProxySequenceReader;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.core.sequence.template.SequenceMixin;
import org.biojava.nbio.core.sequence.template.SequenceProxyView;
import org.biojava.nbio.core.sequence.template.SequenceView;
import org.biojava.nbio.core.util.Equals;

public class StringProxySequenceReader<C extends Compound>
implements ProxySequenceReader<C> {
    private String sequence;
    private CompoundSet<C> compoundSet;
    private List<C> parsedCompounds = new ArrayList<C>();

    public StringProxySequenceReader() {
    }

    public StringProxySequenceReader(String sequence, CompoundSet<C> compoundSet) throws CompoundNotFoundException {
        this.sequence = sequence;
        this.setCompoundSet(compoundSet);
        this.setContents(sequence);
    }

    @Override
    public void setCompoundSet(CompoundSet<C> compoundSet) {
        this.compoundSet = compoundSet;
    }

    @Override
    public void setContents(String sequence) throws CompoundNotFoundException {
        String compoundStr;
        this.sequence = sequence;
        this.parsedCompounds.clear();
        for (int i = 0; i < sequence.length(); i += compoundStr.length()) {
            compoundStr = null;
            Object compound = null;
            for (int compoundStrLength = 1; compound == null && compoundStrLength <= this.compoundSet.getMaxSingleCompoundStringLength(); ++compoundStrLength) {
                compoundStr = sequence.substring(i, i + compoundStrLength);
                compound = this.compoundSet.getCompoundForString(compoundStr);
            }
            if (compound == null) {
                throw new CompoundNotFoundException("Compound " + compoundStr + " not found");
            }
            this.parsedCompounds.add(compound);
        }
    }

    public void setContents(String sequence, List features) throws CompoundNotFoundException {
        this.setContents(sequence);
    }

    @Override
    public int getLength() {
        return this.parsedCompounds.size();
    }

    @Override
    public C getCompoundAt(int position) {
        return (C)((Compound)this.parsedCompounds.get(position - 1));
    }

    @Override
    public int getIndexOf(C compound) {
        return this.parsedCompounds.indexOf(compound) + 1;
    }

    @Override
    public int getLastIndexOf(C compound) {
        return this.parsedCompounds.lastIndexOf(compound) + 1;
    }

    public String toString() {
        return this.getSequenceAsString();
    }

    @Override
    public String getSequenceAsString() {
        return this.sequence;
    }

    @Override
    public List<C> getAsList() {
        return this.parsedCompounds;
    }

    public String getSequenceAsString(Integer bioBegin, Integer bioEnd, Strand strand) {
        SequenceAsStringHelper<C> sequenceAsStringHelper = new SequenceAsStringHelper<C>();
        return sequenceAsStringHelper.getSequenceAsString(this.parsedCompounds, this.compoundSet, bioBegin, bioEnd, strand);
    }

    @Override
    public SequenceView<C> getSubSequence(Integer bioBegin, Integer bioEnd) {
        return new SequenceProxyView(this, bioBegin, bioEnd);
    }

    @Override
    public Iterator<C> iterator() {
        return this.parsedCompounds.iterator();
    }

    @Override
    public CompoundSet<C> getCompoundSet() {
        return this.compoundSet;
    }

    @Override
    public AccessionID getAccession() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int countCompounds(C ... compounds) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SequenceView<C> getInverse() {
        return SequenceMixin.inverse(this);
    }

    public boolean equals(Object o) {
        if (!Equals.classEqual(this, o)) {
            return false;
        }
        Sequence other = (Sequence)o;
        if (other.getCompoundSet() != this.getCompoundSet()) {
            return false;
        }
        List<C> rawCompounds = this.getAsList();
        List otherCompounds = other.getAsList();
        if (rawCompounds.size() != otherCompounds.size()) {
            return false;
        }
        for (int i = 0; i < rawCompounds.size(); ++i) {
            Compound otherCompound;
            Compound myCompound = (Compound)rawCompounds.get(i);
            if (myCompound.equalsIgnoreCase(otherCompound = (Compound)otherCompounds.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        String s = this.getSequenceAsString();
        return s.hashCode();
    }
}

