/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.util;

import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.template.Sequence;

public class SequenceTools {
    protected static final String NUCLEOTIDE_LETTERS = "GCTAUXN";

    public static String permuteCyclic(String string, int n) {
        String toMutate = string + string;
        if ((n %= string.length()) < 0) {
            n = string.length() + n;
        }
        return toMutate.substring(n, n + string.length());
    }

    public static <T> void permuteCyclic(T[] array, T[] fill, int n) {
        if (array.length != fill.length) {
            throw new IllegalArgumentException("Lengths do not match");
        }
        if (n < 0) {
            n = array.length + n;
        }
        while (n > array.length) {
            n -= array.length;
        }
        for (int i = 0; i < array.length; ++i) {
            fill[i] = i + n < array.length ? array[i + n] : array[i - array.length + n];
        }
    }

    public static int percentNucleotideSequence(String sequence) {
        if (sequence == null || sequence.length() == 0) {
            return 0;
        }
        int l = sequence.length();
        int n = 0;
        for (int i = 0; i < l; ++i) {
            if (NUCLEOTIDE_LETTERS.indexOf(sequence.charAt(i)) < 0) continue;
            ++n;
        }
        return 100 * n / l;
    }

    public static boolean isNucleotideSequence(String sequence) {
        if (sequence == null || sequence.length() == 0) {
            return false;
        }
        int l = sequence.length();
        for (int i = 0; i < l; ++i) {
            if (NUCLEOTIDE_LETTERS.indexOf(sequence.charAt(i)) >= 0) continue;
            return false;
        }
        return true;
    }

    public Sequence<?> getSequenceFromString(String sequence) throws CompoundNotFoundException {
        if (SequenceTools.isNucleotideSequence(sequence)) {
            return new DNASequence(sequence);
        }
        return new ProteinSequence(sequence);
    }

    public static boolean equalLengthSequences(ProteinSequence[] sequences) {
        for (int i = 0; i < sequences.length - 1; ++i) {
            if (sequences[i] == null) continue;
            for (int j = i + 1; j < sequences.length; ++j) {
                if (sequences[j] == null || sequences[i].getLength() != sequences[j].getLength()) continue;
                return true;
            }
        }
        return false;
    }
}

