/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.CDSComparator;
import org.biojava.nbio.core.sequence.CDSSequence;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.GeneSequence;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.RNASequence;
import org.biojava.nbio.core.sequence.StartCodonSequence;
import org.biojava.nbio.core.sequence.StopCodonSequence;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.compound.DNACompoundSet;
import org.biojava.nbio.core.sequence.transcription.TranscriptionEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranscriptSequence
extends DNASequence {
    private static final Logger logger = LoggerFactory.getLogger(TranscriptSequence.class);
    private final List<CDSSequence> cdsSequenceList = new ArrayList<CDSSequence>();
    private final Map<String, CDSSequence> cdsSequenceHashMap = new LinkedHashMap<String, CDSSequence>();
    private StartCodonSequence startCodonSequence = null;
    private StopCodonSequence stopCodonSequence = null;
    private GeneSequence parentGeneSequence = null;

    public TranscriptSequence(GeneSequence parentDNASequence, int begin, int end) {
        this.setCompoundSet(DNACompoundSet.getDNACompoundSet());
        try {
            this.initSequenceStorage(parentDNASequence.getSequenceAsString());
        }
        catch (CompoundNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        this.setParentSequence(parentDNASequence);
        this.parentGeneSequence = parentDNASequence;
        this.setBioBegin(begin);
        this.setBioEnd(end);
    }

    public TranscriptSequence(GeneSequence parentDNASequence, AccessionID accessionID, int begin, int end) {
        this(parentDNASequence, begin, end);
        this.setAccession(accessionID);
    }

    @Override
    public int getLength() {
        return Math.abs(this.getBioEnd() - this.getBioBegin()) + 1;
    }

    public Strand getStrand() {
        return this.parentGeneSequence.getStrand();
    }

    public CDSSequence removeCDS(String accession) {
        for (CDSSequence cdsSequence : this.cdsSequenceList) {
            if (!cdsSequence.getAccession().getID().equals(accession)) continue;
            this.cdsSequenceList.remove(cdsSequence);
            this.cdsSequenceHashMap.remove(accession);
            return cdsSequence;
        }
        return null;
    }

    public Map<String, CDSSequence> getCDSSequences() {
        return this.cdsSequenceHashMap;
    }

    public CDSSequence addCDS(AccessionID accession, int begin, int end, int phase) throws Exception {
        if (this.cdsSequenceHashMap.containsKey(accession.getID())) {
            throw new Exception("Duplicate accession id " + accession.getID());
        }
        CDSSequence cdsSequence = new CDSSequence(this, begin, end, phase);
        cdsSequence.setAccession(accession);
        this.cdsSequenceList.add(cdsSequence);
        Collections.sort(this.cdsSequenceList, new CDSComparator());
        this.cdsSequenceHashMap.put(accession.getID(), cdsSequence);
        return cdsSequence;
    }

    public List<ProteinSequence> getProteinCDSSequences() {
        ArrayList<ProteinSequence> proteinSequenceList = new ArrayList<ProteinSequence>();
        for (int i = 0; i < this.cdsSequenceList.size(); ++i) {
            String nextCodingSequence;
            CDSSequence nextCDSSequence;
            CDSSequence cdsSequence = this.cdsSequenceList.get(i);
            Object codingSequence = cdsSequence.getCodingSequence();
            if (this.getStrand() == Strand.NEGATIVE) {
                if (cdsSequence.phase == 1) {
                    codingSequence = ((String)codingSequence).substring(1, ((String)codingSequence).length());
                } else if (cdsSequence.phase == 2) {
                    codingSequence = ((String)codingSequence).substring(2, ((String)codingSequence).length());
                }
                if (i < this.cdsSequenceList.size() - 1) {
                    nextCDSSequence = this.cdsSequenceList.get(i + 1);
                    if (nextCDSSequence.phase == 1) {
                        nextCodingSequence = nextCDSSequence.getCodingSequence();
                        codingSequence = (String)codingSequence + nextCodingSequence.substring(0, 1);
                    } else if (nextCDSSequence.phase == 2) {
                        nextCodingSequence = nextCDSSequence.getCodingSequence();
                        codingSequence = (String)codingSequence + nextCodingSequence.substring(0, 2);
                    }
                }
            } else {
                if (cdsSequence.phase == 1) {
                    codingSequence = ((String)codingSequence).substring(1, ((String)codingSequence).length());
                } else if (cdsSequence.phase == 2) {
                    codingSequence = ((String)codingSequence).substring(2, ((String)codingSequence).length());
                }
                if (i < this.cdsSequenceList.size() - 1) {
                    nextCDSSequence = this.cdsSequenceList.get(i + 1);
                    if (nextCDSSequence.phase == 1) {
                        nextCodingSequence = nextCDSSequence.getCodingSequence();
                        codingSequence = (String)codingSequence + nextCodingSequence.substring(0, 1);
                    } else if (nextCDSSequence.phase == 2) {
                        nextCodingSequence = nextCDSSequence.getCodingSequence();
                        codingSequence = (String)codingSequence + nextCodingSequence.substring(0, 2);
                    }
                }
            }
            DNASequence dnaCodingSequence = null;
            try {
                dnaCodingSequence = new DNASequence(((String)codingSequence).toUpperCase());
            }
            catch (CompoundNotFoundException e) {
                logger.error("Could not create DNA coding sequence, {}. This is most likely a bug.", (Object)e.getMessage());
            }
            RNASequence rnaCodingSequence = dnaCodingSequence.getRNASequence(TranscriptionEngine.getDefault());
            ProteinSequence proteinSequence = rnaCodingSequence.getProteinSequence(TranscriptionEngine.getDefault());
            proteinSequence.setAccession(new AccessionID(cdsSequence.getAccession().getID()));
            proteinSequence.setParentDNASequence(cdsSequence, 1, cdsSequence.getLength());
            proteinSequenceList.add(proteinSequence);
        }
        return proteinSequenceList;
    }

    public DNASequence getDNACodingSequence() {
        StringBuilder sb = new StringBuilder();
        for (CDSSequence cdsSequence : this.cdsSequenceList) {
            sb.append(cdsSequence.getCodingSequence());
        }
        DNASequence dnaSequence = null;
        try {
            dnaSequence = new DNASequence(sb.toString().toUpperCase());
        }
        catch (CompoundNotFoundException e) {
            logger.error("Could not create DNA coding sequence, {}. This is most likely a bug.", (Object)e.getMessage());
        }
        dnaSequence.setAccession(new AccessionID(this.getAccession().getID()));
        return dnaSequence;
    }

    public ProteinSequence getProteinSequence() {
        return this.getProteinSequence(TranscriptionEngine.getDefault());
    }

    public ProteinSequence getProteinSequence(TranscriptionEngine engine) {
        DNASequence dnaCodingSequence = this.getDNACodingSequence();
        RNASequence rnaCodingSequence = dnaCodingSequence.getRNASequence(engine);
        ProteinSequence proteinSequence = rnaCodingSequence.getProteinSequence(engine);
        proteinSequence.setAccession(new AccessionID(this.getAccession().getID()));
        return proteinSequence;
    }

    public StartCodonSequence getStartCodonSequence() {
        return this.startCodonSequence;
    }

    public void addStartCodonSequence(AccessionID accession, int begin, int end) {
        this.startCodonSequence = new StartCodonSequence(this, begin, end);
        this.startCodonSequence.setAccession(accession);
    }

    public StopCodonSequence getStopCodonSequence() {
        return this.stopCodonSequence;
    }

    public void addStopCodonSequence(AccessionID accession, int begin, int end) {
        this.stopCodonSequence = new StopCodonSequence(this, begin, end);
        this.stopCodonSequence.setAccession(accession);
    }
}

