/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.util.ArrayList;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.DataSource;
import org.biojava.nbio.core.sequence.io.template.SequenceHeaderParserInterface;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.Compound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericFastaHeaderParser<S extends AbstractSequence<C>, C extends Compound>
implements SequenceHeaderParserInterface<S, C> {
    private static final Logger logger = LoggerFactory.getLogger(GenericFastaHeaderParser.class);

    private String[] getHeaderValues(String header) {
        String[] data = new String[]{};
        ArrayList<String> values = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        if (!header.startsWith("PDB:")) {
            for (int i = 0; i < header.length(); ++i) {
                if (header.charAt(i) == '|') {
                    values.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                if (i == header.length() - 1) {
                    sb.append(header.charAt(i));
                    values.add(sb.toString());
                    continue;
                }
                sb.append(header.charAt(i));
            }
            data = new String[values.size()];
            values.toArray(data);
        } else {
            data = header.split(" ");
        }
        return data;
    }

    @Override
    public void parseHeader(String header, S sequence) {
        ((AbstractSequence)sequence).setOriginalHeader(header);
        String[] data = this.getHeaderValues(header);
        if (data.length == 1) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[0]));
        } else if ("sp".equalsIgnoreCase(data[0]) || "tr".equalsIgnoreCase(data[0])) {
            if ("sp".equalsIgnoreCase(data[0])) {
                ((AbstractSequence)sequence).setAnnotationType(AbstractSequence.AnnotationType.CURATED);
            } else {
                ((AbstractSequence)sequence).setAnnotationType(AbstractSequence.AnnotationType.PREDICTED);
            }
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[1], DataSource.UNIPROT));
            if (data.length > 2) {
                ((AbstractSequence)sequence).setDescription(data[2]);
            }
        } else if ("gi".equalsIgnoreCase(data[0])) {
            DataSource giSource = DataSource.UNKNOWN;
            if (data.length >= 3) {
                if ("gb".equalsIgnoreCase(data[2])) {
                    giSource = DataSource.GENBANK;
                } else if ("emb".equalsIgnoreCase(data[2])) {
                    giSource = DataSource.ENA;
                } else if ("dbj".equalsIgnoreCase(data[2])) {
                    giSource = DataSource.DDBJ;
                }
                ((AbstractSequence)sequence).setAccession(new AccessionID(data[3], giSource));
            } else {
                ((AbstractSequence)sequence).setAccession(new AccessionID(header, giSource));
            }
        } else if ("pir".equalsIgnoreCase(data[0])) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[2], DataSource.NBRF));
        } else if ("prf".equalsIgnoreCase(data[0])) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[2], DataSource.PRF));
        } else if ("pdb".equalsIgnoreCase(data[0])) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[1] + ":" + data[2], DataSource.PDB1));
        } else if (data[0].startsWith("PDB")) {
            String[] pdbe = data[0].split(" ");
            String[] pdbaccession = pdbe[0].split(":");
            ((AbstractSequence)sequence).setAccession(new AccessionID(pdbaccession[1], DataSource.PDBe));
        } else if (data[0].indexOf(":") != -1 && data.length > 1 && "PDBID".equals(data[1])) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[0], DataSource.PDB2));
        } else if ("pat".equalsIgnoreCase(data[0])) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[2], DataSource.PATENTS));
        } else if ("bbs".equalsIgnoreCase(data[0])) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[1], DataSource.GENINFO));
        } else if ("gnl".equalsIgnoreCase(data[0])) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[2], DataSource.GENERAL));
        } else if ("ref".equalsIgnoreCase(data[0])) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[1], DataSource.NCBI));
        } else if ("lcl".equalsIgnoreCase(data[0])) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[1], DataSource.LOCAL));
        } else {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[0]));
        }
    }
}

