/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.compound.DNACompoundSet;
import org.biojava.nbio.core.sequence.compound.RNACompoundSet;
import org.biojava.nbio.core.sequence.features.FeatureInterface;
import org.biojava.nbio.core.sequence.io.GenericInsdcHeaderFormat;
import org.biojava.nbio.core.sequence.io.template.GenbankHeaderFormatInterface;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.util.StringManipulationHelper;

public class GenericGenbankHeaderFormat<S extends AbstractSequence<C>, C extends Compound>
extends GenericInsdcHeaderFormat<S, C>
implements GenbankHeaderFormatInterface<S, C> {
    private static final int HEADER_WIDTH = 12;
    private static final String lineSep = System.lineSeparator();
    private String seqType = null;
    private boolean useOriginalHeader = false;

    public GenericGenbankHeaderFormat() {
        this.seqType = null;
    }

    public GenericGenbankHeaderFormat(String seqType) {
        this.seqType = seqType;
    }

    public GenericGenbankHeaderFormat(boolean useOriginalHeader) {
        this.useOriginalHeader = useOriginalHeader;
    }

    private String _write_single_line(String tag, String text) {
        assert (tag.length() < 12);
        return StringManipulationHelper.padRight(tag, 12) + text.replace('\n', ' ') + lineSep;
    }

    private String _write_multi_line(String tag, String text) {
        if (text == null) {
            text = "";
        }
        int max_len = 68;
        List<String> lines = this._split_multi_line(text, max_len);
        Object output = this._write_single_line(tag, lines.get(0));
        for (int i = 1; i < lines.size(); ++i) {
            output = (String)output + this._write_single_line("", lines.get(i));
        }
        return output;
    }

    private String _get_date(S sequence) {
        Date sysdate = Calendar.getInstance().getTime();
        String default_date = new SimpleDateFormat("dd-MMM-yyyy").format(sysdate);
        return default_date;
    }

    private String _get_data_division(S sequence) {
        return "UNK";
    }

    private String _write_the_first_line(S sequence) {
        String locus;
        try {
            locus = ((AbstractSequence)sequence).getAccession().getID();
        }
        catch (Exception e) {
            locus = "";
        }
        if (locus.length() > 16) {
            throw new RuntimeException("Locus identifier " + locus + " is too long");
        }
        String units = "";
        String mol_type = "";
        if (((AbstractSequence)sequence).getCompoundSet() instanceof DNACompoundSet) {
            units = "bp";
            mol_type = "DNA";
        } else if (((AbstractSequence)sequence).getCompoundSet() instanceof RNACompoundSet) {
            units = "bp";
            mol_type = "RNA";
        } else if (((AbstractSequence)sequence).getCompoundSet() instanceof AminoAcidCompoundSet) {
            units = "aa";
            mol_type = "";
        } else {
            throw new RuntimeException("Need a DNACompoundSet, RNACompoundSet, or an AminoAcidCompoundSet");
        }
        String division = this._get_data_division(sequence);
        if (this.seqType != null) {
            division = this.seqType;
        }
        assert (units.length() == 2);
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("LOCUS       %s %s %s    %s           %s %s" + lineSep, StringManipulationHelper.padRight(locus, 16), StringManipulationHelper.padLeft(Integer.toString(((AbstractSequence)sequence).getLength()), 11), units, StringManipulationHelper.padRight(mol_type, 6), division, this._get_date(sequence));
        String output = formatter.toString();
        formatter.close();
        return output;
    }

    private String _write_original_first_line(S sequence) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("LOCUS       %s" + lineSep, StringManipulationHelper.padRight(((AbstractSequence)sequence).getOriginalHeader(), 16));
        String output = formatter.toString();
        formatter.close();
        return output;
    }

    private String _write_comment(S sequence) {
        List<String> comments = ((AbstractSequence)sequence).getNotesList();
        Object output = this._write_multi_line("COMMENT", comments.remove(0));
        for (String comment : comments) {
            output = (String)output + this._write_multi_line("", comment);
        }
        return output;
    }

    @Override
    public String getHeader(S sequence) {
        Object acc_with_version;
        String accession;
        Object header = this.useOriginalHeader ? this._write_original_first_line(sequence) : this._write_the_first_line(sequence);
        AccessionID accessionIdObj = ((AbstractSequence)sequence).getAccession();
        try {
            accession = accessionIdObj.getID();
            acc_with_version = accessionIdObj.getIdentifier() != null ? ((AbstractSequence)sequence).getAccession().getID() + "." + ((AbstractSequence)sequence).getAccession().getVersion() + " GI:" + accessionIdObj.getIdentifier() : ((AbstractSequence)sequence).getAccession().getID() + "." + ((AbstractSequence)sequence).getAccession().getVersion();
        }
        catch (Exception e) {
            acc_with_version = "";
            accession = "";
        }
        String description = ((AbstractSequence)sequence).getDescription();
        if ("<unknown description>".equals(description) || description == null) {
            description = ".";
        }
        header = (String)header + this._write_multi_line("DEFINITION", description);
        header = (String)header + this._write_multi_line("ACCESSION", accession);
        header = (String)header + this._write_multi_line("VERSION", (String)acc_with_version);
        header = (String)header + this._write_multi_line("KEYWORDS", ".");
        header = (String)header + this._write_multi_line("SOURCE", ((AbstractSequence)sequence).getSource());
        if (!((AbstractSequence)sequence).getNotesList().isEmpty()) {
            header = (String)header + this._write_comment(sequence);
        }
        header = (String)header + "FEATURES             Location/Qualifiers" + lineSep;
        int rec_length = ((AbstractSequence)sequence).getLength();
        for (FeatureInterface feature : ((AbstractSequence)sequence).getFeatures()) {
            header = (String)header + this._write_feature(feature, rec_length);
        }
        return String.format((String)header, new Object[0]);
    }
}

