/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.protmod;

import java.util.Collections;
import java.util.List;
import org.biojava.nbio.protmod.Component;

public class ModificationLinkage {
    private final List<Component> components;
    private final int indexOfComponent1;
    private final int indexOfComponent2;
    private final List<String> pdbNameOfPotentialAtomsOnComponent1;
    private final List<String> pdbNameOfPotentialAtomsOnComponent2;
    private final String labelOfAtomOnComponent1;
    private final String labelOfAtomOnComponent2;

    public ModificationLinkage(List<Component> components, int indexOfComponent1, int indexOfComponent2) {
        this(components, indexOfComponent1, null, null, indexOfComponent2, null, null);
    }

    public ModificationLinkage(List<Component> components, int indexOfComponent1, String pdbNameOfAtomsOnComponent1, int indexOfComponent2, String pdbNameOfAtomsOnComponent2) {
        this(components, indexOfComponent1, Collections.singletonList(pdbNameOfAtomsOnComponent1), null, indexOfComponent2, Collections.singletonList(pdbNameOfAtomsOnComponent2), null);
    }

    public ModificationLinkage(List<Component> components, int indexOfComponent1, List<String> pdbNameOfPotentialAtomsOnComponent1, int indexOfComponent2, List<String> pdbNameOfPotentialAtomsOnComponent2) {
        this(components, indexOfComponent1, pdbNameOfPotentialAtomsOnComponent1, null, indexOfComponent2, pdbNameOfPotentialAtomsOnComponent2, null);
    }

    public ModificationLinkage(List<Component> components, int indexOfComponent1, List<String> pdbNameOfPotentialAtomsOnComponent1, String labelOfAtomOnComponent1, int indexOfComponent2, List<String> pdbNameOfPotentialAtomsOnComponent2, String labelOfAtomOnComponent2) {
        if (components == null) {
            throw new IllegalArgumentException("Null components");
        }
        if (indexOfComponent1 < 0) {
            throw new IllegalArgumentException("indexOfComponent1 has to be >= 0");
        }
        if (indexOfComponent1 >= components.size()) {
            throw new IllegalArgumentException("indexOfComponent1 has to be <= components.size()");
        }
        if (indexOfComponent2 < 0) {
            throw new IllegalArgumentException("indexOfComponent2 has to be >= 0");
        }
        if (indexOfComponent2 >= components.size()) {
            throw new IllegalArgumentException("indexOfComponent2 [" + indexOfComponent2 + "] has to be <= components.size() [" + components.size() + "]");
        }
        if (indexOfComponent1 == indexOfComponent2) {
            throw new IllegalArgumentException("No linkage is allowed for an identical component.");
        }
        this.components = components;
        this.indexOfComponent1 = indexOfComponent1;
        this.indexOfComponent2 = indexOfComponent2;
        this.pdbNameOfPotentialAtomsOnComponent1 = pdbNameOfPotentialAtomsOnComponent1;
        this.pdbNameOfPotentialAtomsOnComponent2 = pdbNameOfPotentialAtomsOnComponent2;
        this.labelOfAtomOnComponent1 = labelOfAtomOnComponent1;
        this.labelOfAtomOnComponent2 = labelOfAtomOnComponent2;
    }

    public int getIndexOfComponent1() {
        return this.indexOfComponent1;
    }

    public int getIndexOfComponent2() {
        return this.indexOfComponent2;
    }

    public Component getComponent1() {
        return this.components.get(this.indexOfComponent1);
    }

    public Component getComponent2() {
        return this.components.get(this.indexOfComponent2);
    }

    public List<String> getPDBNameOfPotentialAtomsOnComponent1() {
        return this.pdbNameOfPotentialAtomsOnComponent1;
    }

    public List<String> getPDBNameOfPotentialAtomsOnComponent2() {
        return this.pdbNameOfPotentialAtomsOnComponent2;
    }

    public String getLabelOfAtomOnComponent1() {
        return this.labelOfAtomOnComponent1;
    }

    public String getLabelOfAtomOnComponent2() {
        return this.labelOfAtomOnComponent2;
    }

    public String toString() {
        Component comp1 = this.getComponent1();
        Component comp2 = this.getComponent2();
        List<String> atom1 = this.getPDBNameOfPotentialAtomsOnComponent1();
        List<String> atom2 = this.getPDBNameOfPotentialAtomsOnComponent2();
        if (comp1 == null || comp2 == null) {
            return "ModificationLinkage: empty";
        }
        if (comp1.getPdbccIds() != null && comp2.getPdbccIds() != null) {
            return "ModificationLinkage: " + comp1.getPdbccIds().toString() + ":" + atom1 + "<=>" + comp2.getPdbccIds() + atom2;
        }
        return "ModificationLinkage :" + atom1 + "<=>" + atom2;
    }
}

