/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.gui.StructureAlignmentDisplay;
import org.biojava.nbio.structure.align.gui.jmol.MultipleAlignmentJmol;
import org.biojava.nbio.structure.align.gui.jmol.StructureAlignmentJmol;
import org.biojava.nbio.structure.align.util.RotationAxis;
import org.biojava.nbio.structure.symmetry.gui.SymmetryDisplay;
import org.biojava.nbio.structure.symmetry.gui.SymmetryGui;
import org.biojava.nbio.structure.symmetry.internal.CeSymmResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmetryListener
implements ActionListener {
    private MultipleAlignmentJmol jmol;
    private CeSymmResult symm;
    private static final Logger logger = LoggerFactory.getLogger(SymmetryListener.class);

    public SymmetryListener(MultipleAlignmentJmol jmol, CeSymmResult symm) {
        this.jmol = jmol;
        this.symm = symm;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("New Symmetry Analysis")) {
            SymmetryGui.getInstance();
        }
        if (this.symm == null) {
            logger.error("Currently not displaying a symmetry!");
        }
        try {
            if (cmd.equals("Repeats Superposition")) {
                MultipleAlignmentJmol j = SymmetryDisplay.displayRepeats(this.symm);
                String s = SymmetryDisplay.printSymmetryAxes(this.symm, false);
                j.evalString(s);
            } else if (cmd.equals("Multiple Structure Alignment")) {
                MultipleAlignmentJmol j = SymmetryDisplay.displayFull(this.symm);
                String s = SymmetryDisplay.printSymmetryAxes(this.symm);
                j.evalString(s);
            } else if (cmd.equals("Optimal Self Alignment")) {
                Atom[] cloned = StructureTools.cloneAtomArray((Atom[])this.symm.getAtoms());
                StructureAlignmentJmol jmol = StructureAlignmentDisplay.display(this.symm.getSelfAlignment(), this.symm.getAtoms(), cloned);
                RotationAxis axis = new RotationAxis(this.symm.getSelfAlignment());
                jmol.evalString(axis.getJmolScript(this.symm.getAtoms()));
                jmol.setTitle(SymmetryDisplay.getSymmTitle(this.symm));
            } else if (cmd.equals("Show Symmetry Group")) {
                String script = SymmetryDisplay.printSymmetryGroup(this.symm);
                this.jmol.evalString(script);
            } else if (cmd.equals("Show Symmetry Axes")) {
                String s = SymmetryDisplay.printSymmetryAxes(this.symm);
                this.jmol.evalString(s);
            }
        }
        catch (Exception e) {
            logger.error("Could not complete display option", (Throwable)e);
        }
    }
}

