/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.aligpanel;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.align.gui.aligpanel.AFPChainCoordManager;
import org.biojava.nbio.structure.align.gui.aligpanel.AligPanel;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.gui.events.AlignmentPositionListener;
import org.biojava.nbio.structure.gui.util.AlignedPosition;

public class AligPanelMouseMotionListener
implements MouseMotionListener,
MouseListener {
    AligPanel parent;
    List<AlignmentPositionListener> aligPosListeners;
    int prevPos;
    boolean isDragging;
    AlignedPosition selectionStart;
    AlignedPosition selectionEnd;
    boolean selectionLocked;

    public AligPanelMouseMotionListener(AligPanel parent) {
        this.parent = parent;
        this.aligPosListeners = new ArrayList<AlignmentPositionListener>();
        this.prevPos = -1;
        this.isDragging = false;
        this.selectionStart = null;
        this.selectionEnd = null;
        this.selectionLocked = false;
    }

    public void addAligPosListener(AlignmentPositionListener li) {
        this.aligPosListeners.add(li);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        AlignedPosition pos = this.getCurrentAlignedPosition(e);
        if (pos == null) {
            return;
        }
        int p = pos.getPos1();
        if (this.prevPos == p && this.isDragging) {
            return;
        }
        if (!this.isDragging) {
            this.isDragging = true;
            this.setSelectionLock(true);
        }
        if (this.selectionStart == null) {
            this.selectionStart = pos;
        }
        if (this.selectionEnd == null) {
            this.selectionEnd = pos;
        }
        if (p <= this.selectionStart.getPos1()) {
            this.selectionStart = pos;
        } else {
            this.selectionEnd = pos;
        }
        if (!this.keyPressed(e)) {
            this.triggerRangeSelected(this.selectionStart, this.selectionEnd);
        } else {
            this.triggerRangeSelected(this.selectionStart, this.selectionEnd);
        }
        this.prevPos = p;
    }

    private boolean keyPressed(MouseEvent e) {
        return e.isShiftDown() || e.isControlDown() || e.isAltDown();
    }

    private void triggerRangeSelected(AlignedPosition start, AlignedPosition end) {
        for (AlignmentPositionListener li : this.aligPosListeners) {
            li.rangeSelected(start, end);
        }
    }

    public void triggerSelectionLocked(boolean b) {
        this.selectionLocked = b;
        for (AlignmentPositionListener li : this.aligPosListeners) {
            if (b) {
                li.selectionLocked();
                continue;
            }
            li.selectionUnlocked();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.selectionLocked) {
            return;
        }
        AlignedPosition pos = this.getCurrentAlignedPosition(e);
        if (pos == null) {
            return;
        }
        this.triggerMouseOverPosition(pos);
    }

    private void triggerMouseOverPosition(AlignedPosition pos) {
        for (AlignmentPositionListener li : this.aligPosListeners) {
            li.mouseOverPosition(pos);
        }
    }

    private AlignedPosition getCurrentAlignedPosition(MouseEvent e) {
        AFPChainCoordManager coordManager = this.parent.getCoordManager();
        int aligSeq = coordManager.getAligSeq(e.getPoint());
        if (aligSeq == -1) {
            return null;
        }
        int seqPos = coordManager.getSeqPos(aligSeq, e.getPoint());
        if (seqPos < 0) {
            return null;
        }
        AFPChain afpChain = this.parent.getAFPChain();
        char[] aligs1 = afpChain.getAlnseq1();
        char[] aligs2 = afpChain.getAlnseq2();
        if (seqPos >= afpChain.getAlnLength()) {
            return null;
        }
        AlignedPosition pos = new AlignedPosition();
        pos.setPos1(seqPos);
        pos.setPos2(seqPos);
        if (aligs1[seqPos] != '-' && aligs2[seqPos] != '-') {
            pos.setEquivalent(1);
        }
        return pos;
    }

    public void destroy() {
        this.aligPosListeners.clear();
        this.parent = null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private void triggerToggleSelection(AlignedPosition pos) {
        for (AlignmentPositionListener li : this.aligPosListeners) {
            li.toggleSelection(pos);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.selectionStart = null;
        this.selectionEnd = null;
        if (!this.keyPressed(e)) {
            this.setSelectionLock(false);
            this.triggerSelectionLocked(false);
            AlignedPosition pos = this.getCurrentAlignedPosition(e);
            if (pos != null) {
                this.prevPos = pos.getPos1();
            }
        }
    }

    private void setSelectionLock(boolean flag) {
        this.selectionLocked = flag;
        this.triggerSelectionLocked(flag);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isDragging = false;
        if (this.keyPressed(e)) {
            boolean keepOn = false;
            if (!this.selectionLocked) {
                keepOn = true;
            }
            this.setSelectionLock(true);
            AlignedPosition pos = this.getCurrentAlignedPosition(e);
            if (pos == null) {
                return;
            }
            if (keepOn) {
                this.triggerMouseOverPosition(pos);
            } else {
                this.triggerToggleSelection(pos);
            }
            this.prevPos = pos.getPos1();
        }
    }
}

