/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.gui;

import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.gui.AlignmentCalculationRunnable;
import org.biojava.nbio.structure.symmetry.gui.SymmetryDisplay;
import org.biojava.nbio.structure.symmetry.gui.SymmetryGui;
import org.biojava.nbio.structure.symmetry.internal.CESymmParameters;
import org.biojava.nbio.structure.symmetry.internal.CeSymm;
import org.biojava.nbio.structure.symmetry.internal.CeSymmResult;
import org.biojava.nbio.structure.symmetry.utils.SymmetryTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmetryCalc
implements AlignmentCalculationRunnable {
    private static final Logger logger = LoggerFactory.getLogger(SymmetryCalc.class);
    boolean interrupted = false;
    private Structure structure;
    private SymmetryGui parent;

    public SymmetryCalc(SymmetryGui p, Structure s) {
        this.parent = p;
        this.structure = s;
    }

    @Override
    public void run() {
        CESymmParameters params = this.parent.getParameters();
        try {
            Atom[] atoms = SymmetryTools.getRepresentativeAtoms((Structure)this.structure);
            CeSymmResult result = CeSymm.analyze((Atom[])atoms, (CESymmParameters)params);
            SymmetryDisplay.display(result);
        }
        catch (StructureException e) {
            logger.warn(e.getMessage());
        }
        this.parent.notifyCalcFinished();
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    @Override
    public void cleanup() {
        this.parent.notifyCalcFinished();
        this.parent = null;
        this.structure = null;
    }

    @Override
    public void setNrCPUs(int useNrCPUs) {
    }
}

