/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui.util;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.align.client.StructureName;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.align.webstart.WebStartMain;

public class SelectMultiplePanel
extends JPanel {
    private static final long serialVersionUID = 757947454156959178L;
    JTextField input;

    public SelectMultiplePanel() {
        this(true);
    }

    public SelectMultiplePanel(boolean show2boxes) {
        Box vBox = Box.createVerticalBox();
        this.input = new JTextField("1mbc 1hlb 1dlw 1ith.A 1thb.A 1kr7.A_0-109");
        Box b = this.getDomainPanel(this.input);
        vBox.add(b);
        this.add(vBox);
    }

    private Box getDomainPanel(JTextField f) {
        JLabel l01 = new JLabel("Input structures:");
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createGlue());
        hBox.add(l01);
        f.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        f.setToolTipText("Provide structure identifiers space separated.");
        hBox.add(Box.createVerticalGlue());
        hBox.add((Component)f, "Center");
        hBox.add(Box.createGlue());
        return hBox;
    }

    public List<Structure> getStructures() throws StructureException {
        ArrayList<Structure> structures = new ArrayList<Structure>();
        for (StructureIdentifier name : this.getNames()) {
            structures.add(this.getStructure(name));
        }
        return structures;
    }

    public List<StructureIdentifier> getNames() {
        String[] split;
        ArrayList<StructureIdentifier> names = new ArrayList<StructureIdentifier>();
        String raw = this.input.getText().trim();
        for (String name : split = raw.split(" ")) {
            if (name == null || name.isEmpty()) continue;
            names.add((StructureIdentifier)new StructureName(name.trim()));
        }
        return names;
    }

    private Structure getStructure(StructureIdentifier name) throws StructureException {
        UserConfiguration config = WebStartMain.getWebStartConfig();
        AtomCache cache = new AtomCache(config);
        Structure s = null;
        try {
            s = cache.getStructure(name);
            s.setName(name.getIdentifier());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }
}

