/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.multiple.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.util.ReferenceSuperimposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleAlignmentDisplay {
    private static final Logger logger = LoggerFactory.getLogger(MultipleAlignmentDisplay.class);

    public static List<Atom[]> getRotatedAtoms(MultipleAlignment multAln) throws StructureException {
        int size = multAln.size();
        List<Atom[]> atomArrays = multAln.getAtomArrays();
        for (int i = 0; i < size; ++i) {
            if (atomArrays.get(i).length >= 1) continue;
            throw new StructureException("Length of atoms arrays is too short! Size: " + atomArrays.get(i).length);
        }
        ArrayList<Atom[]> rotatedAtoms = new ArrayList<Atom[]>();
        List<Matrix4d> transf = multAln.getBlockSet(0).getTransformations();
        if (transf == null) {
            logger.error("Alignment Transformations are not calculated. Superimposing to first structure as reference.");
            multAln = multAln.clone();
            ReferenceSuperimposer imposer = new ReferenceSuperimposer();
            imposer.superimpose(multAln);
            transf = multAln.getBlockSet(0).getTransformations();
            assert (transf != null);
        }
        for (int i = 0; i < size; ++i) {
            Structure displayS = atomArrays.get(i)[0].getGroup().getChain().getStructure().clone();
            Atom[] rotCA = StructureTools.getRepresentativeAtomArray(displayS);
            List<Group> hetatms = StructureTools.getUnalignedGroups(rotCA);
            for (Group g : hetatms) {
                rotCA = Arrays.copyOf(rotCA, rotCA.length + 1);
                rotCA[rotCA.length - 1] = g.getAtom(0);
            }
            Calc.transform(displayS, transf.get(i));
            rotatedAtoms.add(rotCA);
        }
        return rotatedAtoms;
    }
}

