/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompAtom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChargeAdder {
    private static final Logger logger = LoggerFactory.getLogger(ChargeAdder.class);
    private Structure structure;

    public ChargeAdder(Structure structure) {
        this.structure = structure;
    }

    public void addCharges() {
        for (Chain c : this.structure.getChains()) {
            for (Group g : c.getAtomGroups()) {
                ChemComp thisChemComp = ChemCompGroupFactory.getChemComp(g.getPDBName());
                List<ChemCompAtom> chemAtoms = thisChemComp.getAtoms();
                List<Atom> protAtoms = g.getAtoms();
                if (protAtoms.size() != chemAtoms.size()) continue;
                for (int i = 0; i < protAtoms.size(); ++i) {
                    ChemCompAtom cca = chemAtoms.get(i);
                    Atom a = protAtoms.get(i);
                    try {
                        short charge = Short.parseShort(cca.getCharge());
                        a.setCharge(charge);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        logger.info("Could not parse charge for atom {} of {}. Will set its charge to 0", (Object)a.getName(), (Object)g.getPDBName());
                        a.setCharge((short)0);
                    }
                }
            }
        }
    }
}

