/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.List;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.symmetry.core.HelixAxisAligner;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryResults;
import org.biojava.nbio.structure.symmetry.core.RotationAxisAligner;
import org.biojava.nbio.structure.symmetry.core.Subunits;

public abstract class AxisAligner {
    public static AxisAligner getInstance(QuatSymmetryResults results) {
        String symmetry = results.getSymmetry();
        if (symmetry.equals("H")) {
            return new HelixAxisAligner(results);
        }
        return new RotationAxisAligner(results);
    }

    public abstract String getSymmetry();

    public abstract Matrix4d getTransformation();

    public abstract Matrix3d getRotationMatrix();

    public abstract Matrix4d getReverseTransformation();

    public abstract Vector3d getPrincipalRotationAxis();

    public abstract Vector3d getRotationReferenceAxis();

    public abstract Vector3d[] getPrincipalAxesOfInertia();

    public abstract Vector3d getDimension();

    public abstract double getRadius();

    public abstract Matrix4d getGeometicCenterTransformation();

    public abstract Point3d getGeometricCenter();

    public abstract Point3d getCentroid();

    public abstract Subunits getSubunits();

    public abstract List<List<Integer>> getOrbits();
}

