/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupIterator;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.PDBFileParser;

public final class StandardAminoAcid {
    private static final String STANDARD_AMINOS_FILE = "org/biojava/nbio/structure/standardaminos.pdb.gz";
    private static Map<String, AminoAcid> aminoAcids = new HashMap<String, AminoAcid>();

    private StandardAminoAcid() {
    }

    public static AminoAcid getAminoAcid(String name) {
        return aminoAcids.get(name);
    }

    static {
        InputStream fileStream = StandardAminoAcid.class.getClassLoader().getResourceAsStream(STANDARD_AMINOS_FILE);
        if (fileStream == null) {
            throw new RuntimeException("Could not find resource org/biojava/nbio/structure/standardaminos.pdb.gz.  This probably means that your biojava.jar file is corrupt or incorrectly built.");
        }
        try {
            GZIPInputStream gzipIS = new GZIPInputStream(fileStream);
            PDBFileParser parser = new PDBFileParser();
            Structure s = parser.parsePDBFile(gzipIS);
            GroupIterator iter = new GroupIterator(s);
            while (iter.hasNext()) {
                Group g = iter.next();
                if (!(g instanceof AminoAcid)) continue;
                AminoAcid aa = (AminoAcid)g;
                aminoAcids.put(aa.getPDBName(), aa);
                aminoAcids.put(aa.getAminoType().toString(), aa);
            }
        }
        catch (Exception t) {
            throw new RuntimeException("Unable to initialize standard aminoacids", t);
        }
    }
}

