/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.biojava.nbio.core.util.XMLWriter;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.DBRef;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.PDBHeader;
import org.biojava.nbio.structure.Site;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.SSBondImpl;
import org.biojava.nbio.structure.io.mmcif.MMCIFFileTools;
import org.biojava.nbio.structure.io.mmcif.model.AtomSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConvert {
    private static final Logger logger = LoggerFactory.getLogger(FileConvert.class);
    private Structure structure;
    private boolean printConnections;
    public static DecimalFormat d3 = (DecimalFormat)NumberFormat.getInstance(Locale.US);
    public static DecimalFormat d2;
    private static final String newline;

    public FileConvert(Structure struc) {
        this.structure = struc;
        this.printConnections = true;
    }

    public boolean doPrintConnections() {
        return this.printConnections;
    }

    public void setPrintConnections(boolean printConnections) {
        this.printConnections = printConnections;
    }

    private String printPDBConnections() {
        StringBuffer str = new StringBuffer();
        List<Map<String, Integer>> cons = this.structure.getConnections();
        for (int cnr = 0; cnr < cons.size(); ++cnr) {
            Map<String, Integer> con = cons.get(cnr);
            Integer as = con.get("atomserial");
            String atomserial = "";
            String bond1 = "";
            String bond2 = "";
            String bond3 = "";
            String bond4 = "";
            String hyd1 = "";
            String hyd2 = "";
            String salt1 = "";
            String hyd3 = "";
            String hyd4 = "";
            String salt2 = "";
            if (con.containsKey("bond1")) {
                bond1 = con.get("bond1").toString();
            }
            if (con.containsKey("bond2")) {
                bond2 = con.get("bond2").toString();
            }
            if (con.containsKey("bond3")) {
                bond3 = con.get("bond3").toString();
            }
            if (con.containsKey("bond4")) {
                bond4 = con.get("bond4").toString();
            }
            if (con.containsKey("hyd1")) {
                hyd1 = con.get("hyd1").toString();
            }
            if (con.containsKey("hyd2")) {
                hyd2 = con.get("hyd2").toString();
            }
            if (con.containsKey("salt1")) {
                salt1 = con.get("salt1").toString();
            }
            if (con.containsKey("hyd3")) {
                hyd3 = con.get("hyd3").toString();
            }
            if (con.containsKey("hyd4")) {
                hyd4 = con.get("hyd4").toString();
            }
            if (con.containsKey("salt2")) {
                salt2 = con.get("salt2").toString();
            }
            atomserial = String.format("%5d", as);
            bond1 = String.format("%5s", bond1);
            bond2 = String.format("%5s", bond2);
            bond3 = String.format("%5s", bond3);
            bond4 = String.format("%5s", bond4);
            hyd1 = String.format("%5s", hyd1);
            hyd2 = String.format("%5s", hyd2);
            salt1 = String.format("%5s", salt1);
            hyd3 = String.format("%5s", hyd3);
            hyd4 = String.format("%5s", hyd4);
            salt2 = String.format("%5s", salt2);
            String connectLine = "CONECT" + atomserial + bond1 + bond2 + bond3 + bond4 + hyd1 + hyd2 + salt1 + hyd3 + hyd4 + salt2;
            str.append(connectLine).append(newline);
        }
        return str.toString();
    }

    public String toPDB() {
        StringBuffer str = new StringBuffer();
        PDBHeader header = this.structure.getPDBHeader();
        header.toPDB(str);
        if (!this.structure.getSites().isEmpty()) {
            str.append("REMARK 800                                                                      ").append(newline);
            str.append("REMARK 800 SITE                                                                 ").append(newline);
            for (Site site : this.structure.getSites()) {
                site.remark800toPDB(str);
            }
        }
        for (DBRef dBRef : this.structure.getDBRefs()) {
            dBRef.toPDB(str);
            str.append(newline);
        }
        List<SSBondImpl> ssbonds = SSBondImpl.getSsBondListFromBondList(this.structure.getSSBonds());
        for (SSBondImpl ssbond : ssbonds) {
            ssbond.toPDB(str);
            str.append(newline);
        }
        for (Site site : this.structure.getSites()) {
            try {
                site.toPDB(str);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int n = this.structure.nrModels();
        if (this.structure.isNmr()) {
            str.append("EXPDTA    NMR, " + n + " STRUCTURES" + newline);
        }
        for (int m = 0; m < n; ++m) {
            List<Chain> model = this.structure.getModel(m);
            if (n > 1) {
                str.append("MODEL      " + (m + 1) + newline);
            }
            int nrChains = model.size();
            for (int c = 0; c < nrChains; ++c) {
                Chain chain = model.get(c);
                int nrGroups = chain.getAtomLength();
                for (int h = 0; h < nrGroups; ++h) {
                    Group g = chain.getAtomGroup(h);
                    FileConvert.toPDB(g, str);
                }
                if (nrGroups <= 0) continue;
                str.append("TER").append(newline);
            }
            if (n <= 1) continue;
            str.append("ENDMDL").append(newline);
        }
        if (this.doPrintConnections()) {
            str.append(this.printPDBConnections());
        }
        return str.toString();
    }

    private static void toPDB(Group g, StringBuffer str) {
        int groupsize = g.size();
        for (int atompos = 0; atompos < groupsize; ++atompos) {
            Atom a = null;
            a = g.getAtom(atompos);
            if (a == null) continue;
            FileConvert.toPDB(a, str);
        }
        if (g.hasAltLoc()) {
            for (Group alt : g.getAltLocs()) {
                FileConvert.toPDB(alt, str);
            }
        }
    }

    public static String toPDB(Atom a) {
        StringBuffer w = new StringBuffer();
        FileConvert.toPDB(a, w);
        return w.toString();
    }

    public static String toPDB(Atom a, String chainId) {
        StringBuffer w = new StringBuffer();
        FileConvert.toPDB(a, w, chainId);
        return w.toString();
    }

    public static String toPDB(Chain chain) {
        StringBuffer w = new StringBuffer();
        int nrGroups = chain.getAtomLength();
        for (int h = 0; h < nrGroups; ++h) {
            Group g = chain.getAtomGroup(h);
            FileConvert.toPDB(g, w);
        }
        return w.toString();
    }

    public static String toPDB(Group g) {
        StringBuffer w = new StringBuffer();
        FileConvert.toPDB(g, w);
        return w.toString();
    }

    public static void toPDB(Atom a, StringBuffer str, String chainID) {
        Group g = a.getGroup();
        GroupType type = g.getType();
        String record = "";
        record = type.equals((Object)GroupType.HETATM) ? "HETATM" : "ATOM  ";
        String resName = g.getPDBName();
        String pdbcode = g.getResidueNumber().toString();
        int seri = a.getPDBserial();
        String serial = String.format("%5d", seri);
        String fullName = FileConvert.formatAtomName(a);
        Character altLoc = a.getAltLoc();
        String resseq = "";
        resseq = FileConvert.hasInsertionCode(pdbcode) ? String.format("%5s", pdbcode) : String.format("%4s", pdbcode) + " ";
        String x = String.format("%8s", d3.format(a.getX()));
        String y = String.format("%8s", d3.format(a.getY()));
        String z = String.format("%8s", d3.format(a.getZ()));
        String occupancy = String.format("%6s", d2.format(a.getOccupancy()));
        String tempfactor = String.format("%6s", d2.format(a.getTempFactor()));
        String leftResName = String.format("%3s", resName);
        StringBuffer s = new StringBuffer();
        s.append(record);
        s.append(serial);
        s.append(" ");
        s.append(fullName);
        s.append(altLoc);
        s.append(leftResName);
        s.append(" ");
        s.append(chainID);
        s.append(resseq);
        s.append("   ");
        s.append(x);
        s.append(y);
        s.append(z);
        s.append(occupancy);
        s.append(tempfactor);
        Element e = a.getElement();
        String eString = e.toString().toUpperCase();
        if (e.equals(Element.R)) {
            eString = "X";
        }
        str.append(String.format("%-76s%2s", s.toString(), eString));
        str.append(newline);
    }

    public static void toPDB(Atom a, StringBuffer str) {
        FileConvert.toPDB(a, str, a.getGroup().getChainId());
    }

    private static boolean hasInsertionCode(String pdbserial) {
        try {
            Integer.parseInt(pdbserial);
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public void toDASStructure(XMLWriter xw) throws IOException {
        if (this.structure == null) {
            System.err.println("can not convert structure null");
            return;
        }
        PDBHeader header = this.structure.getPDBHeader();
        xw.openTag("object");
        xw.attribute("dbAccessionId", this.structure.getPDBCode());
        xw.attribute("intObjectId", this.structure.getPDBCode());
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy", Locale.US);
        String modificationDate = dateFormat.format(header.getModDate());
        xw.attribute("objectVersion", modificationDate);
        xw.attribute("type", "protein structure");
        xw.attribute("dbSource", "PDB");
        xw.attribute("dbVersion", "20070116");
        xw.attribute("dbCoordSys", "PDBresnum,Protein Structure");
        xw.closeTag("object");
        for (int modelnr = 0; modelnr < this.structure.nrModels(); ++modelnr) {
            for (int chainnr = 0; chainnr < this.structure.size(modelnr); ++chainnr) {
                Chain chain = this.structure.getChain(modelnr, chainnr);
                xw.openTag("chain");
                xw.attribute("id", chain.getChainID());
                xw.attribute("SwissprotId", chain.getSwissprotId());
                if (this.structure.nrModels() > 1) {
                    xw.attribute("model", Integer.toString(modelnr + 1));
                }
                for (int groupnr = 0; groupnr < chain.getAtomLength(); ++groupnr) {
                    Group gr = chain.getAtomGroup(groupnr);
                    xw.openTag("group");
                    xw.attribute("name", gr.getPDBName());
                    xw.attribute("type", gr.getType().toString());
                    xw.attribute("groupID", gr.getResidueNumber().toString());
                    List<Atom> atoms = gr.getAtoms();
                    for (int atomnr = 0; atomnr < atoms.size(); ++atomnr) {
                        Atom atom = atoms.get(atomnr);
                        xw.openTag("atom");
                        xw.attribute("atomID", Integer.toString(atom.getPDBserial()));
                        xw.attribute("atomName", FileConvert.formatAtomName(atom));
                        xw.attribute("x", Double.toString(atom.getX()));
                        xw.attribute("y", Double.toString(atom.getY()));
                        xw.attribute("z", Double.toString(atom.getZ()));
                        xw.closeTag("atom");
                    }
                    xw.closeTag("group");
                }
                xw.closeTag("chain");
            }
        }
        if (this.doPrintConnections()) {
            List<Map<String, Integer>> cons = this.structure.getConnections();
            for (int cnr = 0; cnr < cons.size(); ++cnr) {
                Map<String, Integer> con = cons.get(cnr);
                Integer as = con.get("atomserial");
                int atomserial = as;
                ArrayList<Integer> atomids = new ArrayList<Integer>();
                if (con.containsKey("salt1")) {
                    atomids.add(con.get("salt1"));
                }
                if (con.containsKey("salt2")) {
                    atomids.add(con.get("salt2"));
                }
                if (atomids.size() != 0) {
                    this.addConnection(xw, "salt", atomserial, atomids);
                    atomids = new ArrayList();
                }
                if (con.containsKey("hydrogen1")) {
                    atomids.add(con.get("hydrogen1"));
                }
                if (con.containsKey("hydrogen2")) {
                    atomids.add(con.get("hydrogen2"));
                }
                if (con.containsKey("hydrogen3")) {
                    atomids.add(con.get("hydrogen3"));
                }
                if (con.containsKey("hydrogen4")) {
                    atomids.add(con.get("hydrogen4"));
                }
                if (atomids.size() != 0) {
                    this.addConnection(xw, "hydrogen", atomserial, atomids);
                    atomids = new ArrayList();
                }
                if (con.containsKey("bond1")) {
                    atomids.add(con.get("bond1"));
                }
                if (con.containsKey("bond2")) {
                    atomids.add(con.get("bond2"));
                }
                if (con.containsKey("bond3")) {
                    atomids.add(con.get("bond3"));
                }
                if (con.containsKey("bond4")) {
                    atomids.add(con.get("bond4"));
                }
                if (atomids.size() == 0) continue;
                this.addConnection(xw, "bond", atomserial, atomids);
            }
        }
    }

    private void addConnection(XMLWriter xw, String connType, int atomserial, List<Integer> atomids) {
        try {
            xw.openTag("connect");
            xw.attribute("atomSerial", Integer.toString(atomserial));
            xw.attribute("type", connType);
            for (int i = 0; i < atomids.size(); ++i) {
                Integer atomid = atomids.get(i);
                if (atomid == null) continue;
                int aid = atomid;
                xw.openTag("atomID");
                xw.attribute("atomID", Integer.toString(aid));
                xw.closeTag("atomID");
            }
            xw.closeTag("connect");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String formatAtomName(Atom a) {
        String fullName = null;
        String name = a.getName();
        Element element = a.getElement();
        if (name.length() == 4) {
            fullName = name;
        } else if (name.length() == 3) {
            fullName = " " + name;
        } else if (name.length() == 2) {
            fullName = element == Element.C || element == Element.N || element == Element.O || element == Element.P || element == Element.S ? " " + name + " " : name + "  ";
        } else if (name.length() == 1) {
            fullName = " " + name + "  ";
        }
        return fullName;
    }

    public String toMMCIF() {
        StringBuilder str = new StringBuilder();
        str.append("data_BioJava_mmCIF_file" + newline);
        if (this.structure.getPDBHeader() != null & this.structure.getPDBHeader().getCrystallographicInfo() != null && this.structure.getPDBHeader().getCrystallographicInfo().getSpaceGroup() != null && this.structure.getPDBHeader().getCrystallographicInfo().getCrystalCell() != null) {
            str.append(MMCIFFileTools.toMMCIF("_cell", MMCIFFileTools.convertCrystalCellToCell(this.structure.getPDBHeader().getCrystallographicInfo().getCrystalCell())));
            str.append(MMCIFFileTools.toMMCIF("_symmetry", MMCIFFileTools.convertSpaceGroupToSymmetry(this.structure.getPDBHeader().getCrystallographicInfo().getSpaceGroup())));
        }
        str.append(FileConvert.getAtomSiteHeader());
        List<AtomSite> list = MMCIFFileTools.convertStructureToAtomSites(this.structure);
        str.append(MMCIFFileTools.toMMCIF(list, AtomSite.class));
        return str.toString();
    }

    public static String toMMCIF(Chain chain, String chainId, String internalChainId, boolean writeHeader) {
        StringBuilder str = new StringBuilder();
        if (writeHeader) {
            str.append(FileConvert.getAtomSiteHeader());
        }
        List<AtomSite> list = MMCIFFileTools.convertChainToAtomSites(chain, 1, chainId, internalChainId);
        str.append(MMCIFFileTools.toMMCIF(list, AtomSite.class));
        return str.toString();
    }

    public static String toMMCIF(Chain chain, boolean writeHeader) {
        StringBuilder sb = new StringBuilder();
        sb.append("data_BioJava_mmCIF_file" + newline);
        sb.append(FileConvert.toMMCIF(chain, chain.getChainID(), chain.getInternalChainID(), writeHeader));
        return sb.toString();
    }

    public static String getAtomSiteHeader() {
        String header;
        try {
            header = MMCIFFileTools.toLoopMmCifHeaderString("_atom_site", AtomSite.class.getName());
        }
        catch (ClassNotFoundException e) {
            logger.error("Class not found, will not have a header for this MMCIF category: " + e.getMessage());
            header = "";
        }
        return header;
    }

    static {
        d3.setMaximumIntegerDigits(4);
        d3.setMinimumFractionDigits(3);
        d3.setMaximumFractionDigits(3);
        d2 = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        d2.setMaximumIntegerDigits(3);
        d2.setMinimumFractionDigits(2);
        d2.setMaximumFractionDigits(2);
        newline = System.getProperty("line.separator");
    }
}

