/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.contact;

import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.contact.AtomContactSet;
import org.biojava.nbio.structure.contact.BoundingBox;
import org.biojava.nbio.structure.contact.GridCell;

public class Grid {
    private static final int SCALE = 100;
    private GridCell[][][] cells;
    private double cutoff;
    private int cellSize;
    private Atom[] iAtoms;
    private Atom[] jAtoms;
    private int[] bounds;
    private BoundingBox ibounds;
    private BoundingBox jbounds;
    private boolean noOverlap;

    public Grid(double cutoff) {
        this.cutoff = cutoff;
        this.cellSize = (int)Math.floor(cutoff * 100.0);
        this.noOverlap = false;
    }

    private int getFloor(double number) {
        return this.cellSize * (int)Math.floor(number * 100.0 / (double)this.cellSize);
    }

    private int xintgrid2xgridindex(int xgridDim) {
        return (xgridDim - this.bounds[0]) / this.cellSize;
    }

    private int yintgrid2ygridindex(int ygridDim) {
        return (ygridDim - this.bounds[1]) / this.cellSize;
    }

    private int zintgrid2zgridindex(int zgridDim) {
        return (zgridDim - this.bounds[2]) / this.cellSize;
    }

    public void addAtoms(Atom[] iAtoms, Atom[] jAtoms) {
        this.addAtoms(iAtoms, null, jAtoms, null);
    }

    public void addAtoms(Atom[] iAtoms, BoundingBox icoordbounds, Atom[] jAtoms, BoundingBox jcoordbounds) {
        this.iAtoms = iAtoms;
        this.ibounds = icoordbounds != null ? icoordbounds : new BoundingBox(iAtoms);
        this.jAtoms = jAtoms;
        this.jbounds = jAtoms == iAtoms ? this.ibounds : (jcoordbounds != null ? jcoordbounds : new BoundingBox(jAtoms));
        this.fillGrid();
    }

    public void addAtoms(Atom[] atoms) {
        this.addAtoms(atoms, (BoundingBox)null);
    }

    public void addAtoms(Atom[] atoms, BoundingBox bounds) {
        this.iAtoms = atoms;
        this.ibounds = bounds != null ? bounds : new BoundingBox(this.iAtoms);
        this.jAtoms = null;
        this.jbounds = null;
        this.fillGrid();
    }

    private void fillGrid() {
        if (this.jbounds != null && !this.ibounds.overlaps(this.jbounds, this.cutoff)) {
            this.noOverlap = true;
            return;
        }
        this.findFullGridIntBounds();
        this.cells = new GridCell[1 + (this.bounds[3] - this.bounds[0]) / this.cellSize][1 + (this.bounds[4] - this.bounds[1]) / this.cellSize][1 + (this.bounds[5] - this.bounds[2]) / this.cellSize];
        int i = 0;
        for (Atom atom : this.iAtoms) {
            int zind;
            int yind;
            int xind = this.xintgrid2xgridindex(this.getFloor(atom.getX()));
            if (this.cells[xind][yind = this.yintgrid2ygridindex(this.getFloor(atom.getY()))][zind = this.zintgrid2zgridindex(this.getFloor(atom.getZ()))] == null) {
                this.cells[xind][yind][zind] = new GridCell();
            }
            this.cells[xind][yind][zind].addIindex(i);
            ++i;
        }
        if (this.jAtoms == null) {
            return;
        }
        int j = 0;
        for (Atom atom : this.jAtoms) {
            int zind;
            int yind;
            int xind = this.xintgrid2xgridindex(this.getFloor(atom.getX()));
            if (this.cells[xind][yind = this.yintgrid2ygridindex(this.getFloor(atom.getY()))][zind = this.zintgrid2zgridindex(this.getFloor(atom.getZ()))] == null) {
                this.cells[xind][yind][zind] = new GridCell();
            }
            this.cells[xind][yind][zind].addJindex(j);
            ++j;
        }
    }

    private void findFullGridIntBounds() {
        int[] iIntBounds = this.getIntBounds(this.ibounds);
        this.bounds = new int[6];
        if (this.jbounds == null) {
            this.bounds = iIntBounds;
        } else {
            int[] jIntBounds = this.getIntBounds(this.jbounds);
            this.bounds[0] = Math.min(iIntBounds[0], jIntBounds[0]);
            this.bounds[1] = Math.min(iIntBounds[1], jIntBounds[1]);
            this.bounds[2] = Math.min(iIntBounds[2], jIntBounds[2]);
            this.bounds[3] = Math.max(iIntBounds[3], jIntBounds[3]);
            this.bounds[4] = Math.max(iIntBounds[4], jIntBounds[4]);
            this.bounds[5] = Math.max(iIntBounds[5], jIntBounds[5]);
        }
    }

    private int[] getIntBounds(BoundingBox coordbounds) {
        int[] bs = new int[]{this.getFloor(coordbounds.xmin), this.getFloor(coordbounds.ymin), this.getFloor(coordbounds.zmin), this.getFloor(coordbounds.xmax), this.getFloor(coordbounds.ymax), this.getFloor(coordbounds.zmax)};
        return bs;
    }

    public AtomContactSet getContacts() {
        AtomContactSet contacts = new AtomContactSet(this.cutoff);
        if (this.noOverlap) {
            return contacts;
        }
        for (int xind = 0; xind < this.cells.length; ++xind) {
            for (int yind = 0; yind < this.cells[xind].length; ++yind) {
                for (int zind = 0; zind < this.cells[xind][yind].length; ++zind) {
                    GridCell thisCell = this.cells[xind][yind][zind];
                    if (thisCell == null) continue;
                    contacts.addAll(thisCell.getContactsWithinCell(this.iAtoms, this.jAtoms, this.cutoff));
                    for (int x = xind - 1; x <= xind + 1; ++x) {
                        for (int y = yind - 1; y <= yind + 1; ++y) {
                            for (int z = zind - 1; z <= zind + 1; ++z) {
                                if (x == xind && y == yind && z == zind || x < 0 || x >= this.cells.length || y < 0 || y >= this.cells[x].length || z < 0 || z >= this.cells[x][y].length || this.cells[x][y][z] == null) continue;
                                contacts.addAll(thisCell.getContactsToOtherCell(this.cells[x][y][z], this.iAtoms, this.jAtoms, this.cutoff));
                            }
                        }
                    }
                }
            }
        }
        return contacts;
    }

    public double getCutoff() {
        return this.cutoff;
    }

    public boolean isNoOverlap() {
        return this.noOverlap;
    }
}

