/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.secstruc;

import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.secstruc.BetaBridge;
import org.biojava.nbio.structure.secstruc.HBond;
import org.biojava.nbio.structure.secstruc.SecStrucInfo;
import org.biojava.nbio.structure.secstruc.SecStrucType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecStrucState
extends SecStrucInfo {
    private static final long serialVersionUID = -5549430890272724340L;
    private static final Logger logger = LoggerFactory.getLogger(SecStrucState.class);
    private double phi = 360.0;
    private double psi = 360.0;
    private double omega = 360.0;
    private float kappa;
    private HBond accept1 = new HBond();
    private HBond accept2 = new HBond();
    private HBond donor1 = new HBond();
    private HBond donor2 = new HBond();
    private char[] turn = new char[3];
    private boolean bend;
    private BetaBridge bridge1 = null;
    private BetaBridge bridge2 = null;

    public SecStrucState(Group g, String ass, SecStrucType t) {
        super(g, ass, t);
        this.turn[0] = 32;
        this.turn[1] = 32;
        this.turn[2] = 32;
        this.bend = false;
        this.kappa = 360.0f;
    }

    public boolean isBend() {
        return this.bend;
    }

    public void setBend(boolean bend) {
        this.bend = bend;
    }

    public float getKappa() {
        return this.kappa;
    }

    public void setKappa(float kappa) {
        this.kappa = kappa;
    }

    public char[] getTurn() {
        return this.turn;
    }

    public void setTurn(char c, int t) {
        if (this.turn[t - 3] == 'X') {
            return;
        }
        if (this.turn[t - 3] == '<' && c == '>' || this.turn[t - 3] == '>' && c == '<') {
            this.turn[t - 3] = 88;
        } else {
            if (this.turn[t - 3] == '<' || this.turn[t - 3] == '>') {
                return;
            }
            this.turn[t - 3] = c;
        }
    }

    public HBond getAccept1() {
        return this.accept1;
    }

    public void setAccept1(HBond accept1) {
        this.accept1 = accept1;
    }

    public HBond getAccept2() {
        return this.accept2;
    }

    public void setAccept2(HBond accept2) {
        this.accept2 = accept2;
    }

    public HBond getDonor1() {
        return this.donor1;
    }

    public void setDonor1(HBond donor1) {
        this.donor1 = donor1;
    }

    public HBond getDonor2() {
        return this.donor2;
    }

    public void setDonor2(HBond donor2) {
        this.donor2 = donor2;
    }

    public double getPhi() {
        return this.phi;
    }

    public void setPhi(double phi) {
        this.phi = phi;
    }

    public double getPsi() {
        return this.psi;
    }

    public void setPsi(double psi) {
        this.psi = psi;
    }

    public double getOmega() {
        return this.omega;
    }

    public void setOmega(double omega) {
        this.omega = omega;
    }

    public BetaBridge getBridge1() {
        return this.bridge1;
    }

    public BetaBridge getBridge2() {
        return this.bridge2;
    }

    public boolean addBridge(BetaBridge bridge) {
        if (this.bridge1 == null) {
            this.bridge1 = bridge;
            return true;
        }
        if (this.bridge1.equals(bridge)) {
            return true;
        }
        if (this.bridge2 == null) {
            this.bridge2 = bridge;
            return true;
        }
        if (this.bridge2.equals(bridge)) {
            return true;
        }
        logger.info("Residue forms more than 2 beta Bridges, DSSP output might differ in Bridges column.");
        return false;
    }

    public void setBridge1(BetaBridge bridge1) {
        this.bridge1 = bridge1;
    }

    public void setBridge2(BetaBridge bridge2) {
        this.bridge2 = bridge2;
    }

    public String printDSSPline(int index) {
        StringBuffer buf = new StringBuffer();
        if (index < 9) {
            buf.append("    ");
        } else if (index < 99) {
            buf.append("   ");
        } else if (index < 999) {
            buf.append("  ");
        } else {
            buf.append(" ");
        }
        buf.append(index + 1);
        int resnum = this.parent.getResidueNumber().getSeqNum();
        if (resnum < 10) {
            buf.append("    ");
        } else if (resnum < 100) {
            buf.append("   ");
        } else {
            buf.append("  ");
        }
        buf.append(resnum);
        Character insCode = this.parent.getResidueNumber().getInsCode();
        if (insCode != null) {
            buf.append(insCode);
        } else {
            buf.append(" ");
        }
        buf.append(this.parent.getChainId());
        if (this.parent.getChainId().length() == 1) {
            buf.append(" ");
        }
        char aaLetter = StructureTools.get1LetterCode(this.parent.getPDBName()).charValue();
        buf.append(aaLetter).append("  ");
        buf.append((Object)this.type).append(" ");
        for (int t = 0; t < 3; ++t) {
            buf.append(this.turn[t]);
        }
        buf.append("  ");
        if (this.isBend()) {
            buf.append('S');
        } else {
            buf.append(" ");
        }
        buf.append(" ");
        int bp1 = 0;
        if (this.bridge1 != null) {
            bp1 = this.bridge1.partner1 != index ? this.bridge1.partner1 + 1 : this.bridge1.partner2 + 1;
        }
        if (bp1 < 10) {
            buf.append("   ").append(bp1);
        } else if (bp1 < 100) {
            buf.append("  ").append(bp1);
        } else if (bp1 < 1000) {
            buf.append(" ").append(bp1);
        } else {
            buf.append(bp1);
        }
        int bp2 = 0;
        if (this.bridge2 != null) {
            bp2 = this.bridge2.partner1 != index ? this.bridge2.partner1 + 1 : this.bridge2.partner2 + 1;
        }
        if (bp2 < 10) {
            buf.append("   ").append(bp2);
        } else if (bp2 < 100) {
            buf.append("  ").append(bp2);
        } else if (bp2 < 1000) {
            buf.append(" ").append(bp2);
        } else {
            buf.append(bp2);
        }
        buf.append(" ");
        buf.append("     ");
        int p1 = this.accept1.getPartner();
        double e1 = this.accept1.getEnergy() / 1000.0;
        if (e1 < 0.0) {
            p1 -= index;
        }
        buf.append(String.format("%6d,%4.1f", p1, e1));
        int p2 = this.donor1.getPartner();
        double e2 = this.donor1.getEnergy() / 1000.0;
        if (e2 < 0.0) {
            p2 -= index;
        }
        buf.append(String.format("%6d,%4.1f", p2, e2));
        int p3 = this.accept2.getPartner();
        double e3 = this.accept2.getEnergy() / 1000.0;
        if (e3 < 0.0) {
            p3 -= index;
        }
        buf.append(String.format("%6d,%4.1f", p3, e3));
        int p4 = this.donor2.getPartner();
        double e4 = this.donor2.getEnergy() / 1000.0;
        if (e4 < 0.0) {
            p4 -= index;
        }
        buf.append(String.format("%6d,%4.1f", p4, e4));
        buf.append("        ");
        buf.append(String.format("%6.1f", Float.valueOf(this.kappa)));
        buf.append("      ");
        buf.append(String.format("%6.1f %6.1f ", this.phi, this.psi));
        Atom ca = this.parent.getAtom("CA");
        buf.append(String.format("%6.1f %6.1f %6.1f", ca.getX(), ca.getY(), ca.getZ()));
        return buf.toString();
    }
}

