/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.io.IOException;
import java.io.InputStream;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.LocalPDBDirectory;
import org.biojava.nbio.structure.io.cif.CifFileConverter;

public class BcifFileReader
extends LocalPDBDirectory {
    public static final String[] CIF_SPLIT_DIR = new String[]{"data", "structures", "divided", "bcif"};
    public static final String[] CIF_OBSOLETE_DIR = new String[]{"data", "structures", "obsolete", "bcif"};

    public BcifFileReader() {
        this(null);
    }

    public BcifFileReader(String path) {
        super(path);
        this.addExtension(".bcif");
        this.addExtension(".bcif.gz");
    }

    @Override
    public Structure getStructure(InputStream inStream) throws IOException {
        return CifFileConverter.fromInputStream(inStream, this.getFileParsingParameters());
    }

    @Override
    protected String getFilename(String pdbId) {
        return pdbId.toLowerCase() + ".bcif";
    }

    @Override
    protected String[] getSplitDirPath() {
        return CIF_SPLIT_DIR;
    }

    @Override
    protected String[] getObsoleteDirPath() {
        return CIF_OBSOLETE_DIR;
    }
}

