/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.geometry;

import java.util.Arrays;
import java.util.List;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.biojava.nbio.structure.symmetry.geometry.Polyhedron;

public class Icosahedron
implements Polyhedron {
    private static int[] lineLoop1 = new int[]{4, 0, 1, 2, 3, 4, 5, 1};
    private static int[] lineLoop2 = new int[]{3, 0, 2};
    private static int[] lineLoop3 = new int[]{0, 5};
    private static int[] lineLoop4 = new int[]{11, 3, 7, 4, 8, 6, 7, 8, 9, 10, 11, 7};
    private static int[] lineLoop5 = new int[]{6, 11, 2, 10, 1, 9, 6, 10};
    private static int[] lineLoop6 = new int[]{8, 5, 9};
    private double circumscribedRadius = 1.0;

    @Override
    public double getCirumscribedRadius() {
        return this.circumscribedRadius;
    }

    public void setCirumscribedRadius(double cirumscribedRadius) {
        this.circumscribedRadius = cirumscribedRadius;
    }

    public double getInscribedRadius() {
        double side = Icosahedron.getSideLengthFromCircumscribedRadius(this.circumscribedRadius);
        return Icosahedron.getInscribedRadiusFromSideLength(side);
    }

    public void setInscribedRadius(double radius) {
        double side = Icosahedron.getSideLengthFromInscribedRadius(radius);
        this.circumscribedRadius = Icosahedron.getCircumscribedRadiusFromSideLength(side);
    }

    public double getMidRadius() {
        double side = Icosahedron.getSideLengthFromCircumscribedRadius(this.circumscribedRadius);
        return Icosahedron.getMiddleRadiusFromSideLength(side);
    }

    public void setMidRadius(double radius) {
        double side = Icosahedron.getSideLengthFromMiddleRadius(radius);
        this.circumscribedRadius = Icosahedron.getCircumscribedRadiusFromSideLength(side);
    }

    @Override
    public Point3d[] getVertices() {
        Point3d[] icosahedron = new Point3d[12];
        double c = this.circumscribedRadius * 1.0 / Math.sqrt(5.0);
        double s = 2.0 * c;
        double c1 = Math.sqrt((3.0 - Math.sqrt(5.0)) / 8.0);
        double s1 = Math.sqrt((5.0 + Math.sqrt(5.0)) / 8.0);
        double c2 = Math.sqrt((3.0 + Math.sqrt(5.0)) / 8.0);
        double s2 = Math.sqrt((5.0 - Math.sqrt(5.0)) / 8.0);
        icosahedron[0] = new Point3d(0.0, 0.0, this.circumscribedRadius);
        icosahedron[1] = new Point3d(s, 0.0, c);
        icosahedron[2] = new Point3d(s * c1, s * s1, c);
        icosahedron[3] = new Point3d(-s * c2, s * s2, c);
        icosahedron[4] = new Point3d(-s * c2, -s * s2, c);
        icosahedron[5] = new Point3d(s * c1, -s * s1, c);
        for (int i = 0; i < 6; ++i) {
            icosahedron[i + 6] = new Point3d(icosahedron[i]);
            icosahedron[i + 6].negate();
        }
        Matrix3d m = new Matrix3d();
        m.rotZ(0.3141592653589793);
        for (Point3d p : icosahedron) {
            m.transform((Tuple3d)p);
        }
        return icosahedron;
    }

    @Override
    public List<int[]> getLineLoops() {
        return Arrays.asList(lineLoop1, lineLoop2, lineLoop3, lineLoop4, lineLoop5, lineLoop6);
    }

    @Override
    public int getViewCount() {
        return 3;
    }

    @Override
    public String getViewName(int index) {
        String name;
        switch (index) {
            case 0: {
                name = "C5 axis vertex-centered";
                break;
            }
            case 1: {
                name = "C3 axis face-centered";
                break;
            }
            case 2: {
                name = "C2 axis edge-centered";
                break;
            }
            default: {
                throw new IllegalArgumentException("getViewMatrix: index out of range:" + index);
            }
        }
        return name;
    }

    @Override
    public Matrix3d getViewMatrix(int index) {
        Matrix3d m = new Matrix3d();
        switch (index) {
            case 0: {
                m.setIdentity();
                break;
            }
            case 1: {
                m.rotX(-0.6523581397843639);
                break;
            }
            case 2: {
                m.rotZ(1.5707963267948966);
                Matrix3d m1 = new Matrix3d();
                m1.rotX(-1.0172219678978445);
                m.mul(m1);
                break;
            }
            default: {
                throw new IllegalArgumentException("getViewMatrix: index out of range:" + index);
            }
        }
        return m;
    }

    private static double getSideLengthFromInscribedRadius(double radius) {
        return radius / (Math.sqrt(3.0) / 12.0 * (3.0 + Math.sqrt(5.0)));
    }

    private static double getInscribedRadiusFromSideLength(double sideLength) {
        return sideLength * (Math.sqrt(3.0) / 12.0 * (3.0 + Math.sqrt(5.0)));
    }

    private static double getSideLengthFromMiddleRadius(double radius) {
        return radius * 4.0 / (1.0 + Math.sqrt(5.0));
    }

    private static double getMiddleRadiusFromSideLength(double sideLength) {
        return sideLength / 4.0 * (1.0 + Math.sqrt(5.0));
    }

    private static double getSideLengthFromCircumscribedRadius(double radius) {
        return radius * 4.0 / Math.sqrt(10.0 + 2.0 * Math.sqrt(5.0));
    }

    private static double getCircumscribedRadiusFromSideLength(double sideLength) {
        return sideLength / 4.0 * Math.sqrt(10.0 + 2.0 * Math.sqrt(5.0));
    }
}

