/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockImpl;
import org.biojava.nbio.structure.align.multiple.BlockSetImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentImpl;
import org.biojava.nbio.structure.align.multiple.util.MultipleAlignmentScorer;
import org.biojava.nbio.structure.secstruc.SecStrucElement;
import org.biojava.nbio.structure.secstruc.SecStrucTools;
import org.biojava.nbio.structure.secstruc.SecStrucType;
import org.biojava.nbio.structure.symmetry.internal.CESymmParameters;
import org.biojava.nbio.structure.symmetry.internal.CeSymm;
import org.biojava.nbio.structure.symmetry.internal.CeSymmResult;
import org.biojava.nbio.structure.symmetry.internal.ResidueGroup;
import org.biojava.nbio.structure.symmetry.internal.SymmetryAxes;
import org.biojava.nbio.structure.symmetry.utils.SymmetryTools;
import org.jgrapht.Graph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CeSymmIterative {
    private static final Logger logger = LoggerFactory.getLogger(CeSymmIterative.class);
    private CESymmParameters params;
    private Graph<Integer, DefaultEdge> alignGraph;
    private List<CeSymmResult> levels;

    public CeSymmIterative(CESymmParameters param) {
        this.params = param;
        this.alignGraph = new SimpleGraph(DefaultEdge.class);
        this.levels = new ArrayList<CeSymmResult>();
    }

    public CeSymmResult execute(Atom[] atoms) throws StructureException {
        this.iterate(atoms);
        return this.reconstructSymmResult(atoms);
    }

    private void iterate(Atom[] atoms) throws StructureException {
        logger.debug("Starting new iteration...");
        if (!(atoms.length > this.params.getWinSize() && atoms.length > this.params.getMinCoreLength() || this.levels.isEmpty())) {
            logger.debug("Aborting iteration due to insufficient Atom array length: %d", (Object)atoms.length);
            return;
        }
        if (this.params.getSymmLevels() > 0 && this.levels.size() == this.params.getSymmLevels()) {
            return;
        }
        CeSymmResult result = CeSymm.analyzeLevel(atoms, this.params);
        if (this.params.getRefineMethod() == CESymmParameters.RefineMethod.NOT_REFINED || !result.isSignificant()) {
            if (this.levels.isEmpty()) {
                this.levels.add(result);
            }
            return;
        }
        Integer start = null;
        int it = 0;
        while (start == null) {
            start = result.getMultipleAlignment().getBlocks().get(0).getAlignRes().get(0).get(it);
            ++it;
        }
        Integer end = null;
        it = result.getMultipleAlignment().getBlocks().get(0).getAlignRes().get(0).size() - 1;
        while (end == null) {
            end = result.getMultipleAlignment().getBlocks().get(0).getAlignRes().get(0).get(it);
            --it;
        }
        Atom[] atomsR = Arrays.copyOfRange(atoms, (int)start, end + 1);
        if (CeSymmIterative.countHelixStrandSSE(atomsR) < this.params.getSSEThreshold()) {
            if (this.levels.isEmpty()) {
                this.levels.add(result);
            }
            return;
        }
        Block b = result.getMultipleAlignment().getBlock(0);
        for (int pos = 0; pos < b.length(); ++pos) {
            for (int su = 0; su < b.size() - 1; ++su) {
                Integer pos1 = b.getAlignRes().get(su).get(pos);
                Integer pos2 = b.getAlignRes().get(su + 1).get(pos);
                if (pos1 == null || pos2 == null) continue;
                this.alignGraph.addVertex((Object)pos1);
                this.alignGraph.addVertex((Object)pos2);
                this.alignGraph.addEdge((Object)pos1, (Object)pos2);
            }
        }
        this.levels.add(result);
        this.iterate(atomsR);
    }

    private CeSymmResult reconstructSymmResult(Atom[] atoms) throws StructureException {
        if (this.levels.size() == 1) {
            return this.levels.get(0);
        }
        CeSymmResult result = new CeSymmResult();
        result.setSelfAlignment(this.levels.get(0).getSelfAlignment());
        result.setStructureId(this.levels.get(0).getStructureId());
        result.setAtoms(this.levels.get(0).getAtoms());
        result.setParams(this.levels.get(0).getParams());
        MultipleAlignmentImpl msa = new MultipleAlignmentImpl();
        msa.getEnsemble().setAtomArrays(new ArrayList<Atom[]>());
        msa.getEnsemble().setStructureIdentifiers(new ArrayList<StructureIdentifier>());
        msa.getEnsemble().setAlgorithmName("jCE-symm");
        msa.getEnsemble().setVersion("2.2");
        BlockSetImpl bs = new BlockSetImpl(msa);
        BlockImpl b = new BlockImpl(bs);
        b.setAlignRes(new ArrayList<List<Integer>>());
        ConnectivityInspector inspector = new ConnectivityInspector(this.alignGraph);
        List comps = inspector.connectedSets();
        ArrayList<ResidueGroup> groups = new ArrayList<ResidueGroup>(comps.size());
        for (Object comp : comps) {
            groups.add(new ResidueGroup((Set<Integer>)comp));
        }
        int order = 1;
        for (CeSymmResult sr : this.levels) {
            order *= sr.getMultipleAlignment().size();
        }
        for (int su = 0; su < order; ++su) {
            b.getAlignRes().add(new ArrayList());
        }
        for (ResidueGroup group : groups) {
            if (group.order() != order) continue;
            group.combineWith(b.getAlignRes());
        }
        if (b.length() == 0) {
            return this.levels.get(0);
        }
        for (int su = 0; su < order; ++su) {
            Collections.sort(b.getAlignRes().get(su));
            msa.getEnsemble().getAtomArrays().add(atoms);
            msa.getEnsemble().getStructureIdentifiers().add(result.getStructureId());
        }
        result.setMultipleAlignment(msa);
        result.setRefined(true);
        result.setNumRepeats(order);
        SymmetryAxes axes = this.recoverAxes(result);
        result.setAxes(axes);
        SymmetryTools.updateSymmetryTransformation(result.getAxes(), msa);
        double tmScore = MultipleAlignmentScorer.getAvgTMScore(msa) * (double)msa.size();
        double rmsd = MultipleAlignmentScorer.getRMSD(msa);
        msa.putScore("AvgTM-score", tmScore);
        msa.putScore("RMSD", rmsd);
        return result;
    }

    private SymmetryAxes recoverAxes(CeSymmResult result) {
        SymmetryAxes axes = new SymmetryAxes();
        for (int m = 0; m < this.levels.size(); ++m) {
            MultipleAlignment align = this.levels.get(m).getMultipleAlignment();
            Matrix4d axis = align.getBlockSet(0).getTransformations().get(1);
            CESymmParameters.SymmetryType type = this.levels.get(m).getAxes().getElementaryAxis(0).getSymmType();
            int order = align.size();
            axes.addAxis(axis, order, type);
        }
        return axes;
    }

    private static int countHelixStrandSSE(Atom[] atoms) {
        List<SecStrucElement> sses = SecStrucTools.getSecStrucElements(SymmetryTools.getGroups(atoms));
        int count = 0;
        boolean helix = false;
        int hEnd = 0;
        for (SecStrucElement sse : sses) {
            SecStrucType t = sse.getType();
            if (t.isBetaStrand()) {
                helix = false;
                ++count;
                continue;
            }
            if (t.isHelixType()) {
                if (helix) {
                    if (sse.getRange().getStart().getSeqNum() + 1 == hEnd) {
                        hEnd = sse.getRange().getEnd().getSeqNum();
                        continue;
                    }
                    ++count;
                    continue;
                }
                ++count;
                continue;
            }
            helix = false;
        }
        return count;
    }
}

