/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.chem;

import org.biojava.nbio.core.util.SoftHashMap;
import org.biojava.nbio.structure.AminoAcidImpl;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.HetatomImpl;
import org.biojava.nbio.structure.NucleotideImpl;
import org.biojava.nbio.structure.chem.ChemComp;
import org.biojava.nbio.structure.chem.ChemCompProvider;
import org.biojava.nbio.structure.chem.DownloadChemCompProvider;
import org.biojava.nbio.structure.chem.PolymerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChemCompGroupFactory {
    private static final Logger logger = LoggerFactory.getLogger(ChemCompGroupFactory.class);
    private static ChemCompProvider chemCompProvider = new DownloadChemCompProvider();
    private static final SoftHashMap<String, ChemComp> cache = new SoftHashMap(0);

    public static ChemComp getChemComp(String recordName) {
        ChemComp cc = (ChemComp)cache.get((Object)(recordName = recordName.toUpperCase().trim()));
        if (cc != null) {
            logger.debug("Chem comp {} read from cache", (Object)cc.getThreeLetterCode());
            return cc;
        }
        logger.debug("Chem comp {} read from provider {}", (Object)recordName, (Object)chemCompProvider.getClass().getCanonicalName());
        cc = chemCompProvider.getChemComp(recordName);
        cache.put((Object)recordName, (Object)cc);
        return cc;
    }

    public static void setChemCompProvider(ChemCompProvider provider) {
        logger.debug("Setting new chem comp provider to {}", (Object)provider.getClass().getCanonicalName());
        chemCompProvider = provider;
        cache.clear();
    }

    public static ChemCompProvider getChemCompProvider() {
        return chemCompProvider;
    }

    public static void clearCache() {
        cache.clear();
    }

    public static Group getGroupFromChemCompDictionary(String recordName) {
        HetatomImpl g;
        ChemComp cc = ChemCompGroupFactory.getChemComp(recordName = recordName.toUpperCase().trim());
        if (cc == null) {
            return null;
        }
        if (PolymerType.PROTEIN_ONLY.contains(cc.getPolymerType())) {
            String parent;
            AminoAcidImpl aa = new AminoAcidImpl();
            String one_letter = cc.getOneLetterCode();
            if ((one_letter == null || one_letter.equals("X") || one_letter.equals("?") || one_letter.length() == 0) && (parent = cc.getMonNstdParentCompId()) != null && parent.length() == 3) {
                String parentid = cc.getMonNstdParentCompId();
                ChemComp parentCC = ChemCompGroupFactory.getChemComp(parentid);
                one_letter = parentCC.getOneLetterCode();
            }
            if (one_letter == null || one_letter.length() == 0 || one_letter.equals("?")) {
                logger.warn("Problem with chemical component: {} Did not find one letter code! Setting it to 'X'", (Object)recordName);
                aa.setAminoType(Character.valueOf('X'));
            } else {
                aa.setAminoType(Character.valueOf(one_letter.charAt(0)));
            }
            g = aa;
        } else {
            g = PolymerType.POLYNUCLEOTIDE_ONLY.contains(cc.getPolymerType()) ? new NucleotideImpl() : new HetatomImpl();
        }
        g.setChemComp(cc);
        return g;
    }

    public static String getOneLetterCode(ChemComp cc) {
        String oneLetter = cc.getOneLetterCode();
        if (oneLetter == null || oneLetter.equals("X") || oneLetter.equals("?")) {
            String parentId = cc.getMonNstdParentCompId();
            if (parentId == null) {
                return oneLetter;
            }
            if (parentId.length() > 3) {
                return oneLetter;
            }
            ChemComp parentCC = ChemCompGroupFactory.getChemComp(parentId);
            if (parentCC == null) {
                return oneLetter;
            }
            oneLetter = parentCC.getOneLetterCode();
        }
        return oneLetter;
    }
}

