/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.structure.jama.Matrix;
import org.biojava.nbio.structure.quaternary.BioAssemblyInfo;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyTransformation;

public class PDBBioAssemblyParser {
    private Integer currentBioMolecule = null;
    private List<String> currentChainIDs = new ArrayList<String>();
    private Matrix currentMatrix = null;
    private double[] shift = null;
    private Map<Integer, BioAssemblyInfo> transformationMap = new HashMap<Integer, BioAssemblyInfo>();
    private int modelNumber = 1;
    private List<BiologicalAssemblyTransformation> transformations;

    public void pdb_REMARK_350_Handler(String line) {
        if (line.startsWith("REMARK 350 BIOMOLECULE:")) {
            this.initialize();
            this.currentBioMolecule = Integer.parseInt(line.substring(24).trim());
        } else if (line.startsWith("REMARK 350 APPLY THE FOLLOWING TO CHAINS:")) {
            this.currentChainIDs.clear();
            this.addToCurrentChainList(line);
        } else if (line.startsWith("REMARK 350 IN ADDITION APPLY THE FOLLOWING TO CHAINS:")) {
            this.currentChainIDs.clear();
            this.addToCurrentChainList(line);
        } else if (line.startsWith("REMARK 350") && line.contains("AND CHAINS:")) {
            this.addToCurrentChainList(line);
        } else if (line.startsWith("REMARK 350   BIOMT") && this.readMatrix(line)) {
            this.saveMatrix();
            ++this.modelNumber;
        }
    }

    public Map<Integer, BioAssemblyInfo> getTransformationMap() {
        return this.transformationMap;
    }

    private boolean readMatrix(String line) {
        String[] items = line.split("[ ]+");
        String pos = items[2].substring(5);
        int row = Integer.parseInt(pos);
        if (row == 1) {
            this.currentMatrix = Matrix.identity(3, 3);
            this.shift = new double[3];
        }
        this.currentMatrix.set(row - 1, 0, Float.parseFloat(items[4]));
        this.currentMatrix.set(row - 1, 1, Float.parseFloat(items[5]));
        this.currentMatrix.set(row - 1, 2, Float.parseFloat(items[6]));
        this.shift[row - 1] = Float.parseFloat(items[7]);
        return row == 3;
    }

    private void saveMatrix() {
        for (String chainId : this.currentChainIDs) {
            BiologicalAssemblyTransformation transformation = new BiologicalAssemblyTransformation();
            transformation.setRotationMatrix(this.currentMatrix.getArray());
            transformation.setTranslation(this.shift);
            transformation.setId(String.valueOf(this.modelNumber));
            transformation.setChainId(chainId);
            this.transformations.add(transformation);
        }
        if (!this.transformationMap.containsKey(this.currentBioMolecule)) {
            BioAssemblyInfo bioAssembly = new BioAssemblyInfo();
            bioAssembly.setId(this.currentBioMolecule);
            bioAssembly.setTransforms(this.transformations);
            this.transformationMap.put(this.currentBioMolecule, bioAssembly);
        }
    }

    private void addToCurrentChainList(String line) {
        int index = line.indexOf(":");
        String chainList = line.substring(index + 1).trim();
        String[] chainIds = chainList.split("[ ,]+");
        this.currentChainIDs.addAll(Arrays.asList(chainIds));
    }

    private void initialize() {
        this.transformations = new ArrayList<BiologicalAssemblyTransformation>();
        this.currentMatrix = Matrix.identity(3, 3);
        this.currentBioMolecule = null;
        this.shift = new double[3];
        this.modelNumber = 1;
    }

    public void setMacromolecularSizes() {
        for (BioAssemblyInfo bioAssembly : this.transformationMap.values()) {
            bioAssembly.setMacromolecularSize(bioAssembly.getTransforms().size());
        }
    }
}

