/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Bond;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.io.FileConvert;

public class AtomImpl
implements Atom {
    private static final long serialVersionUID = -2258364127420562883L;
    public static final int BONDS_INITIAL_CAPACITY = 3;
    private String name = null;
    private Element element = Element.R;
    private Point3d coords = new Point3d();
    private int pdbserial;
    private short charge = 0;
    private float occupancy = 0.0f;
    private float tempfactor = 0.0f;
    private char altLoc = '\u0000';
    private Group parent = null;
    private List<Bond> bonds = null;

    @Override
    public void setName(String s) {
        this.name = s;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setPDBserial(int i) {
        this.pdbserial = i;
    }

    @Override
    public int getPDBserial() {
        return this.pdbserial;
    }

    @Override
    public void setCoords(double[] c) {
        this.coords = new Point3d(c);
    }

    @Override
    public double[] getCoords() {
        double[] c = new double[3];
        this.coords.get(c);
        return c;
    }

    @Override
    public Point3d getCoordsAsPoint3d() {
        return this.coords;
    }

    @Override
    public void setX(double x) {
        this.coords.x = x;
    }

    @Override
    public void setY(double y) {
        this.coords.y = y;
    }

    @Override
    public void setZ(double z) {
        this.coords.z = z;
    }

    @Override
    public double getX() {
        return this.coords.x;
    }

    @Override
    public double getY() {
        return this.coords.y;
    }

    @Override
    public double getZ() {
        return this.coords.z;
    }

    @Override
    public void setAltLoc(Character c) {
        this.altLoc = c == null ? (char)'\u0000' : c.charValue();
    }

    @Override
    public Character getAltLoc() {
        if (this.altLoc == '\u0000') {
            return null;
        }
        return Character.valueOf(this.altLoc);
    }

    public String toString() {
        return this.name + " " + this.element + " " + this.pdbserial + " " + this.coords.x + " " + this.coords.y + " " + this.coords.z;
    }

    @Override
    public void setOccupancy(float occu) {
        this.occupancy = occu;
    }

    @Override
    public float getOccupancy() {
        return this.occupancy;
    }

    @Override
    public void setTempFactor(float temp) {
        this.tempfactor = temp;
    }

    @Override
    public float getTempFactor() {
        return this.tempfactor;
    }

    @Override
    public Object clone() {
        AtomImpl n = new AtomImpl();
        n.setOccupancy(this.getOccupancy());
        n.setTempFactor(this.getTempFactor());
        n.altLoc = this.altLoc;
        n.setCharge(this.getCharge());
        double[] coords = this.getCoords();
        n.setX(coords[0]);
        n.setY(coords[1]);
        n.setZ(coords[2]);
        n.setPDBserial(this.getPDBserial());
        n.setName(this.getName());
        n.setElement(this.getElement());
        return n;
    }

    @Override
    public void setGroup(Group parent) {
        this.parent = parent;
    }

    @Override
    public Group getGroup() {
        return this.parent;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public void setElement(Element e) {
        this.element = e;
    }

    @Override
    public String toPDB() {
        return FileConvert.toPDB(this);
    }

    @Override
    public void toPDB(StringBuffer buf) {
        FileConvert.toPDB((Atom)this, buf);
    }

    @Override
    public List<Bond> getBonds() {
        return this.bonds;
    }

    @Override
    public boolean hasBond(Atom other) {
        if (this.bonds == null) {
            return false;
        }
        for (Bond b : this.bonds) {
            if (!b.getAtomA().equals(other) && !b.getAtomB().equals(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setBonds(List<Bond> bonds) {
        this.bonds = bonds;
    }

    @Override
    public void addBond(Bond bond) {
        if (this.bonds == null) {
            this.bonds = new ArrayList<Bond>(3);
        }
        this.bonds.add(bond);
    }

    @Override
    public short getCharge() {
        return this.charge;
    }

    @Override
    public void setCharge(short inputCharge) {
        this.charge = inputCharge;
    }
}

