/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.client;

import java.util.Objects;
import org.biojava.nbio.structure.PdbId;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.client.StructureName;

public class PdbPair
implements Comparable<PdbPair> {
    private StructureName name1;
    private StructureName name2;

    public PdbPair(String name1, String name2) {
        this(new StructureName(Objects.requireNonNull(name1)), new StructureName(Objects.requireNonNull(name1)));
    }

    public PdbPair(StructureName name1, StructureName name2) {
        this.name1 = Objects.requireNonNull(name1);
        this.name2 = Objects.requireNonNull(name2);
    }

    public String getName1() {
        return this.name1.getIdentifier();
    }

    public void setName1(String name1) {
        this.name1 = new StructureName(Objects.requireNonNull(name1));
    }

    public String getName2() {
        return this.name2.getIdentifier();
    }

    public void setName2(String name2) {
        this.name2 = new StructureName(Objects.requireNonNull(name2));
    }

    public String toString() {
        return "PdbPair [name1=" + this.name1 + ", name2=" + this.name2 + "]";
    }

    public int hashCode() {
        return Objects.hashCode(this.name1) + Objects.hashCode(this.name2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PdbPair other = (PdbPair)obj;
        return this.name1.equals(other.name1) && this.name2.equals(other.name2) || this.name1.equals(other.name2) && this.name2.equals(other.name1);
    }

    @Override
    public int compareTo(PdbPair o) {
        if (this.equals(o)) {
            return 0;
        }
        int c = this.name1.compareTo(o.name1);
        if (c != 0) {
            return c;
        }
        return this.name2.compareTo(o.name2);
    }

    public String getPDBCode1() throws StructureException {
        PdbId pdbId = this.name1.getPdbId();
        return pdbId == null ? null : pdbId.getId();
    }

    @Deprecated
    public String getPDBCode2() throws StructureException {
        PdbId pdbId = this.name2.getPdbId();
        return pdbId == null ? null : pdbId.getId();
    }

    public PdbId getPdbId1() throws StructureException {
        return this.name1.getPdbId();
    }

    public PdbId getPdbId2() throws StructureException {
        return this.name2.getPdbId();
    }

    public String getChainId1() {
        return this.name1.getChainId();
    }

    public String getChainId2() {
        return this.name2.getChainId();
    }

    public PdbPair getReverse() {
        return new PdbPair(this.name2, this.name1);
    }
}

