/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.geometry;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.biojava.nbio.structure.symmetry.geometry.Polyhedron;

public class Prism
implements Polyhedron {
    private int n = 3;
    private double circumscribedRadius = 1.0;
    private double height = 1.0;

    public Prism(int n) {
        this.n = n;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    @Override
    public double getCirumscribedRadius() {
        return this.circumscribedRadius;
    }

    public void setCirumscribedRadius(double cirumscribedRadius) {
        this.circumscribedRadius = cirumscribedRadius;
    }

    public double getInscribedRadius() {
        double side = Prism.getSideLengthFromCircumscribedRadius(this.circumscribedRadius, this.n);
        return Prism.getInscribedRadiusFromSideLength(side, this.n);
    }

    public void setInscribedRadius(double radius) {
        double side = Prism.getSideLengthFromInscribedRadius(radius, this.n);
        this.circumscribedRadius = Prism.getCircumscribedRadiusFromSideLength(side, this.n);
    }

    @Override
    public Point3d[] getVertices() {
        Point3d[] polygon = new Point3d[2 * this.n];
        Matrix3d m = new Matrix3d();
        Point3d center = new Point3d(0.0, 0.0, this.height / 2.0);
        for (int i = 0; i < this.n; ++i) {
            polygon[i] = new Point3d(0.0, this.circumscribedRadius, 0.0);
            m.rotZ((double)(i * 2) * Math.PI / (double)this.n);
            m.transform((Tuple3d)polygon[i]);
            polygon[this.n + i] = new Point3d(polygon[i]);
            polygon[i].sub((Tuple3d)center);
            polygon[this.n + i].add((Tuple3d)center);
        }
        return polygon;
    }

    @Override
    public List<int[]> getLineLoops() {
        int i;
        ArrayList<int[]> list = new ArrayList<int[]>();
        int[] l1 = new int[2 * this.n + 2];
        for (i = 0; i < this.n; ++i) {
            l1[i] = i;
        }
        l1[this.n] = 0;
        for (i = 0; i < this.n; ++i) {
            l1[this.n + i + 1] = this.n + i;
        }
        l1[2 * this.n + 1] = l1[this.n + 1];
        list.add(l1);
        for (i = 1; i < this.n; ++i) {
            int[] l2 = new int[]{i, this.n + i};
            list.add(l2);
        }
        return list;
    }

    public static Point3d[] getPolygonVertices(int n, double radius, Point3d center) {
        Point3d[] polygon = new Point3d[n];
        Matrix3d m = new Matrix3d();
        for (int i = 0; i < n; ++i) {
            polygon[i] = new Point3d(0.0, radius, 0.0);
            m.rotZ((double)(i * 2) * Math.PI / (double)n);
            m.transform((Tuple3d)polygon[i]);
            polygon[i].add((Tuple3d)center);
        }
        return polygon;
    }

    @Override
    public int getViewCount() {
        return 4;
    }

    @Override
    public String getViewName(int index) {
        Object name;
        switch (index) {
            case 0: {
                name = "Front C" + this.n + " axis";
                break;
            }
            case 1: {
                name = "Side edge-centered";
                break;
            }
            case 2: {
                name = "Side face-centered";
                break;
            }
            case 3: {
                name = "Back C" + this.n + " axis";
                break;
            }
            default: {
                throw new IllegalArgumentException("getViewMatrix: index out of range:" + index);
            }
        }
        return name;
    }

    @Override
    public Matrix3d getViewMatrix(int index) {
        Matrix3d m = new Matrix3d();
        switch (index) {
            case 0: {
                m.setIdentity();
                break;
            }
            case 1: {
                m.rotX(1.5707963267948966);
                break;
            }
            case 2: {
                m.rotY(Math.PI / (double)this.n);
                Matrix3d m1 = new Matrix3d();
                m1.rotX(1.5707963267948966);
                m.mul(m1);
                break;
            }
            case 3: {
                m.set(Prism.flipX());
                break;
            }
            default: {
                throw new IllegalArgumentException("getViewMatrix: index out of range:" + index);
            }
        }
        return m;
    }

    private static double getSideLengthFromInscribedRadius(double radius, int n) {
        if (n == 2) {
            return radius;
        }
        return radius * 2.0 * Math.tan(Math.PI / (double)n);
    }

    private static double getInscribedRadiusFromSideLength(double length, int n) {
        if (n == 2) {
            return length;
        }
        return length / (2.0 * Math.tan(Math.PI / (double)n));
    }

    private static double getSideLengthFromCircumscribedRadius(double radius, int n) {
        if (n == 2) {
            return radius;
        }
        return radius * (2.0 * Math.sin(Math.PI / (double)n));
    }

    private static double getCircumscribedRadiusFromSideLength(double length, int n) {
        if (n == 2) {
            return length;
        }
        return length / (2.0 * Math.sin(Math.PI / (double)n));
    }

    private static Matrix3d flipX() {
        Matrix3d rot = new Matrix3d();
        rot.m00 = 1.0;
        rot.m11 = -1.0;
        rot.m22 = -1.0;
        return rot;
    }
}

