/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.biojava.nbio.structure.cluster.SubunitCluster;

public class Stoichiometry {
    private String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private StringOverflowStrategy strategy = StringOverflowStrategy.CYCLE;
    private Function<List<SubunitCluster>, String> customStringGenerator = null;
    private List<SubunitCluster> orderedClusters = new ArrayList<SubunitCluster>();

    private Stoichiometry() {
    }

    public Stoichiometry(List<SubunitCluster> clusters) {
        this(clusters, StringOverflowStrategy.CYCLE, true);
    }

    public Stoichiometry(List<SubunitCluster> clusters, boolean resetAlphas) {
        this(clusters, StringOverflowStrategy.CYCLE, resetAlphas);
    }

    public Stoichiometry(List<SubunitCluster> clusters, StringOverflowStrategy strategy) {
        this(clusters, strategy, true);
    }

    public Stoichiometry(List<SubunitCluster> clusters, StringOverflowStrategy strategy, boolean resetAlphas) {
        this.strategy = strategy;
        this.orderedClusters = clusters.stream().sorted(Comparator.comparing(SubunitCluster::size).reversed()).collect(Collectors.toList());
        if (resetAlphas) {
            this.doResetAlphas();
        }
    }

    public Stoichiometry(List<SubunitCluster> clusters, Function<List<SubunitCluster>, String> customStringGenerator) {
        this(clusters, StringOverflowStrategy.CUSTOM, false);
        this.customStringGenerator = customStringGenerator;
    }

    public void resetAlphas() {
        this.doResetAlphas();
    }

    private void doResetAlphas() {
        if (this.strategy == StringOverflowStrategy.CUSTOM) {
            return;
        }
        for (int i = 0; i < this.orderedClusters.size(); ++i) {
            this.orderedClusters.get(i).setAlpha(this.generateAlpha(i));
        }
    }

    private String generateAlpha(int clusterInd) {
        Object key;
        switch (this.strategy) {
            case CYCLE: {
                int alphabetInd = clusterInd % this.alphabet.length();
                key = this.alphabet.substring(alphabetInd, alphabetInd + 1);
                break;
            }
            case DOUBLE: {
                if (this.orderedClusters.size() > this.alphabet.length()) {
                    int alphabetInd1 = clusterInd / this.alphabet.length();
                    int alphabetInd2 = clusterInd % this.alphabet.length();
                    key = this.alphabet.substring(alphabetInd1, alphabetInd1 + 1);
                    key = (String)key + this.alphabet.substring(alphabetInd2, alphabetInd2 + 1);
                    break;
                }
                key = this.alphabet.substring(clusterInd, clusterInd + 1);
                break;
            }
            case QUESTIONMARK: {
                key = "?";
                if (clusterInd >= this.alphabet.length()) break;
                key = this.alphabet.substring(clusterInd, clusterInd + 1);
                break;
            }
            case CUSTOM: {
                throw new IllegalStateException("Alphas should be handled by the custom generator function.");
            }
            default: {
                key = "?";
                if (clusterInd >= this.alphabet.length()) break;
                key = this.alphabet.substring(clusterInd, clusterInd + 1);
            }
        }
        return key;
    }

    public List<SubunitCluster> getClusters() {
        return this.orderedClusters;
    }

    public int numberOfComponents() {
        return this.orderedClusters.size();
    }

    public Stoichiometry combineWith(Stoichiometry other) {
        LinkedHashSet<SubunitCluster> combinedClusters = new LinkedHashSet<SubunitCluster>();
        combinedClusters.addAll(this.orderedClusters);
        combinedClusters.addAll(other.orderedClusters);
        Stoichiometry combinedStoichiometry = this.strategy == StringOverflowStrategy.CUSTOM ? new Stoichiometry(new ArrayList<SubunitCluster>(combinedClusters), this.customStringGenerator) : new Stoichiometry(new ArrayList<SubunitCluster>(combinedClusters), this.strategy, false);
        return combinedStoichiometry;
    }

    public Stoichiometry getComponent(int i) {
        return new Stoichiometry(Collections.singletonList(this.orderedClusters.get(i)), this.strategy, false);
    }

    public StringOverflowStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(StringOverflowStrategy strategy) {
        if (strategy == StringOverflowStrategy.CUSTOM) {
            throw new IllegalArgumentException("Set this strategy by providing a function of the type Function<List<SubunitCluster>,String>.");
        }
        if (this.strategy != strategy) {
            this.strategy = strategy;
            if (this.orderedClusters.size() > this.alphabet.length()) {
                this.doResetAlphas();
            }
        }
    }

    public void setCustomStringGenerator(Function<List<SubunitCluster>, String> customStringGenerator) {
        this.strategy = StringOverflowStrategy.CUSTOM;
        this.customStringGenerator = customStringGenerator;
    }

    public String getAlphabet() {
        return this.alphabet;
    }

    public void setAlphabet(String alphabet) {
        this.alphabet = alphabet;
        this.doResetAlphas();
    }

    public String toString() {
        if (this.strategy == StringOverflowStrategy.CUSTOM) {
            if (this.customStringGenerator == null) {
                throw new IllegalStateException("The strategy is CUSTOM, yet the string generator function is not defined.");
            }
            return this.customStringGenerator.apply(this.orderedClusters);
        }
        StringBuilder formula = new StringBuilder();
        this.orderedClusters.forEach(r -> {
            formula.append(r.getAlpha());
            if (r.getAlpha().length() > 1 || r.size() > 1) {
                formula.append(r.size());
            }
        });
        return formula.toString();
    }

    public boolean isPseudoStoichiometric() {
        for (SubunitCluster c : this.orderedClusters) {
            if (!c.isPseudoStoichiometric()) continue;
            return true;
        }
        return false;
    }

    public static enum StringOverflowStrategy {
        QUESTIONMARK,
        CYCLE,
        DOUBLE,
        CUSTOM;

    }
}

