/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.xtal;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.jama.EigenvalueDecomposition;
import org.biojava.nbio.structure.jama.Matrix;
import org.biojava.nbio.structure.xtal.BravaisLattice;
import org.biojava.nbio.structure.xtal.SymoplibParser;
import org.biojava.nbio.structure.xtal.io.TransfAlgebraicAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="SpaceGroup", namespace="http://www.biojava.org")
@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
public class SpaceGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SpaceGroup.class);
    private static final Pattern splitPat1 = Pattern.compile("((?:[+-]?[XYZ])+)([+-][0-9/.]+)");
    private static final Pattern splitPat2 = Pattern.compile("([+-]?[0-9/.]+)((?:[+-][XYZ])+)");
    private static final Pattern coordPat = Pattern.compile("(?:([+-])?([XYZ]))+?");
    private static final Pattern transCoefPat = Pattern.compile("([-+]?[0-9.]+)(?:/([0-9.]+))?");
    private static final Pattern nonEnantPat = Pattern.compile("[-abcmnd]");
    protected static final double DELTA = 1.0E-7;
    private int id;
    private int multiplicity;
    private int primitiveMultiplicity;
    private String shortSymbol;
    private String altShortSymbol;
    private List<Matrix4d> transformations;
    private List<String> transfAlgebraic;
    private Vector3d[] cellTranslations;
    private AxisAngle4d[] axisAngles;
    private int[] axisTypes;
    private BravaisLattice bravLattice;

    private SpaceGroup() {
    }

    public SpaceGroup(int id, int multiplicity, int primitiveMultiplicity, String shortSymbol, String altShortSymbol, BravaisLattice bravLattice) {
        this.id = id;
        this.multiplicity = multiplicity;
        this.primitiveMultiplicity = primitiveMultiplicity;
        this.shortSymbol = shortSymbol;
        this.altShortSymbol = altShortSymbol;
        this.transformations = new ArrayList<Matrix4d>(multiplicity);
        this.transfAlgebraic = new ArrayList<String>(multiplicity);
        this.cellTranslations = new Vector3d[multiplicity / primitiveMultiplicity];
        this.bravLattice = bravLattice;
    }

    public static SpaceGroup parseSpaceGroup(String shortName) {
        return SymoplibParser.getSpaceGroup(shortName);
    }

    public void addTransformation(String transfAlgebraic) {
        this.transfAlgebraic.add(transfAlgebraic);
        this.transformations.add(SpaceGroup.getMatrixFromAlgebraic(transfAlgebraic));
    }

    protected void initializeCellTranslations() {
        if (this.cellTranslations != null && this.cellTranslations.length > 0) {
            return;
        }
        this.cellTranslations = new Vector3d[this.multiplicity / this.primitiveMultiplicity];
        this.cellTranslations[0] = new Vector3d(0.0, 0.0, 0.0);
        if (this.transformations == null) {
            logger.warn("transformations == null" + this.toXML());
        }
        if (this.multiplicity == this.primitiveMultiplicity) {
            return;
        }
        int fold = this.multiplicity / this.primitiveMultiplicity;
        for (int n = 1; n < fold; ++n) {
            if (this.transformations.size() < n * this.primitiveMultiplicity) {
                logger.warn("WARNING number of transformations < " + n * this.primitiveMultiplicity);
                logger.warn(this.toXML());
            }
            Matrix4d t = this.transformations.get(n * this.primitiveMultiplicity);
            this.cellTranslations[n] = new Vector3d(t.m03, t.m13, t.m23);
        }
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    public int getPrimitiveMultiplicity() {
        return this.primitiveMultiplicity;
    }

    public Vector3d[] getCellTranslations() {
        return this.cellTranslations;
    }

    public Vector3d getCellTranslation(int i) {
        return this.cellTranslations[i];
    }

    public static Matrix4d getMatrixFromAlgebraic(String transfAlgebraic) {
        String[] parts = transfAlgebraic.toUpperCase().split(",");
        double[] xCoef = SpaceGroup.convertAlgebraicStrToCoefficients(parts[0].trim());
        double[] yCoef = SpaceGroup.convertAlgebraicStrToCoefficients(parts[1].trim());
        double[] zCoef = SpaceGroup.convertAlgebraicStrToCoefficients(parts[2].trim());
        Matrix4d mat = new Matrix4d();
        mat.setIdentity();
        mat.setRotation(new Matrix3d(xCoef[0], xCoef[1], xCoef[2], yCoef[0], yCoef[1], yCoef[2], zCoef[0], zCoef[1], zCoef[2]));
        mat.setTranslation(new Vector3d(xCoef[3], yCoef[3], zCoef[3]));
        return mat;
    }

    private static double[] convertAlgebraicStrToCoefficients(String algString) {
        String letters = null;
        String noLetters = null;
        Matcher m = splitPat1.matcher(algString);
        if (m.matches()) {
            letters = m.group(1);
            noLetters = m.group(2);
        } else {
            m = splitPat2.matcher(algString);
            if (m.matches()) {
                letters = m.group(2);
                noLetters = m.group(1);
            } else {
                letters = algString;
            }
        }
        double[] coefficients = new double[4];
        m = coordPat.matcher(letters);
        while (m.find()) {
            String coord;
            String sign = "";
            if (m.group(1) != null) {
                sign = m.group(1);
            }
            double s = 1.0;
            if (sign.equals("-")) {
                s = -1.0;
            }
            if ((coord = m.group(2)).equals("X")) {
                coefficients[0] = s;
                continue;
            }
            if (coord.equals("Y")) {
                coefficients[1] = s;
                continue;
            }
            if (!coord.equals("Z")) continue;
            coefficients[2] = s;
        }
        if (noLetters != null) {
            m = transCoefPat.matcher(noLetters);
            if (m.matches()) {
                double num = Double.parseDouble(m.group(1));
                double den = 1.0;
                if (m.group(2) != null) {
                    den = Double.parseDouble(m.group(2));
                }
                coefficients[3] = num / den;
            }
        } else {
            coefficients[3] = 0.0;
        }
        return coefficients;
    }

    public int getId() {
        return this.id;
    }

    public String getShortSymbol() {
        return this.shortSymbol;
    }

    public String getAltShortSymbol() {
        return this.altShortSymbol;
    }

    public List<Matrix4d> getTransformations() {
        ArrayList<Matrix4d> transfs = new ArrayList<Matrix4d>();
        for (int i = 1; i < this.transformations.size(); ++i) {
            transfs.add(this.transformations.get(i));
        }
        return transfs;
    }

    private void calcRotAxesAndAngles() {
        this.axisAngles = new AxisAngle4d[this.multiplicity];
        this.axisAngles[0] = new AxisAngle4d(new Vector3d(0.0, 0.0, 0.0), 0.0);
        for (int i = 1; i < this.transformations.size(); ++i) {
            Matrix3d r = new Matrix3d(this.transformations.get((int)i).m00, this.transformations.get((int)i).m01, this.transformations.get((int)i).m02, this.transformations.get((int)i).m10, this.transformations.get((int)i).m11, this.transformations.get((int)i).m12, this.transformations.get((int)i).m20, this.transformations.get((int)i).m21, this.transformations.get((int)i).m22);
            this.axisAngles[i] = SpaceGroup.getRotAxisAndAngle(r);
        }
    }

    private void calcAxisFoldTypes() {
        this.axisTypes = new int[this.multiplicity];
        for (int i = 0; i < this.transformations.size(); ++i) {
            this.axisTypes[i] = SpaceGroup.getRotAxisType(this.transformations.get(i));
        }
    }

    public AxisAngle4d getRotAxisAngle(int transformId) {
        if (this.axisAngles == null) {
            this.calcRotAxesAndAngles();
        }
        return this.axisAngles[transformId];
    }

    public boolean areInSameAxis(int tId1, int tId2) {
        if (tId1 == tId2) {
            return true;
        }
        if (this.axisAngles == null) {
            this.calcRotAxesAndAngles();
        }
        if (this.getAxisFoldType(tId1) == 1 && this.getAxisFoldType(tId2) == 1) {
            return true;
        }
        if (this.getAxisFoldType(tId1) < 0 || this.getAxisFoldType(tId2) < 0) {
            return false;
        }
        Vector3d axis1 = new Vector3d(this.axisAngles[tId1].x, this.axisAngles[tId1].y, this.axisAngles[tId1].z);
        Vector3d axis2 = new Vector3d(this.axisAngles[tId2].x, this.axisAngles[tId2].y, this.axisAngles[tId2].z);
        return SpaceGroup.deltaComp(axis1.angle(axis2), 0.0, 1.0E-7);
    }

    public int getAxisFoldType(int transformId) {
        if (this.axisTypes == null) {
            this.calcAxisFoldTypes();
        }
        return this.axisTypes[transformId];
    }

    public Matrix4d getTransformation(int i) {
        return this.transformations.get(i);
    }

    public String getTransfAlgebraic(int i) {
        return this.transfAlgebraic.get(i);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SpaceGroup)) {
            return false;
        }
        SpaceGroup other = (SpaceGroup)o;
        return other.getId() == this.getId();
    }

    public int getNumOperators() {
        return this.transformations.size();
    }

    public static String getAlgebraicFromMatrix(Matrix4d m) {
        String x = SpaceGroup.formatAlg(m.m00, m.m01, m.m02, m.m03);
        String y = SpaceGroup.formatAlg(m.m10, m.m11, m.m12, m.m13);
        String z = SpaceGroup.formatAlg(m.m20, m.m21, m.m22, m.m23);
        String alg = x + "," + y + "," + z;
        return alg;
    }

    private static String formatAlg(double xcoef, double ycoef, double zcoef, double trans) {
        boolean[] leading = new boolean[]{false, false, false};
        if (xcoef != 0.0) {
            leading[0] = true;
        } else if (ycoef != 0.0) {
            leading[1] = true;
        } else if (zcoef != 0.0) {
            leading[2] = true;
        }
        String x = SpaceGroup.deltaComp(xcoef, 0.0, 1.0E-7) ? "" : SpaceGroup.formatCoef(xcoef, leading[0]) + "X";
        String y = SpaceGroup.deltaComp(ycoef, 0.0, 1.0E-7) ? "" : SpaceGroup.formatCoef(ycoef, leading[1]) + "Y";
        String z = SpaceGroup.deltaComp(zcoef, 0.0, 1.0E-7) ? "" : SpaceGroup.formatCoef(zcoef, leading[2]) + "Z";
        String t = SpaceGroup.deltaComp(trans, 0.0, 1.0E-7) ? "" : SpaceGroup.formatTransCoef(trans);
        return x + y + z + t;
    }

    private static String formatCoef(double c, boolean leading) {
        if (leading) {
            return SpaceGroup.deltaComp(Math.abs(c), 1.0, 1.0E-7) ? (c > 0.0 ? "" : "-") : String.format(Locale.US, "%4.2f", c);
        }
        return SpaceGroup.deltaComp(Math.abs(c), 1.0, 1.0E-7) ? (c > 0.0 ? "+" : "-") : String.format(Locale.US, "%+4.2f", c);
    }

    private static String formatTransCoef(double c) {
        int den;
        int num;
        if (Math.abs(Math.rint(c) - c) < 1.0E-7) {
            return String.format("%+d", (int)Math.rint(c));
        }
        int floor = (int)Math.floor(c);
        double decPart = c - (double)floor;
        if (SpaceGroup.deltaComp(decPart, 0.3333333, 1.0E-7)) {
            num = 1;
            den = 3;
        } else if (SpaceGroup.deltaComp(decPart, 0.6666667, 1.0E-7)) {
            num = 2;
            den = 3;
        } else if (SpaceGroup.deltaComp(decPart, 0.25, 1.0E-7)) {
            num = 1;
            den = 4;
        } else if (SpaceGroup.deltaComp(decPart, 0.5, 1.0E-7)) {
            num = 1;
            den = 2;
        } else if (SpaceGroup.deltaComp(decPart, 0.75, 1.0E-7)) {
            num = 3;
            den = 4;
        } else if (SpaceGroup.deltaComp(decPart, 0.1666667, 1.0E-7)) {
            num = 1;
            den = 6;
        } else if (SpaceGroup.deltaComp(decPart, 0.8333333, 1.0E-7)) {
            num = 5;
            den = 6;
        } else {
            num = 0;
            den = 0;
        }
        num = floor * den + num;
        return String.format("%+d/%d", num, den);
    }

    protected static boolean deltaComp(double d1, double d2, double delta) {
        return Math.abs(d1 - d2) < delta;
    }

    public BravaisLattice getBravLattice() {
        return this.bravLattice;
    }

    public boolean isEnantiomorphic() {
        Matcher m = nonEnantPat.matcher(this.shortSymbol);
        return !m.find();
    }

    public static AxisAngle4d getRotAxisAndAngle(Matrix3d m) {
        int indexOfEv1;
        double determinant = m.determinant();
        if (!(Math.abs(determinant) - 1.0 < 1.0E-7)) {
            throw new IllegalArgumentException("Given matrix is not a rotation matrix");
        }
        AxisAngle4d axisAndAngle = new AxisAngle4d(new Vector3d(0.0, 0.0, 0.0), 0.0);
        double[] d = new double[]{m.m00, m.m10, m.m20, m.m01, m.m11, m.m21, m.m02, m.m12, m.m22};
        Matrix r = new Matrix(d, 3);
        if (!SpaceGroup.deltaComp(r.det(), 1.0, 1.0E-7)) {
            return axisAndAngle;
        }
        EigenvalueDecomposition evd = new EigenvalueDecomposition(r);
        Matrix eval = evd.getD();
        if (SpaceGroup.deltaComp(eval.get(0, 0), 1.0, 1.0E-7) && SpaceGroup.deltaComp(eval.get(1, 1), 1.0, 1.0E-7) && SpaceGroup.deltaComp(eval.get(2, 2), 1.0, 1.0E-7)) {
            return axisAndAngle;
        }
        for (indexOfEv1 = 0; indexOfEv1 < 3 && !SpaceGroup.deltaComp(eval.get(indexOfEv1, indexOfEv1), 1.0, 1.0E-7); ++indexOfEv1) {
        }
        Matrix evec = evd.getV();
        axisAndAngle.set(new Vector3d(evec.get(0, indexOfEv1), evec.get(1, indexOfEv1), evec.get(2, indexOfEv1)), Math.acos((eval.trace() - 1.0) / 2.0));
        return axisAndAngle;
    }

    public static int getRotAxisType(Matrix4d m) {
        int axisType;
        block16: {
            int trace;
            block15: {
                axisType = 0;
                Matrix3d rot = new Matrix3d(m.m00, m.m01, m.m02, m.m10, m.m11, m.m12, m.m20, m.m21, m.m22);
                double determinant = rot.determinant();
                if (!SpaceGroup.deltaComp(determinant, 1.0, 1.0E-7) && !SpaceGroup.deltaComp(determinant, -1.0, 1.0E-7)) {
                    throw new IllegalArgumentException("Given matrix does not seem to be a rotation matrix.");
                }
                trace = (int)(rot.m00 + rot.m11 + rot.m22);
                if (!(determinant > 0.0)) break block15;
                switch (trace) {
                    case 3: {
                        axisType = 1;
                        break block16;
                    }
                    case -1: {
                        axisType = 2;
                        break block16;
                    }
                    case 0: {
                        axisType = 3;
                        break block16;
                    }
                    case 1: {
                        axisType = 4;
                        break block16;
                    }
                    case 2: {
                        axisType = 6;
                        break block16;
                    }
                    default: {
                        throw new RuntimeException("Trace of transform does not correspond to one of the expected types. This is most likely a bug");
                    }
                }
            }
            switch (trace) {
                case -3: {
                    axisType = -1;
                    break;
                }
                case 1: {
                    axisType = -2;
                    break;
                }
                case 0: {
                    axisType = -3;
                    break;
                }
                case -1: {
                    axisType = -4;
                    break;
                }
                case -2: {
                    axisType = -6;
                    break;
                }
                default: {
                    throw new RuntimeException("Trace of transform does not correspond to one of the expected types. This is most likely a bug");
                }
            }
        }
        return axisType;
    }

    public String toString() {
        return this.getShortSymbol();
    }

    public String toXML() {
        JAXBContext jaxbContextStringSortedSet = null;
        try {
            jaxbContextStringSortedSet = JAXBContext.newInstance((Class[])new Class[]{SpaceGroup.class});
        }
        catch (JAXBException e) {
            logger.error("Error converting to XML", (Throwable)e);
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        try {
            Marshaller m = jaxbContextStringSortedSet.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)this, (OutputStream)ps);
        }
        catch (JAXBException e) {
            logger.error("Error converting to XML", (Throwable)e);
        }
        return baos.toString();
    }

    @XmlJavaTypeAdapter(value=TransfAlgebraicAdapter.class)
    public List<String> getTransfAlgebraic() {
        return this.transfAlgebraic;
    }

    public void setTransfAlgebraic(List<String> transfAlgebraic) {
        if (this.transformations == null || this.transformations.size() == 0) {
            this.transformations = new ArrayList<Matrix4d>(transfAlgebraic.size());
        }
        if (this.transfAlgebraic == null || this.transfAlgebraic.size() == 0) {
            this.transfAlgebraic = new ArrayList<String>(transfAlgebraic.size());
        }
        for (String transf : transfAlgebraic) {
            this.addTransformation(transf);
        }
    }

    public int[] getAxisTypes() {
        return this.axisTypes;
    }

    public void setAxisTypes(int[] axisTypes) {
        this.axisTypes = axisTypes;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public static Pattern getSplitpat1() {
        return splitPat1;
    }

    public static Pattern getSplitpat2() {
        return splitPat2;
    }

    public static Pattern getCoordpat() {
        return coordPat;
    }

    public static Pattern getTranscoefpat() {
        return transCoefPat;
    }

    public static Pattern getNonenantpat() {
        return nonEnantPat;
    }

    public static double getDelta() {
        return 1.0E-7;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setMultiplicity(int multiplicity) {
        this.multiplicity = multiplicity;
    }

    public void setPrimitiveMultiplicity(int primitiveMultiplicity) {
        this.primitiveMultiplicity = primitiveMultiplicity;
    }

    public void setShortSymbol(String shortSymbol) {
        this.shortSymbol = shortSymbol;
    }

    public void setAltShortSymbol(String altShortSymbol) {
        this.altShortSymbol = altShortSymbol;
    }

    public void setBravLattice(BravaisLattice bravLattice) {
        this.bravLattice = bravLattice;
    }
}

