/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.alignment.Alignments;
import org.biojava.nbio.alignment.SimpleGapPenalty;
import org.biojava.nbio.alignment.template.GapPenalty;
import org.biojava.nbio.alignment.template.PairwiseSequenceAligner;
import org.biojava.nbio.core.alignment.matrices.SubstitutionMatrixHelper;
import org.biojava.nbio.core.alignment.template.SequencePair;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.RNASequence;
import org.biojava.nbio.core.sequence.compound.AmbiguityDNACompoundSet;
import org.biojava.nbio.core.sequence.compound.AmbiguityDNARNAHybridCompoundSet;
import org.biojava.nbio.core.sequence.compound.AmbiguityRNACompoundSet;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.compound.DNACompoundSet;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.HetatomImpl;
import org.biojava.nbio.structure.NucleotideImpl;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.chem.ChemComp;
import org.biojava.nbio.structure.chem.PolymerType;
import org.biojava.nbio.structure.chem.ResidueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeqRes2AtomAligner {
    private static final Logger logger = LoggerFactory.getLogger(SeqRes2AtomAligner.class);
    private String alignmentString;

    public SeqRes2AtomAligner() {
        logger.debug("initialising SeqRes2AtomAligner");
        this.alignmentString = "";
    }

    public String getAlignmentString() {
        return this.alignmentString;
    }

    public static Chain getMatchingAtomRes(Chain seqRes, List<Chain> atomList, boolean useChainId) {
        for (Chain atomChain : atomList) {
            String atomChainId = null;
            String seqResChainId = null;
            if (useChainId) {
                atomChainId = atomChain.getId();
                seqResChainId = seqRes.getId();
            } else {
                atomChainId = atomChain.getName();
                seqResChainId = seqRes.getName();
            }
            if (!atomChainId.equals(seqResChainId)) continue;
            return atomChain;
        }
        logger.info("Could not match SEQRES chainID asymId:" + seqRes.getId() + " authId:" + seqRes.getName() + "  to ATOM chains!, size of atom chain: " + atomList.size());
        return null;
    }

    public void align(Structure s, List<Chain> seqResList) {
        List<Chain> atomList = s.getModel(0);
        for (Chain seqRes : seqResList) {
            Chain atomRes = SeqRes2AtomAligner.getMatchingAtomRes(seqRes, atomList, false);
            if (atomRes == null) continue;
            this.mapSeqresRecords(atomRes, seqRes);
        }
    }

    public void mapSeqresRecords(Chain atomRes, Chain seqRes) {
        List<Group> seqResGroups = seqRes.getAtomGroups();
        List<Group> atmResGroups = atomRes.getAtomGroups();
        logger.debug("Comparing ATOM {} ({} groups) to SEQRES {} ({} groups) ", new Object[]{atomRes.getId(), atmResGroups.size(), seqRes.getId(), seqResGroups.size()});
        List<Group> matchedGroups = this.trySimpleMatch(seqResGroups, atmResGroups);
        if (matchedGroups != null) {
            atomRes.setSeqResGroups(matchedGroups);
            return;
        }
        logger.debug("Could not map SEQRES to ATOM records easily, need to align...");
        int numAminosSeqres = seqRes.getAtomGroups(GroupType.AMINOACID).size();
        int numNucleotidesSeqres = seqRes.getAtomGroups(GroupType.NUCLEOTIDE).size();
        if (numAminosSeqres < 1) {
            if (numNucleotidesSeqres > 1) {
                logger.debug("SEQRES chain {} is a nucleotide chain ({} nucleotides), aligning nucleotides...", (Object)seqRes.getId(), (Object)numNucleotidesSeqres);
                this.alignNucleotideChains(seqRes, atomRes);
                return;
            }
            logger.debug("SEQRES chain {} contains {} amino acids and {} nucleotides, ignoring...", new Object[]{seqRes.getId(), numAminosSeqres, numNucleotidesSeqres});
            return;
        }
        if (atomRes.getAtomGroups(GroupType.AMINOACID).size() < 1) {
            logger.debug("ATOM chain {} does not contain amino acids, ignoring...", (Object)atomRes.getId());
            return;
        }
        logger.debug("Proceeding to do protein alignment for chain {}", (Object)atomRes.getId());
        boolean noMatchFound = this.alignProteinChains(seqResGroups, atomRes.getAtomGroups());
        if (!noMatchFound) {
            atomRes.setSeqResGroups(seqResGroups);
        }
    }

    private void alignNucleotideChains(Chain seqRes, Chain atomRes) {
        if (atomRes.getAtomGroups(GroupType.NUCLEOTIDE).size() < 1) {
            logger.debug("ATOM chain {} does not contain nucleotides, ignoring...", (Object)atomRes.getId());
            return;
        }
        logger.debug("Alignment for chain {}", (Object)atomRes.getId());
        List<Group> seqResGroups = seqRes.getAtomGroups();
        boolean noMatchFound = this.alignNucleotideGroups(seqResGroups, atomRes.getAtomGroups());
        if (!noMatchFound) {
            atomRes.setSeqResGroups(seqResGroups);
        }
    }

    private List<Group> trySimpleMatch(List<Group> seqResGroups, List<Group> atmResGroups) {
        ArrayList newSeqResGroups = (ArrayList)((ArrayList)seqResGroups).clone();
        boolean startAt1 = true;
        for (int atomResPos = 0; atomResPos < atmResGroups.size(); ++atomResPos) {
            Group seqResGroup;
            Group atomResGroup = atmResGroups.get(atomResPos);
            if (atomResGroup.isWater()) continue;
            ResidueNumber atomResNum = atomResGroup.getResidueNumber();
            int seqResPos = atomResNum.getSeqNum();
            if (seqResPos < 0) {
                logger.debug("ATOM residue number < 0 : {}", (Object)seqResPos);
                return null;
            }
            if (seqResPos == 0) {
                seqResGroup = seqResGroups.get(0);
                if (seqResGroup.getPDBName().equals(atomResGroup.getPDBName())) {
                    startAt1 = false;
                } else {
                    logger.debug("SEQRES position 1 ({}) does not match ATOM PDB res num 0 ({})", (Object)seqResGroup.getPDBName(), (Object)atomResGroup.getPDBName());
                    return null;
                }
            }
            if (startAt1) {
                --seqResPos;
            }
            if (startAt1 && seqResPos >= seqResGroups.size()) {
                if (atomResGroup instanceof AminoAcid) {
                    logger.debug(" ATOM residue nr: " + seqResPos + " > seqres! " + seqResGroups.size() + " " + atomResGroup);
                    return null;
                }
                if (!(atomResGroup instanceof NucleotideImpl)) continue;
                logger.debug(" NUCLEOTIDE residue nr: " + seqResPos + " > seqres! " + seqResGroups.size() + " " + atomResGroup);
                return null;
            }
            if (seqResPos >= seqResGroups.size()) {
                logger.debug("seqres groups don't match atom indices {}", (Object)seqResPos);
                if (!(atomResGroup instanceof AminoAcid)) continue;
                return null;
            }
            seqResGroup = seqResGroups.get(seqResPos);
            if (!seqResGroup.getPDBName().trim().equals(atomResGroup.getPDBName().trim())) {
                logger.debug("Mismatch of SEQRES pos " + seqResPos + " and ATOM record: " + atomResGroup + " | " + seqResGroup);
                return null;
            }
            Group replacedGroup = newSeqResGroups.set(seqResPos, atomResGroup);
            logger.debug("Merging index {}: replaced seqres group {} ({}) with atom group {} ({})", new Object[]{seqResPos, replacedGroup.getResidueNumber(), replacedGroup.getPDBName(), atomResGroup.getResidueNumber(), atomResGroup.getPDBName()});
        }
        return newSeqResGroups;
    }

    public static String getFullAtomSequence(List<Group> groups, Map<Integer, Integer> positionIndex, boolean isNucleotideChain) {
        StringBuffer sequence = new StringBuffer();
        int seqIndex = 0;
        for (int i = 0; i < groups.size(); ++i) {
            Serializable a;
            Group g = groups.get(i);
            if (g instanceof AminoAcid) {
                a = (AminoAcid)g;
                char oneLetter = a.getAminoType().charValue();
                if (oneLetter == '?') {
                    oneLetter = 'X';
                }
                positionIndex.put(seqIndex, i);
                sequence.append(oneLetter);
                ++seqIndex;
                continue;
            }
            if (g.isWater() || g.size() == 1 && ((a = g.getAtom(0)) == null || a.getElement().isMetal())) continue;
            ChemComp cc = g.getChemComp();
            if (cc == null) {
                logger.debug("No chem comp available for group {}", (Object)g.toString());
                continue;
            }
            if (ResidueType.lPeptideLinking.equals(cc.getResidueType()) || PolymerType.PROTEIN_ONLY.contains(cc.getPolymerType()) || PolymerType.POLYNUCLEOTIDE_ONLY.contains(cc.getPolymerType())) {
                String c = cc.getOneLetterCode();
                if ("?".equals(c)) {
                    c = isNucleotideChain && PolymerType.POLYNUCLEOTIDE_ONLY.contains(cc.getPolymerType()) ? "N" : "X";
                }
                if (c.length() > 1) {
                    logger.info("Group '{}' maps to more than 1 standard aminoacid: {}.", (Object)g.toString(), (Object)c);
                }
                for (int cIdx = 0; cIdx < c.length(); ++cIdx) {
                    positionIndex.put(seqIndex, i);
                    sequence.append(c.charAt(cIdx));
                    ++seqIndex;
                }
                continue;
            }
            logger.debug("Group {} is not lPeptideLinked, nor PROTEIN_ONLY, nor POLYNUCLEOTIDE_ONLY", (Object)g.toString());
        }
        return sequence.toString();
    }

    private boolean alignNucleotideGroups(List<Group> seqRes, List<Group> atomRes) {
        SubstitutionMatrix matrix;
        SimpleGapPenalty penalty;
        PairwiseSequenceAligner smithWaterman;
        SequencePair pair;
        HashMap<Integer, Integer> seqresIndexPosition = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> atomIndexPosition = new HashMap<Integer, Integer>();
        String seq1 = SeqRes2AtomAligner.getFullAtomSequence(seqRes, seqresIndexPosition, true);
        String seq2 = SeqRes2AtomAligner.getFullAtomSequence(atomRes, atomIndexPosition, true);
        if (seq1.isEmpty() || seq2.isEmpty()) {
            logger.warn("Could not align nucleotide sequences, at least one of them is empty");
            return true;
        }
        logger.debug("align seq1 (" + seq1.length() + ") " + seq1);
        logger.debug("align seq2 (" + seq2.length() + ") " + seq2);
        RNASequence s1 = this.getNucleotideSequence(seq1);
        RNASequence s2 = this.getNucleotideSequence(seq2);
        if (s1 == null || s2 == null) {
            return true;
        }
        if (!s1.getCompoundSet().equals(s2.getCompoundSet())) {
            if (!s1.getCompoundSet().equals(AmbiguityRNACompoundSet.getRNACompoundSet())) {
                try {
                    s1 = new RNASequence(seq1, (CompoundSet)AmbiguityRNACompoundSet.getRNACompoundSet());
                }
                catch (CompoundNotFoundException ex) {
                    logger.warn("Could not align DNA and RNA compound sets: " + seq1);
                    return true;
                }
            }
            if (!s2.getCompoundSet().equals(AmbiguityRNACompoundSet.getRNACompoundSet())) {
                try {
                    s2 = new RNASequence(seq2, (CompoundSet)AmbiguityRNACompoundSet.getRNACompoundSet());
                }
                catch (CompoundNotFoundException ex) {
                    logger.warn("Could not align DNA and RNA compound sets: " + seq2);
                    return true;
                }
            }
        }
        if ((pair = (smithWaterman = Alignments.getPairwiseAligner((Sequence)s1, s2, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.LOCAL, (GapPenalty)(penalty = new SimpleGapPenalty(8, 1)), (SubstitutionMatrix)(matrix = SubstitutionMatrixHelper.getNuc4_4()))).getPair()) == null) {
            logger.warn("Could not align nucleotide sequences. ATOM and SEQRES groups will not be aligned.");
            logger.warn("Sequences: ");
            logger.warn(seq1);
            logger.warn(seq2);
            return true;
        }
        logger.debug("Alignment:\n{}", (Object)pair.toString(100));
        boolean noMatchFound = this.mapDNAChains(seqRes, atomRes, (SequencePair<Sequence<NucleotideCompound>, NucleotideCompound>)pair, seqresIndexPosition, atomIndexPosition);
        return noMatchFound;
    }

    private Sequence<NucleotideCompound> getNucleotideSequence(String seq) {
        DNASequence s = null;
        try {
            s = new DNASequence(seq, (CompoundSet)AmbiguityDNACompoundSet.getDNACompoundSet());
        }
        catch (CompoundNotFoundException e) {
            try {
                s = new RNASequence(seq, (CompoundSet)AmbiguityRNACompoundSet.getRNACompoundSet());
            }
            catch (CompoundNotFoundException ex) {
                try {
                    s = new DNASequence(seq, (CompoundSet)AmbiguityDNARNAHybridCompoundSet.getDNARNAHybridCompoundSet());
                    logger.warn("Hybrid RNA/DNA sequence detected for sequence {}", (Object)seq);
                }
                catch (CompoundNotFoundException exc) {
                    logger.warn("Could not determine compound set (neither DNA, RNA nor hybrid) for nucleotide sequence " + seq);
                    return null;
                }
            }
        }
        return s;
    }

    private boolean alignProteinChains(List<Group> seqRes, List<Group> atomRes) {
        ProteinSequence s2;
        ProteinSequence s1;
        HashMap<Integer, Integer> seqresIndexPosition = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> atomIndexPosition = new HashMap<Integer, Integer>();
        String seq1 = SeqRes2AtomAligner.getFullAtomSequence(seqRes, seqresIndexPosition, false);
        String seq2 = SeqRes2AtomAligner.getFullAtomSequence(atomRes, atomIndexPosition, false);
        logger.debug("Protein seq1 to align (length " + seq1.length() + "): " + seq1);
        logger.debug("Protein seq2 to align (length " + seq2.length() + "): " + seq2);
        try {
            s1 = new ProteinSequence(seq1);
            s2 = new ProteinSequence(seq2);
        }
        catch (CompoundNotFoundException e) {
            logger.warn("Could not create protein sequences ({}) to align ATOM and SEQRES groups, they will remain unaligned.", (Object)e.getMessage());
            return true;
        }
        SubstitutionMatrix matrix = SubstitutionMatrixHelper.getBlosum65();
        SimpleGapPenalty penalty = new SimpleGapPenalty(8, 1);
        PairwiseSequenceAligner smithWaterman = Alignments.getPairwiseAligner((Sequence)s1, (Sequence)s2, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.LOCAL, (GapPenalty)penalty, (SubstitutionMatrix)matrix);
        SequencePair pair = smithWaterman.getPair();
        if (pair == null || pair.getLength() == 0) {
            logger.warn("Could not align protein sequences. ATOM and SEQRES groups will not be aligned.");
            logger.warn("Sequences: ");
            logger.warn(seq1);
            logger.warn(seq2);
            return true;
        }
        logger.debug("Alignment:\n{}", (Object)pair.toString(100));
        boolean noMatchFound = this.mapChains(seqRes, atomRes, (SequencePair<ProteinSequence, AminoAcidCompound>)pair, seqresIndexPosition, atomIndexPosition);
        return noMatchFound;
    }

    private boolean mapChains(List<Group> seqResGroups, List<Group> atomRes, SequencePair<ProteinSequence, AminoAcidCompound> pair, Map<Integer, Integer> seqresIndexPosition, Map<Integer, Integer> atomIndexPosition) {
        int aligLength = pair.getLength();
        boolean noMatchFound = true;
        AminoAcidCompound gapSymbol = AminoAcidCompoundSet.getAminoAcidCompoundSet().getCompoundForString("-");
        for (int i = 1; i <= aligLength; ++i) {
            Compound s = pair.getCompoundAt(1, i);
            Compound a = pair.getCompoundAt(2, i);
            int posSeq = pair.getIndexInQueryAt(i) - 1;
            int posAtom = pair.getIndexInTargetAt(i) - 1;
            if (s.equals(gapSymbol) || a.equals(gapSymbol) || !s.equals(a)) continue;
            Group s1 = seqResGroups.get(seqresIndexPosition.get(posSeq));
            Group a1 = atomRes.get(atomIndexPosition.get(posAtom));
            if (s1 == null || a1 == null) {
                logger.warn("can't map " + i + ":" + s + " " + posSeq + " " + s1 + " atom: " + posAtom + " " + a1);
                continue;
            }
            String pdbNameS = s1.getPDBName();
            String pdbNameA = a1.getPDBName();
            if (pdbNameS == null || pdbNameA == null) {
                logger.warn("null value for group.getPDBName found at {} when trying to align {} and {} {}", new Object[]{posSeq, s1, a1, posAtom});
                logger.warn("ATOM and SEQRES sequences will not be aligned.");
                return true;
            }
            if (!pdbNameA.trim().equals(pdbNameS.trim())) {
                String msg = "'" + s1 + "' (position " + posSeq + ") does not align with '" + a1 + "' (position " + posAtom + "), should be: " + s + " : " + a;
                if (s1.getType().equals((Object)HetatomImpl.type) && a1.getType().equals((Object)HetatomImpl.type)) {
                    logger.info(msg + ". They seem to be hetatoms, so ignoring mismatch.");
                } else {
                    logger.warn(msg + ". This could be a problem because they aren't both hetatoms");
                }
            }
            seqResGroups.set(seqresIndexPosition.get(posSeq), a1);
            noMatchFound = false;
        }
        if (noMatchFound) {
            logger.debug("no alignment found!");
        }
        return noMatchFound;
    }

    private boolean mapDNAChains(List<Group> seqResGroups, List<Group> atomRes, SequencePair<Sequence<NucleotideCompound>, NucleotideCompound> pair, Map<Integer, Integer> seqresIndexPosition, Map<Integer, Integer> atomIndexPosition) {
        int aligLength = pair.getLength();
        boolean noMatchFound = true;
        Compound gapSymbol = DNACompoundSet.getDNACompoundSet().getCompoundForString("-");
        for (int i = 1; i <= aligLength; ++i) {
            Compound s = pair.getCompoundAt(1, i);
            Compound a = pair.getCompoundAt(2, i);
            int posSeq = pair.getIndexInQueryAt(i) - 1;
            int posAtom = pair.getIndexInTargetAt(i) - 1;
            if (s.equals(gapSymbol) || a.equals(gapSymbol) || !s.equals(a)) continue;
            Group s1 = seqResGroups.get(seqresIndexPosition.get(posSeq));
            Group a1 = atomRes.get(atomIndexPosition.get(posAtom));
            if (s1 == null || a1 == null) {
                logger.warn("can't map " + i + ":" + s + " " + posSeq + " " + s1 + " atom: " + posAtom + " " + a1);
                continue;
            }
            String pdbNameS = s1.getPDBName();
            String pdbNameA = a1.getPDBName();
            if (pdbNameS == null || pdbNameA == null) {
                logger.warn("null value found for group.getPDBName() at " + posSeq + " when trying to align " + s1 + " and " + a1 + " " + posAtom);
                logger.warn("ATOM and SEQRES sequences will not be aligned.");
            }
            if (!pdbNameA.equals(pdbNameS) && !pdbNameA.trim().equals(pdbNameS.trim())) {
                logger.info(s1 + " " + posSeq + " does not align with " + a1 + " " + posAtom + " should be: " + s + " : " + a);
                if (s1.getType().equals((Object)HetatomImpl.type) && a1.getType().equals((Object)HetatomImpl.type)) {
                    logger.info("they seem to be hetatoms, so ignoring mismatch.");
                } else {
                    logger.warn("Could not match residues " + s1 + " " + a1);
                }
            }
            seqResGroups.set(seqresIndexPosition.get(posSeq), a1);
            noMatchFound = false;
        }
        if (noMatchFound) {
            logger.debug("no alignment found!");
        }
        return noMatchFound;
    }

    public static void storeUnAlignedSeqRes(Structure structure, List<Chain> seqResChains, boolean headerOnly) {
        if (headerOnly) {
            ArrayList<Chain> atomChains = new ArrayList<Chain>();
            for (Chain seqRes : seqResChains) {
                seqRes.setSeqResGroups(seqRes.getAtomGroups());
                seqRes.setAtomGroups(new ArrayList<Group>());
                atomChains.add(seqRes);
            }
            structure.setChains(0, atomChains);
        } else {
            for (int i = 0; i < structure.nrModels(); ++i) {
                List<Chain> atomChains = structure.getModel(i);
                if (seqResChains.isEmpty()) {
                    seqResChains = atomChains;
                }
                for (Chain seqRes : seqResChains) {
                    Chain atomRes = SeqRes2AtomAligner.getMatchingAtomRes(seqRes, atomChains, true);
                    if (atomRes != null) {
                        atomRes.setSeqResGroups(seqRes.getAtomGroups());
                        continue;
                    }
                    logger.warn("Could not find atom records for chain " + seqRes.getId());
                }
            }
        }
    }
}

