/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.quaternary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.util.MultipleAlignmentScorer;
import org.biojava.nbio.structure.align.quaternary.QsRelation;
import org.biojava.nbio.structure.cluster.Subunit;
import org.biojava.nbio.structure.cluster.SubunitCluster;

public class QsAlignResult {
    private List<SubunitCluster> clusters;
    private final List<Subunit> subunits1;
    private final List<Subunit> subunits2;
    private Map<Integer, Integer> subunitMap;
    private MultipleAlignment alignment;
    private QsRelation relation;

    public QsAlignResult(List<Subunit> subunits1, List<Subunit> subunits2) {
        this.subunits1 = subunits1;
        this.subunits2 = subunits2;
        this.subunitMap = Collections.emptyMap();
        this.relation = QsRelation.DIFFERENT;
    }

    public List<Subunit> getSubunits1() {
        return Collections.unmodifiableList(this.subunits1);
    }

    public List<Subunit> getSubunits2() {
        return Collections.unmodifiableList(this.subunits2);
    }

    public Map<Integer, Integer> getSubunitMap() {
        if (this.subunitMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.subunitMap);
    }

    public void setSubunitMap(Map<Integer, Integer> subunitMap) {
        if (Collections.max(subunitMap.keySet()) > this.subunits1.size() | Collections.max(subunitMap.values()) > this.subunits2.size()) {
            throw new IndexOutOfBoundsException("Subunit Map index higher than Subunit List size.");
        }
        this.relation = subunitMap.size() == 0 ? QsRelation.DIFFERENT : (subunitMap.keySet().size() == this.subunits1.size() ? (subunitMap.values().size() == this.subunits2.size() ? QsRelation.EQUIVALENT : QsRelation.PARTIAL_COMPLETE) : (subunitMap.values().size() == this.subunits2.size() ? QsRelation.PARTIAL_COMPLETE : QsRelation.PARTIAL_INCOMPLETE));
        this.subunitMap = subunitMap;
    }

    public int length() {
        if (this.subunitMap == null) {
            return 0;
        }
        return this.subunitMap.size();
    }

    public Matrix4d getTransform() {
        if (this.alignment == null) {
            return null;
        }
        return this.alignment.getBlockSet(0).getTransformations().get(1);
    }

    public double getRmsd() {
        if (this.alignment == null) {
            return -1.0;
        }
        if (this.alignment.getScore("RMSD") == null) {
            return MultipleAlignmentScorer.getRMSD(this.alignment);
        }
        return this.alignment.getScore("RMSD");
    }

    public QsRelation getRelation() {
        return this.relation;
    }

    public void setRelation(QsRelation relation) {
        this.relation = relation;
    }

    public MultipleAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(MultipleAlignment alignment) {
        this.alignment = alignment;
    }

    public List<Subunit> getAlignedSubunits1() {
        ArrayList<Subunit> aligned = new ArrayList<Subunit>(this.subunitMap.size());
        for (Integer key : this.subunitMap.keySet()) {
            aligned.add(this.subunits1.get(key));
        }
        return aligned;
    }

    public List<Subunit> getAlignedSubunits2() {
        ArrayList<Subunit> aligned = new ArrayList<Subunit>(this.subunitMap.size());
        for (Integer key : this.subunitMap.keySet()) {
            aligned.add(this.subunits2.get(this.subunitMap.get(key)));
        }
        return aligned;
    }

    public void setClusters(List<SubunitCluster> clusters) {
        this.clusters = clusters;
    }

    public Atom[] getAlignedAtomsForSubunits1(int index) {
        for (SubunitCluster cluster : this.clusters) {
            if (!cluster.getSubunits().contains(this.subunits1.get(index))) continue;
            return cluster.getAlignedAtomsSubunit(cluster.getSubunits().indexOf(this.subunits1.get(index)));
        }
        return null;
    }

    public Atom[] getAlignedAtomsForSubunits2(int index) {
        for (SubunitCluster cluster : this.clusters) {
            if (!cluster.getSubunits().contains(this.subunits2.get(index))) continue;
            return cluster.getAlignedAtomsSubunit(cluster.getSubunits().indexOf(this.subunits2.get(index)));
        }
        return null;
    }

    public String toString() {
        return "QsAlignResult [relation=" + String.valueOf((Object)this.relation) + ", rmsd=" + this.getRmsd() + ", length=" + this.length() + ", Aligned 1: " + String.valueOf(this.getAlignedSubunits1().stream().map(s -> s.getName()).collect(Collectors.toList())) + ", Aligned 2: " + String.valueOf(this.getAlignedSubunits2().stream().map(s -> s.getName()).collect(Collectors.toList())) + "]";
    }
}

